/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.datainit;

import com.fr.base.FRContext;
import com.fr.data.dao.DataAccessObjectSession;
import com.fr.data.dao.DataInitJob;
import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.Department;
import com.fr.fs.base.entity.Post;
import com.fr.fs.web.FSConstants;
import java.util.HashMap;
import java.util.List;

public class CompanyRoleDataInitJob
implements DataInitJob {
    private static CompanyRoleDataInitJob SC = new CompanyRoleDataInitJob();

    private CompanyRoleDataInitJob() {
    }

    public static CompanyRoleDataInitJob getInstance() {
        return SC;
    }

    public String errorMessage() {
        return "Default CompanyRole data inited failed!";
    }

    public void initData(DataAccessObjectSession dataAccessObjectSession, boolean bl) throws Exception {
        try {
            Post post;
            Department department;
            dataAccessObjectSession.beginTransaction();
            List list = dataAccessObjectSession.listByFieldValue(Department.class, "name", (Object)FSConstants.COMPANYROLE.DEPARTMENT_ALL_NAME);
            List list2 = dataAccessObjectSession.listByFieldValue(Post.class, "postname", (Object)FSConstants.COMPANYROLE.POST_ALL_NAME);
            if (list.size() <= 0) {
                department = new Department(FSConstants.COMPANYROLE.DEPARTMENT_ALL_NAME, "", -2L);
                dataAccessObjectSession.save((Object)department);
            } else {
                department = (Department)((Object)list.get(0));
            }
            if (list2.size() <= 0) {
                post = new Post(FSConstants.COMPANYROLE.POST_ALL_NAME, "");
                dataAccessObjectSession.save((Object)post);
            } else {
                post = (Post)((Object)list2.get(0));
            }
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            hashMap.put("departmentId", department.getId());
            hashMap.put("postId", post.getId());
            List list3 = dataAccessObjectSession.listByFieldValues(CompanyRole.class, hashMap);
            if (list3.size() <= 0) {
                CompanyRole companyRole = new CompanyRole(post.getId(), department.getId(), "");
                dataAccessObjectSession.save((Object)companyRole);
            }
            dataAccessObjectSession.commit();
        }
        catch (Exception exception) {
            try {
                dataAccessObjectSession.rollback();
            }
            catch (Exception exception2) {
                FRContext.getLogger().error("RollBack Failed : " + exception.getMessage(), (Throwable)exception);
            }
            throw exception;
        }
        finally {
            dataAccessObjectSession.closeTransaction();
        }
    }
}

