/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control;

import com.fr.fs.base.entity.UserDeviceInfo;
import com.fr.fs.cache.UserDeviceInfoCacheImpl;
import com.fr.fs.dao.UserDeviceDao;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StringUtils;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserDeviceControl {
    private static UserDeviceControl udc;

    public static UserDeviceControl getInstance() {
        if (udc == null) {
            udc = new UserDeviceControl();
        }
        return udc;
    }

    public boolean addUserDeviceInfo(UserDeviceInfo userDeviceInfo) throws Exception {
        if (userDeviceInfo == null) {
            return false;
        }
        long l = this.getDeviceId(userDeviceInfo);
        if (l != -1L) {
            userDeviceInfo.setId(l);
        }
        UserDeviceDao.getInstance().saveOrUpdate(userDeviceInfo);
        try {
            UserDeviceInfoCacheImpl.getInstance().cache(userDeviceInfo);
        }
        catch (Exception exception) {
            UserDeviceInfoCacheImpl.getInstance().reInit();
        }
        return userDeviceInfo.getId() >= 0L;
    }

    public boolean removeUserDevice(String string) throws Exception {
        if (StringUtils.isEmpty((String)string)) {
            return false;
        }
        boolean bl = UserDeviceDao.getInstance().deleteByUsername(string);
        if (bl) {
            try {
                UserDeviceInfoCacheImpl.getInstance().removeCache(string);
            }
            catch (Exception exception) {
                UserDeviceInfoCacheImpl.getInstance().reInit();
            }
            return true;
        }
        return false;
    }

    public JSONObject getSortedUserDeviceJSONObject() throws JSONException {
        return UserDeviceInfoCacheImpl.getInstance().getSortedUserDeviceJSONObject();
    }

    public List<UserDeviceInfo> findDeviceInfoByMacAddress(String string) {
        return UserDeviceDao.getInstance().findDeviceInfoByMacAddress(string);
    }

    public UserDeviceInfo findDeviceInfoByUM(String string, String string2) {
        return UserDeviceDao.getInstance().findDeviceInfoByUM(string, string2);
    }

    public List<UserDeviceInfo> findDeviceInfosByUsername(String string) {
        return UserDeviceInfoCacheImpl.getInstance().getAllUserDeviceInfoByName(string);
    }

    public JSONArray getDeviceJsonByUsername(String string) throws JSONException {
        return UserDeviceInfoCacheImpl.getInstance().getAllUserDeviceJsonByName(string);
    }

    public void updateByMacAddress(UserDeviceInfo userDeviceInfo) throws Exception {
        UserDeviceDao.getInstance().update(userDeviceInfo);
        UserDeviceInfoCacheImpl.getInstance().updateByMacAddress(userDeviceInfo);
    }

    public void unbind(String string, String string2, boolean bl) throws Exception {
        UserDeviceDao.getInstance().unbind(string, string2, bl);
        UserDeviceInfoCacheImpl.getInstance().unbind(string, string2, bl);
    }

    public void bind(String string, String string2, String string3) throws Exception {
        UserDeviceDao.getInstance().bind(string, string2, string3);
        UserDeviceInfoCacheImpl.getInstance().bind(string, string2, string3);
    }

    public Set<String> findAllUsers() {
        return UserDeviceInfoCacheImpl.getInstance().getAllUsers();
    }

    public void dealWithOldMacAddress(String string, String string2, String string3) throws Exception {
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        if (StringUtils.isEmpty((String)string2) || StringUtils.isEmpty((String)string3)) {
            return;
        }
        List<UserDeviceInfo> list = UserDeviceInfoCacheImpl.getInstance().getAllUserDeviceInfoByName(string);
        for (UserDeviceInfo userDeviceInfo : list) {
            if (!userDeviceInfo.getMacAddress().equalsIgnoreCase(string2)) continue;
            userDeviceInfo.setMacAddress(string3);
            UserDeviceDao.getInstance().update(userDeviceInfo);
            return;
        }
    }

    public boolean checkDeviceAuth(String string, String string2) throws Exception {
        if (StringUtils.isEmpty((String)string) || StringUtils.isEmpty((String)string2)) {
            return false;
        }
        List<UserDeviceInfo> list = UserDeviceInfoCacheImpl.getInstance().getAllUserDeviceInfoByName(string);
        for (UserDeviceInfo userDeviceInfo : list) {
            if (!ComparatorUtils.equalsIgnoreCase((String)userDeviceInfo.getMacAddress(), (String)string2) || !userDeviceInfo.isPassed()) continue;
            return true;
        }
        return false;
    }

    public boolean containCache(String string) {
        return UserDeviceInfoCacheImpl.getInstance().containCache(string);
    }

    public long getDeviceId(UserDeviceInfo userDeviceInfo) {
        return UserDeviceInfoCacheImpl.getInstance().getDeviceId(userDeviceInfo);
    }
}

