/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control;

import com.fr.fs.FSConfig;
import com.fr.fs.base.entity.PlatformManageModule;
import com.fr.fs.base.entity.RoleModulePrivilege;
import com.fr.fs.cache.ModuleCacheImpl;
import com.fr.fs.control.UserControl;
import com.fr.json.JSONArray;
import com.fr.plugin.ExtraClassManager;
import com.fr.stable.ReportFunctionProcessor;
import com.fr.stable.fun.FunctionProcessor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleControl {
    private static ModuleControl mc;

    public static ModuleControl getInstance() {
        if (mc == null) {
            mc = new ModuleControl();
        }
        return mc;
    }

    public List<RoleModulePrivilege> getAllRoleModulePrivilege() {
        List<PlatformManageModule> list = ModuleCacheImpl.getInstance().getAllModules();
        ArrayList<RoleModulePrivilege> arrayList = new ArrayList<RoleModulePrivilege>();
        if (list != null) {
            for (PlatformManageModule platformManageModule : list) {
                if (platformManageModule.getId() <= 1L) continue;
                RoleModulePrivilege roleModulePrivilege = new RoleModulePrivilege(platformManageModule.getId(), 1L, 1L);
                arrayList.add(roleModulePrivilege);
            }
        }
        return arrayList;
    }

    public JSONArray getModuleRootShowInfo(long l) throws Exception {
        return ModuleCacheImpl.getInstance().getModuleRootShowInfo(l);
    }

    public JSONArray getAuthorizedModuleItems(long l) throws Exception {
        Set set = UserControl.getInstance().getAllModulePrivileges(l);
        HashSet<RoleModulePrivilege> hashSet = new HashSet<RoleModulePrivilege>();
        for (RoleModulePrivilege roleModulePrivilege : set) {
            if (!this.hasNoAuthority(roleModulePrivilege)) continue;
            hashSet.add(roleModulePrivilege);
        }
        set.removeAll(hashSet);
        return ModuleCacheImpl.getInstance().getAuthorizedModuleItemsFromPrivilegeSet(set);
    }

    private boolean hasNoAuthority(RoleModulePrivilege roleModulePrivilege) {
        boolean bl = FSConfig.getProviderInstance().getAuthorizeAttr().isGradeAuthority() && (roleModulePrivilege.getAuthorized() == 0L || roleModulePrivilege.getModuleid() <= 1L);
        FunctionProcessor functionProcessor = ExtraClassManager.getInstance().getFunctionProcessor();
        if (bl && functionProcessor != null) {
            functionProcessor.recordFunction(ReportFunctionProcessor.MULTI_PRIVILEGE);
        }
        return bl;
    }
}

