/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.cache;

import com.fr.data.dao.RelationObject;
import com.fr.fs.FSConfig;
import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.RoleDataConnectionPrivilege;
import com.fr.fs.base.entity.RoleDepAndCRolePrivilege;
import com.fr.fs.base.entity.RoleESPrivilege;
import com.fr.fs.base.entity.RoleEntryPrivilege;
import com.fr.fs.base.entity.RoleHomePagePrivilege;
import com.fr.fs.base.entity.RoleModulePrivilege;
import com.fr.fs.base.entity.RoleTemplatePrivilege;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.fs.cache.IDLockCreator;
import com.fr.fs.cache.RoleCacheInfo;
import com.fr.fs.cache.RoleCacheUtils;
import com.fr.fs.control.dao.CompanyRoleDAO;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompanyRoleCache {
    private static final Map<Long, RoleCacheInfo> ROLE_MAP = new Hashtable<Long, RoleCacheInfo>(128);
    private static List<CompanyRole> COMPANY_ROLE_LIST = new ArrayList<CompanyRole>();
    private static final IDLockCreator COMPANY_ROLE_ID_LOCK_CREATOR = new IDLockCreator();

    public static boolean containCache(long l) {
        return ROLE_MAP.containsKey(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initCache() throws Exception {
        Map<Long, RoleCacheInfo> map = ROLE_MAP;
        synchronized (map) {
            if (ROLE_MAP.isEmpty()) {
                try {
                    COMPANY_ROLE_LIST = FSConfig.getProviderInstance().getControl().getCompanyRoleDAO().findAll();
                    if (COMPANY_ROLE_LIST != null) {
                        for (CompanyRole companyRole : COMPANY_ROLE_LIST) {
                            CompanyRoleCache.cache(companyRole);
                        }
                    }
                }
                catch (Exception exception) {
                    ROLE_MAP.clear();
                    throw exception;
                }
            }
        }
    }

    public static List<CompanyRole> getAllCompanyRole() {
        try {
            CompanyRoleCache.initCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return COMPANY_ROLE_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reInitCache() throws Exception {
        Map<Long, RoleCacheInfo> map = ROLE_MAP;
        synchronized (map) {
            ROLE_MAP.clear();
            CompanyRoleCache.initCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() throws Exception {
        Map<Long, RoleCacheInfo> map = ROLE_MAP;
        synchronized (map) {
            ROLE_MAP.clear();
        }
    }

    private static void cache(CompanyRole companyRole) throws Exception {
        if (companyRole != null && companyRole.getId() >= 0L) {
            RoleCacheInfo roleCacheInfo = CompanyRoleCache.createCompanyRoleCacheInfo(companyRole);
            ROLE_MAP.put(companyRole.getId(), roleCacheInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cacheNew(CompanyRole companyRole) throws Exception {
        CompanyRoleCache.initCache();
        if (companyRole != null && companyRole.getId() >= 0L) {
            Object object = COMPANY_ROLE_ID_LOCK_CREATOR.getIDLock(companyRole.getId());
            try {
                Object object2 = object;
                synchronized (object2) {
                    block10: {
                        if (!ROLE_MAP.containsKey(companyRole.getId())) break block10;
                        return;
                    }
                    RoleCacheInfo roleCacheInfo = new RoleCacheInfo();
                    ROLE_MAP.put(companyRole.getId(), roleCacheInfo);
                    if (!COMPANY_ROLE_LIST.contains((Object)companyRole)) {
                        COMPANY_ROLE_LIST.add(companyRole);
                    }
                }
            }
            finally {
                COMPANY_ROLE_ID_LOCK_CREATOR.releaseIDLock();
            }
        }
    }

    private static RoleCacheInfo createCompanyRoleCacheInfo(CompanyRole companyRole) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        RoleCacheInfo roleCacheInfo = new RoleCacheInfo();
        CompanyRoleDAO companyRoleDAO = FSConfig.getProviderInstance().getControl().getCompanyRoleDAO();
        Set<RoleEntryPrivilege> set = companyRoleDAO.getEntryPrivileges(companyRole.getId());
        if (set != null) {
            object7 = set.iterator();
            while (object7.hasNext()) {
                object6 = (RoleEntryPrivilege)((Object)object7.next());
                roleCacheInfo.entryPrivilegeSet.add(EntryTypeAndID.getInstance(((RoleEntryPrivilege)((Object)object6)).getType(), ((RoleEntryPrivilege)((Object)object6)).getEntryid(), ((RoleEntryPrivilege)((Object)object6)).getView(), ((RoleEntryPrivilege)((Object)object6)).getAuthorized(), ((RoleEntryPrivilege)((Object)object6)).getEdit()));
            }
        }
        if ((object7 = companyRoleDAO.getESPrivileges(companyRole.getId())) != null) {
            object6 = object7.iterator();
            while (object6.hasNext()) {
                object5 = (RoleESPrivilege)((Object)object6.next());
                roleCacheInfo.ESPrivilegeSet.add(EntryTypeAndID.getInstance(((RoleESPrivilege)((Object)object5)).getType(), ((RoleESPrivilege)((Object)object5)).getEntryID()));
            }
        }
        if ((object6 = companyRoleDAO.getModulePrivileges(companyRole.getId())) != null) {
            object5 = object6.iterator();
            while (object5.hasNext()) {
                object4 = (RoleModulePrivilege)((Object)object5.next());
                roleCacheInfo.moduleSet.add((RoleModulePrivilege)((Object)object4));
            }
        }
        if ((object5 = companyRoleDAO.getHomePagePrivileges(companyRole.getId())) != null) {
            object4 = object5.iterator();
            while (object4.hasNext()) {
                object3 = (RoleHomePagePrivilege)((Object)object4.next());
                roleCacheInfo.homePagePrivilegeSet.add((RoleHomePagePrivilege)((Object)object3));
            }
        }
        if ((object4 = companyRoleDAO.getDepAndCrolePrivileges(companyRole.getId())) != null) {
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (RoleDepAndCRolePrivilege)((Object)object3.next());
                roleCacheInfo.deptAndCustomRolePrivilegeSet.add((RoleDepAndCRolePrivilege)((Object)object2));
            }
        }
        if ((object3 = companyRoleDAO.getTemplatePrivileges(companyRole.getId())) != null) {
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (RoleTemplatePrivilege)((Object)object2.next());
                roleCacheInfo.templateSet.add((RoleTemplatePrivilege)((Object)object));
            }
        }
        if ((object2 = companyRoleDAO.getDataConnectionPrivileges(companyRole.getId())) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                RoleDataConnectionPrivilege roleDataConnectionPrivilege = (RoleDataConnectionPrivilege)((Object)object.next());
                roleCacheInfo.dataConnectionSet.add(roleDataConnectionPrivilege);
            }
        }
        roleCacheInfo.addPrivileges4Plates(companyRole.getId(), true);
        return roleCacheInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCache(long l) {
        if (l >= 0L) {
            Object object = COMPANY_ROLE_ID_LOCK_CREATOR.getIDLock(l);
            try {
                Object object2 = object;
                synchronized (object2) {
                    ROLE_MAP.remove(l);
                    for (CompanyRole companyRole : COMPANY_ROLE_LIST) {
                        if (companyRole.getId() != l) continue;
                        COMPANY_ROLE_LIST.remove((Object)companyRole);
                    }
                }
            }
            finally {
                COMPANY_ROLE_ID_LOCK_CREATOR.releaseIDLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<EntryTypeAndID> getAllEntryPrivileges(long l) {
        try {
            CompanyRoleCache.initCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RoleCacheInfo roleCacheInfo = ROLE_MAP.get(l);
        ArrayList<EntryTypeAndID> arrayList = new ArrayList<EntryTypeAndID>();
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                Set<EntryTypeAndID> set = roleCacheInfo.entryPrivilegeSet;
                for (EntryTypeAndID entryTypeAndID : set) {
                    arrayList.add(EntryTypeAndID.getInstance(entryTypeAndID.getType(), entryTypeAndID.getId(), entryTypeAndID.getView(), entryTypeAndID.getAuthorized(), entryTypeAndID.getEdit()));
                }
                return arrayList;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getAllESPrivilegeDescriptions(long l) {
        try {
            CompanyRoleCache.initCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RoleCacheInfo roleCacheInfo = ROLE_MAP.get(l);
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                ArrayList<String> arrayList = new ArrayList<String>();
                Set<EntryTypeAndID> set = roleCacheInfo.ESPrivilegeSet;
                for (EntryTypeAndID entryTypeAndID : set) {
                    arrayList.add(entryTypeAndID.getType() + "" + entryTypeAndID.getId());
                }
                return arrayList;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<RoleModulePrivilege> getAllModulePrivileges(long l) {
        try {
            CompanyRoleCache.initCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RoleCacheInfo roleCacheInfo = ROLE_MAP.get(l);
        ArrayList<RoleModulePrivilege> arrayList = new ArrayList<RoleModulePrivilege>();
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                Set<RoleModulePrivilege> set = roleCacheInfo.moduleSet;
                for (RoleModulePrivilege roleModulePrivilege : set) {
                    arrayList.add(roleModulePrivilege);
                }
                return arrayList;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<RoleHomePagePrivilege> getAllHomePagePrivileges(long l) {
        try {
            CompanyRoleCache.initCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RoleCacheInfo roleCacheInfo = ROLE_MAP.get(l);
        ArrayList<RoleHomePagePrivilege> arrayList = new ArrayList<RoleHomePagePrivilege>();
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                Set<RoleHomePagePrivilege> set = roleCacheInfo.homePagePrivilegeSet;
                for (RoleHomePagePrivilege roleHomePagePrivilege : set) {
                    if (roleHomePagePrivilege.getView() <= 0L) continue;
                    arrayList.add(roleHomePagePrivilege);
                }
                return arrayList;
            }
        }
        return arrayList;
    }

    public static List<RoleTemplatePrivilege> getAllTemplatePrivileges(long l) {
        try {
            CompanyRoleCache.initCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RoleCacheInfo roleCacheInfo = ROLE_MAP.get(l);
        ArrayList<RoleTemplatePrivilege> arrayList = new ArrayList<RoleTemplatePrivilege>();
        if (roleCacheInfo != null) {
            Set<RoleTemplatePrivilege> set = roleCacheInfo.templateSet;
            for (RoleTemplatePrivilege roleTemplatePrivilege : set) {
                arrayList.add(roleTemplatePrivilege);
            }
        }
        return arrayList;
    }

    public static Set<RoleDataConnectionPrivilege> getAllDataConnectionPrivileges(long l) {
        try {
            CompanyRoleCache.initCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RoleCacheInfo roleCacheInfo = ROLE_MAP.get(l);
        Set<RoleDataConnectionPrivilege> set = new HashSet<RoleDataConnectionPrivilege>();
        if (roleCacheInfo != null) {
            set = roleCacheInfo.dataConnectionSet;
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<RoleDepAndCRolePrivilege> getAllDepAndCRolePrivileges(long l) {
        try {
            CompanyRoleCache.initCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RoleCacheInfo roleCacheInfo = ROLE_MAP.get(l);
        ArrayList<RoleDepAndCRolePrivilege> arrayList = new ArrayList<RoleDepAndCRolePrivilege>();
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                Set<RoleDepAndCRolePrivilege> set = roleCacheInfo.deptAndCustomRolePrivilegeSet;
                for (RoleDepAndCRolePrivilege roleDepAndCRolePrivilege : set) {
                    arrayList.add(roleDepAndCRolePrivilege);
                }
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getAllDepAndCRolePrivilegeDescriptions(long l) {
        try {
            CompanyRoleCache.initCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RoleCacheInfo roleCacheInfo = ROLE_MAP.get(l);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                Set<RoleDepAndCRolePrivilege> set = roleCacheInfo.deptAndCustomRolePrivilegeSet;
                for (RoleDepAndCRolePrivilege roleDepAndCRolePrivilege : set) {
                    arrayList.add(roleDepAndCRolePrivilege.getType() + "" + roleDepAndCRolePrivilege.getDeporcroleid());
                }
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAllPrivilegesWithPlateName(long l, String string) {
        try {
            CompanyRoleCache.initCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RoleCacheInfo roleCacheInfo = ROLE_MAP.get(l);
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                ArrayList<String> arrayList = new ArrayList<String>();
                Set<String> set = roleCacheInfo.getPlatePrivilege(string);
                if (set == null) {
                    return null;
                }
                Iterator<String> iterator = set.iterator();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
                return arrayList;
            }
        }
        return null;
    }

    public static boolean containModulePrivilege(long l, long l2) {
        if (ROLE_MAP.isEmpty()) {
            return false;
        }
        return RoleCacheUtils.containModulePrivilege(ROLE_MAP, l, l2);
    }

    public static boolean containHomePagePrivilege(long l, long l2) {
        return RoleCacheUtils.containHomePagePrivilege(ROLE_MAP, l, l2);
    }

    public static boolean containEntryPrivilege(long l, int n, long l2) {
        return RoleCacheUtils.containEntryPrivilege(ROLE_MAP, l, n, l2);
    }

    public static boolean containPlatePrivilege(long l, long l2, String string) {
        return RoleCacheUtils.containPlatePrivilege(ROLE_MAP, l, l2, string);
    }

    public static void refreshModulePrivileges(long l, Set<RoleModulePrivilege> set) {
        RoleCacheUtils.refreshModulePrivileges(ROLE_MAP, l, set);
    }

    public static void refreshHomePagePrivileges(long l, Set<RoleHomePagePrivilege> set) {
        RoleCacheUtils.refreshHomePagePrivileges(ROLE_MAP, l, set);
    }

    public static void refreshTemplatePrivileges(long l, Set<RoleTemplatePrivilege> set) {
        RoleCacheUtils.refreshTemplatePrivileges(ROLE_MAP, l, set);
    }

    public static void refreshEntryPrivileges(long l, Set<RoleEntryPrivilege> set) {
        RoleCacheUtils.refreshEntryPrivileges(ROLE_MAP, l, set);
    }

    public static void refreshDepAndCrolePrivileges(long l, Set<RoleDepAndCRolePrivilege> set) {
        RoleCacheUtils.refreshDepAndCRolePrivileges(ROLE_MAP, l, set);
    }

    public static void refreshDataConnectionPrivileges(long l, Set<RoleDataConnectionPrivilege> set) {
        RoleCacheUtils.refreshDataConnectionPrivileges(ROLE_MAP, l, set);
    }

    public static void refreshESPrivileges(long l, Set<RoleESPrivilege> set) {
        RoleCacheUtils.refreshESPrivileges(ROLE_MAP, l, set);
    }

    public static void refreshPrivilegesWithPlateName(long l, Set<RelationObject> set, String string) {
        RoleCacheUtils.refreshPlatePrivileges(ROLE_MAP, l, set, string);
    }

    public static void refreshEntryPrivileges(long l, int n, long l2, long l3) {
        RoleCacheUtils.refreshEntryPrivileges(ROLE_MAP, l, n, l2, l3);
    }
}

