/*
 * Decompiled with CFR 0.152.
 */
package com.fr.performance.memory;

import com.fr.performance.memory.ConfigBean;
import com.fr.performance.memory.MemoryManager;
import com.fr.performance.memory.MemoryMonitor;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;

public class MemoryConfig {
    private static ConfigBean configBean = new ConfigBean();
    private static final Object LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void init() {
        Object object = LOCK;
        synchronized (object) {
            MemoryConfig.loadXmlConfig();
            MemoryConfig.refresh();
        }
    }

    private static void loadXmlConfig() {
        MemoryConfig.setConfigBean(MemoryConfig.getXMLConfig());
    }

    static void refresh() {
        MemoryConfig.refreshMemoryMXBean();
        MemoryConfig.refreshMemoryMonitor();
    }

    private static void refreshMemoryMonitor() {
        MemoryMonitor.setMonitorEnable(configBean.isMonitor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void refreshMemoryMXBean() {
        Object object = LOCK;
        synchronized (object) {
            MemoryPoolMXBean memoryPoolMXBean = MemoryManager.getTenuredMemoryPool();
            MemoryConfig.setUsageThreshold(memoryPoolMXBean);
        }
    }

    static void setUsageThreshold(MemoryPoolMXBean memoryPoolMXBean) {
        if (!MemoryManager.checkValid(memoryPoolMXBean)) {
            return;
        }
        MemoryUsage memoryUsage = memoryPoolMXBean.getUsage();
        long l = memoryUsage.getMax();
        long l2 = MemoryConfig.calculateThreshold(l);
        if (l2 != 0L) {
            memoryPoolMXBean.setUsageThreshold(l2);
        }
    }

    static long calculateThreshold(long l) {
        long l2 = 0L;
        if (configBean.getUseThreshold() > 0L) {
            l2 = Math.min(configBean.getUseThreshold(), l);
        } else if (configBean.getUseThresholdPercent() > 0) {
            l2 = l * (long)configBean.getUseThresholdPercent() / 100L;
        } else {
            return 0L;
        }
        l2 = Math.max(0L, Math.min(l2, l));
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setConfigBean(ConfigBean configBean) {
        Object object = LOCK;
        synchronized (object) {
            MemoryConfig.configBean = configBean;
        }
    }

    static ConfigBean getXMLConfig() {
        ConfigBean configBean = new ConfigBean();
        configBean.setUseThresholdPercent(80);
        return configBean;
    }
}

