/*
 * Decompiled with CFR 0.152.
 */
package com.fr.performance.info;

import com.fr.general.ComparatorUtils;
import com.fr.json.JSONObject;
import com.fr.performance.info.InfoUtils;
import com.fr.performance.info.PerformanceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellInfo
implements PerformanceInfo,
Comparable<CellInfo> {
    private String name;
    private long calculateTime;
    private long presentTime;
    private long highlightTime;
    private long hyperlinkTime;
    private long filterTime;
    private long dynamicParaTime;
    private static final String[] INFO_NAME = new String[]{"calculateTime", "presentTime"};
    static final int MILLION = 1000000;

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public long getCalculateTime() {
        return this.calculateTime;
    }

    public void setCalculateTime(long l) {
        this.calculateTime = l;
    }

    public long getPresentTime() {
        return this.presentTime;
    }

    public void addPresentTime(long l) {
        this.presentTime += l;
    }

    public long getHighlightTime() {
        return this.highlightTime;
    }

    public void addHighlightTime(long l) {
        this.highlightTime += l;
    }

    public long getHyperlinkTime() {
        return this.hyperlinkTime;
    }

    public void addHyperlinkTime(long l) {
        this.hyperlinkTime += l;
    }

    public JSONObject createJSON() throws Exception {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("name", (Object)this.name);
        jSONObject.put("totalTime", this.getTotalTime());
        jSONObject.put("calculateTime", this.calculateTime / 1000000L);
        jSONObject.put("present", this.presentTime / 1000000L);
        jSONObject.put("highLight", this.highlightTime / 1000000L);
        jSONObject.put("hyperlink", this.hyperlinkTime / 1000000L);
        jSONObject.put("filter", this.filterTime / 1000000L);
        jSONObject.put("dynamicPara", this.dynamicParaTime / 1000000L);
        return jSONObject;
    }

    private long getTotalTime() {
        return (this.calculateTime + this.presentTime + this.highlightTime + this.hyperlinkTime) / 1000000L;
    }

    public void parseJSON(JSONObject jSONObject) throws Exception {
        this.setName(jSONObject.getString("name"));
        this.setCalculateTime(jSONObject.getLong("calculateTime") * 1000000L);
        this.addPresentTime(jSONObject.getLong("present") * 1000000L);
        this.addHighlightTime(jSONObject.getLong("highLight") * 1000000L);
        this.addHyperlinkTime(jSONObject.getLong("hyperlink") * 1000000L);
        this.addFilterTime(jSONObject.getLong("filter") * 1000000L);
        this.addFilterTime(jSONObject.getLong("dynamicPara") * 1000000L);
    }

    public String toString() {
        return this.toJSONString();
    }

    public String toJSONString() {
        return InfoUtils.toJSONString(this);
    }

    @Override
    public int compareTo(CellInfo cellInfo) {
        return -ComparatorUtils.compare((double)this.getTotalTime(), (double)cellInfo.getTotalTime());
    }

    public void addFilterTime(long l) {
        this.filterTime += l;
    }

    public void addDynamicParameterTime(long l) {
        this.dynamicParaTime += l;
    }
}

