/*
 * Decompiled with CFR 0.152.
 */
package ideabank.sap;

import ideabank.sap.Tools;
import ideabank.sap.UserBean;
import ideabank.sap.miTM;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class IAccount {
    private UserBean userbean;
    private String AAAAServer;
    private String LoginServer;
    private String ApplyID;
    private String ApplyKey;
    private String WorkPath;
    private HostnameVerifier hv = new HostnameVerifier(){

        public boolean verify(String urlHostName, SSLSession session) {
            return true;
        }
    };
    private HttpServletRequest request;
    private HttpServletResponse response;

    public IAccount(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
        this.trustAllHttpsCertificates();
        HttpsURLConnection.setDefaultHostnameVerifier(this.hv);
    }

    public void SetManager(String AAAAServer, String LoginServer, String ApplyID, String ApplyKey, String WorkPath) {
        this.AAAAServer = AAAAServer;
        this.ApplyID = ApplyID;
        this.ApplyKey = ApplyKey;
        this.LoginServer = LoginServer;
        this.WorkPath = WorkPath;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean CheckCertLogin() throws Exception {
        String TrusDataID = this.request.getParameter("TrusDataID");
        String TrusDataTicket = this.request.getParameter("TrusDataTicket");
        if (TrusDataID != null && TrusDataTicket != null) {
            Cookie cTrusDataID = new Cookie("TrusDataID", TrusDataID);
            Cookie cTrusDataTicket = new Cookie("TrusDataTicket", TrusDataTicket);
            this.response.addCookie(cTrusDataID);
            this.response.addCookie(cTrusDataTicket);
            this.response.sendRedirect(this.getUrlNow(false));
            return false;
        } else {
            Cookie[] cookies = this.request.getCookies();
            if (cookies != null) {
                int i = 0;
                while (i < cookies.length) {
                    Cookie c = cookies[i];
                    if ("TrusDataID".equals(c.getName())) {
                        TrusDataID = c.getValue();
                    } else if ("TrusDataTicket".equals(c.getName())) {
                        TrusDataTicket = c.getValue();
                    }
                    ++i;
                }
                String temp = "https://" + this.AAAAServer + "/login.aaaauth?operation=sso&trusdataid=" + TrusDataID + "&appid=" + this.ApplyID + "&summary=" + Tools.EncoderByMd5(String.valueOf(TrusDataTicket) + this.ApplyKey);
                URL url = new URL(temp);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                int statusCode = 0;
                statusCode = connection.getResponseCode();
                if (statusCode == 200) {
                    BufferedReader input = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    String rs = input.readLine();
                    this.setUserBean(rs);
                    return true;
                }
                this.response.getWriter().println("\u767b\u9646\u5931\u8d25");
                return false;
            }
            String url = "https://" + this.LoginServer + "/login.aaaauth?operation=ic_auth&appid=" + this.ApplyID + "&url=" + Tools.getBASE64(this.getUrlNow(true));
            this.response.sendRedirect(url);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean CheckUserLogin() throws Exception {
        String TrusDataID = this.request.getParameter("TrusDataID");
        String TrusDataTicket = this.request.getParameter("TrusDataTicket");
        if (TrusDataID != null && TrusDataTicket != null) {
            Cookie cTrusDataID = new Cookie("TrusDataID", TrusDataID);
            Cookie cTrusDataTicket = new Cookie("TrusDataTicket", TrusDataTicket);
            this.response.addCookie(cTrusDataID);
            this.response.addCookie(cTrusDataTicket);
            this.response.sendRedirect(this.getUrlNow(false));
            return false;
        } else {
            Cookie[] cookies = this.request.getCookies();
            if (cookies != null) {
                int i = 0;
                while (i < cookies.length) {
                    Cookie c = cookies[i];
                    if ("TrusDataID".equals(c.getName())) {
                        TrusDataID = c.getValue();
                    } else if ("TrusDataTicket".equals(c.getName())) {
                        TrusDataTicket = c.getValue();
                    }
                    ++i;
                }
                String temp = "https://" + this.AAAAServer + "/login.aaaauth?operation=sso&trusdataid=" + TrusDataID + "&appid=" + this.ApplyID + "&summary=" + Tools.EncoderByMd5(String.valueOf(TrusDataTicket) + this.ApplyKey);
                URL url = new URL(temp);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                int statusCode = 0;
                statusCode = connection.getResponseCode();
                if (statusCode == 200) {
                    BufferedReader input = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    String rs = input.readLine();
                    this.setUserBean(rs);
                    return true;
                }
                this.response.getWriter().println("\u767b\u9646\u5931\u8d25");
                return false;
            }
            String url = "https://" + this.LoginServer + "/login.aaaauth?operation=basic_auth&appid=" + this.ApplyID + "&url=" + Tools.getBASE64(this.getUrlNow(true));
            this.response.sendRedirect(url);
        }
        return false;
    }

    private void trustAllHttpsCertificates() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[1];
            miTM tm = new miTM();
            trustAllCerts[0] = tm;
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getUrlNow(boolean isQuery) {
        String url = String.valueOf(this.request.getScheme()) + "://";
        url = String.valueOf(url) + this.request.getHeader("host");
        url = String.valueOf(url) + this.request.getRequestURI();
        if (isQuery && this.request.getQueryString() != null) {
            url = String.valueOf(url) + "?" + this.request.getQueryString();
        }
        return url;
    }

    public void Logout() throws Exception {
        String TrusDataID = "";
        String TrusDataTicket = "";
        this.trustAllHttpsCertificates();
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null) {
            int i = 0;
            while (i < cookies.length) {
                Cookie c = cookies[i];
                if ("TrusDataID".equals(c.getName())) {
                    TrusDataID = c.getValue();
                } else if ("TrusDataTicket".equals(c.getName())) {
                    TrusDataTicket = c.getValue();
                }
                ++i;
            }
        }
        if (TrusDataID.length() > 0 && TrusDataTicket.length() > 0) {
            String urltemp = "https://" + this.LoginServer + "/login.aaaauth?operation=loginout";
            this.response.sendRedirect(urltemp);
        } else {
            this.response.sendRedirect("https://" + this.LoginServer + "/login.aaaauth?operation=login&url=Lw==");
        }
    }

    public boolean Authorize(String FunctionID) throws Exception {
        String TrusDataID = "";
        String TrusDataTicket = "";
        this.trustAllHttpsCertificates();
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null) {
            int i = 0;
            while (i < cookies.length) {
                Cookie c = cookies[i];
                if ("TrusDataID".equals(c.getName())) {
                    TrusDataID = c.getValue();
                } else if ("TrusDataTicket".equals(c.getName())) {
                    TrusDataTicket = c.getValue();
                }
                ++i;
            }
        }
        if (TrusDataID.length() > 0 && TrusDataTicket.length() > 0) {
            String urltemp = "https://" + this.AAAAServer + "/login.aaaauth?" + "operation=myauthorize&" + "trusdataid=" + TrusDataID + "&" + "appid=" + this.ApplyID + "&" + "functionid=" + Tools.getBASE64(FunctionID);
            URL url = new URL(urltemp);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            int statusCode = 0;
            statusCode = connection.getResponseCode();
            if (statusCode == 200) {
                return true;
            }
        } else {
            this.response.sendRedirect("https://" + this.AAAAServer + "/");
        }
        return false;
    }

    public boolean Audit(String OperateType, String OperateInfo, String OperateStatus, String codeType) throws Exception {
        String TrusDataID = "";
        String TrusDataTicket = "";
        this.trustAllHttpsCertificates();
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null) {
            int i = 0;
            while (i < cookies.length) {
                Cookie c = cookies[i];
                if ("TrusDataID".equals(c.getName())) {
                    TrusDataID = c.getValue();
                } else if ("TrusDataTicket".equals(c.getName())) {
                    TrusDataTicket = c.getValue();
                }
                ++i;
            }
        }
        if (TrusDataID.length() > 0 && TrusDataTicket.length() > 0) {
            String urltemp = "https://" + this.AAAAServer + "/login.aaaauth?" + "operation=myaudit&" + "trusdataid=" + TrusDataID + "&" + "operatetype=" + OperateType + "&" + "operateinfo=" + OperateInfo + "&" + "operatestaus=" + OperateStatus + "&" + "appid=" + this.ApplyID + "&" + "codetype=" + codeType;
            URL url = new URL(urltemp);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            int statusCode = 0;
            statusCode = connection.getResponseCode();
            if (statusCode == 200) {
                return true;
            }
        } else {
            this.response.sendRedirect("https://" + this.LoginServer + "/");
        }
        return false;
    }

    private void setUserBean(String rs) {
        this.userbean = new UserBean();
        String[] sArray = rs.split("&");
        int i = 0;
        while (i < sArray.length) {
            String oname = sArray[i].split("=")[0];
            String ovalue = sArray[i].split("=")[1];
            if (oname.equals("UserID")) {
                this.userbean.setUserID(ovalue);
            } else if (oname.equals("DefaultUserName")) {
                this.userbean.setDefaultUserName(ovalue);
            } else if (oname.equals("Mail")) {
                this.userbean.setMail(ovalue);
            } else if (oname.equals("Telephone")) {
                this.userbean.setTelephone(ovalue);
            } else if (oname.equals("Unit")) {
                this.userbean.setUnit(ovalue);
            } else if (oname.equals("Organize")) {
                this.userbean.setOrganize(ovalue);
            } else if (oname.equals("AppUserName")) {
                this.userbean.setAppUserName(ovalue);
            } else if (oname.equals("AppPassWord")) {
                this.userbean.setAppPassWord(ovalue);
            }
            ++i;
        }
    }

    public UserBean getUserBean() {
        return this.userbean;
    }
}

