package com.jshx.zzhxm.service.impl;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.zzhgl.dao.ZzhglDao;
import com.jshx.zzhgl.entity.Zzh;
import com.jshx.zzhxm.dao.*;
import com.jshx.zzhxm.entity.*;
import com.jshx.zzhxm.service.ZzhxmJktzsService;
import com.jshx.zzhxmhistory.dao.ZzhxmHistoryDao;
import com.jshx.zzhxmhistory.entity.ZzhxmHistory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("zzhxmjktzsService")
public class ZzhxmJktzsServiceImpl extends BaseServiceImpl implements ZzhxmJktzsService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("zzhxmjktzsDao")
	private ZzhxmJktzsDao zzhxmJktzsDao;
	@Autowired()
	@Qualifier("zzhxmJktzsHistoryDao")
	private ZzhxmJktzsHistoryDao zzhxmJktzsHistoryDao;
	@Autowired()
	@Qualifier("zzhglDao")
	private ZzhglDao zzhglDao;
	@Autowired()
	@Qualifier("zzhxmDao")
	private ZzhxmDao zzhxmDao;
	@Autowired()
	@Qualifier("zzhxmSfxxDao")
	private ZzhxmSfxxDao zzhxmSfxxDao;
	@Autowired()
	@Qualifier("zzhxmSfxxHistoryDao")
	private ZzhxmSfxxHistoryDao zzhxmSfxxHistoryDao;
	@Autowired()
	@Qualifier("zzhxmHistoryDao")
	private ZzhxmHistoryDao zzhxmHistoryDao;
	@Autowired()
	@Qualifier("yzsmaterialcolDao")
	private YzsMaterialColDao yzsMaterialColDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return zzhxmJktzsDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public ZzhxmJktzs getById(String id)
	{
		return zzhxmJktzsDao.getById(id);
	}

	public YzsMaterialCol getByYzsId(String id)
	{
		return yzsMaterialColDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param zzhxmJktzs 信息
	 */
	@Transactional
	public void save(ZzhxmJktzs zzhxmJktzs)
	{
		zzhxmJktzsDao.save(zzhxmJktzs);
	}

	@Transactional
	public void save(YzsMaterialCol yzsMaterialCol)
	{
		yzsMaterialColDao.save(yzsMaterialCol);
	}

	/**
	 * 接口1保存信息
	 * @param zzhxmJktzs
	 * @param zzhxmSfxxListzl
	 * @param zzh
	 */
	@Transactional
	@Override
	public void saveJK1(ZzhxmJktzs zzhxmJktzs,List<ZzhxmSfxx> zzhxmSfxxListzl,Zzh zzh) {
		//保存项目表
//		zzhxmDao.save(zzhxm);
		// 保存缴款通知书表
		zzhxmJktzsDao.save(zzhxmJktzs);
		// 保存ZzhxmSfxx表
		for(int i=0;i<zzhxmSfxxListzl.size();i++){
			ZzhxmSfxx zzhxmSfxxi = zzhxmSfxxListzl.get(i);
			zzhxmSfxxDao.save(zzhxmSfxxi);
		}
		//更新子账户表
		zzhglDao.update(zzh);
	}

	/**
	 * 接口2保存信息
	 * @param zzh
	 * @param zzhxmJktzs
	 */
	@Transactional
	@Override
	public void saveJK2(Zzh zzh, ZzhxmJktzs zzhxmJktzs) {
		//更新子账户
		zzhglDao.update(zzh);
		// 更新缴款通知书表
		if(null != zzhxmJktzs.getAccountDetail()){
			zzhxmJktzsDao.update(zzhxmJktzs);
		}
	}

	@Transactional
	@Override
	public void saveByTrans(ZzhxmJktzs jktzs, List<ZzhxmSfxx> zzhxmSfxx, Zzhxm zzhxm, Zzh zzhgl) {

		zzhglDao.update(zzhgl);
		// 更新对应的zzhxm
		zzhxmDao.update(zzhxm);
		// 更新对应的ZzhxmSfxx
		for (ZzhxmSfxx sfxx : zzhxmSfxx) {
			zzhxmSfxxDao.update(sfxx);
		}
		zzhxmJktzsDao.saveOrUpdateObject(jktzs);
	}

	/**
	 * 作废缴款通知书
	 * @param jktzsHistory
	 * @param sfxxHistories
	 * @return
	 */

	@Transactional
	@Override
	public int invalidNotice(ZzhxmJktzs jktzs, ZzhxmJktzsHistory jktzsHistory, List<ZzhxmSfxxHistory> sfxxHistories, Zzh accountDetail) {
		try {

			// 1 删除jktzs中的记录 ×

			// 2 添加到历史表
			zzhxmJktzsHistoryDao.save(jktzsHistory);
			//循环插入及删除该缴款通知书关联的收费信息
			for (ZzhxmSfxxHistory sfxxHistory : sfxxHistories) {
				zzhxmSfxxDao.deleteWithFlag(sfxxHistory.getId());
				zzhxmSfxxHistoryDao.save(sfxxHistory);
			}
			Zzhxm zzhxm = zzhxmDao.getById(jktzsHistory.getZzhxmid());
			//判断属于哪个缴费环节
			int i = jktzsHistory.getStatusCnjfhj();
			if (i == 0) {
				zzhxm.setStatusConstract(0);
			}
			if (i == 1) {
				zzhxm.setStatusComplete(0);
			}
			if (i == 2){
				Map paraMap = new HashMap();
				paraMap.put("zzhxmid", jktzsHistory.getZzhxmid());
				paraMap.put("typeCnjfhj", jktzsHistory.getStatusCnjfhj());
				List sfxxs = zzhxmSfxxDao.findZzhxmSfxx(paraMap);
				//如果有多条则不修改状态
				if (sfxxs.size()<=1) {
					zzhxm.setStatusWithinTheDay(0);
				}
			}
			zzhxmDao.update(zzhxm);
            //修改子账户的状态
            zzhglDao.update(accountDetail);
            // 1. 作废状态更改 by 2019-8-2
//			zzhxmJktzsDao.deleteWithFlag(jktzsHistory.getId());
            jktzs.setInvalidStatus(1);
            zzhxmJktzsDao.update(jktzs);
			return 1;
		}catch (Exception e) {
			e.printStackTrace();
            throw new RuntimeException();
		}
	}

	/**
	 * 修改信息
	 * @param zzhxmJktzs 信息
	 */
	@Transactional
	public void update(ZzhxmJktzs zzhxmJktzs)
	{
		zzhxmJktzsDao.update(zzhxmJktzs);
	}

	@Transactional
	public void update(YzsMaterialCol yzsMaterialCol)
	{
		yzsMaterialColDao.update(yzsMaterialCol);
	}


	@Transactional
	@Override
	public void updateNotSave(ZzhxmJktzs zzhxmJktzs)
	{
		zzhxmJktzsDao.update(zzhxmJktzs);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=zzhxmJktzsDao.findZzhxmJktzs(paraMap);

		zzhxmJktzsDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
					zzhxmJktzsDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public List<ZzhxmJktzs> findZzhxmJktzs(Map<String, Object> paraMap) {

		return zzhxmJktzsDao.findZzhxmJktzs(paraMap);

	}

	@Override
	public List<YzsMaterialCol> findYzsMaterialCol(Map<String, Object> paraMap) {

		return yzsMaterialColDao.findYzsMaterialCol(paraMap);

	}

	@Override
	public ZzhxmJktzs getByXmdm(String xmdm){
		Map<String,Object> paramMap =  new HashMap<>();
		paramMap.put("xmdm",xmdm);
		ZzhxmJktzs zzhxmJktzs = (ZzhxmJktzs)zzhxmJktzsDao.findObjectByFieldsMap(ZzhxmJktzs.class,paramMap);
		return zzhxmJktzs;
	}

	@Override
	public ZzhxmJktzs getByJfdmwybh(String jfdmwybh){
		Map<String,Object> paramMap =  new HashMap<>();
		paramMap.put("jfdmwybh",jfdmwybh);
		ZzhxmJktzs zzhxmJktzs = (ZzhxmJktzs)zzhxmJktzsDao.findObjectByFieldsMap(ZzhxmJktzs.class,paramMap);
		return zzhxmJktzs;
	}

	/**
	 * 根据缴款通知编号查询信息
	 * @param jktzsbh
	 */
	public ZzhxmJktzs getByJktzsbh(String jktzsbh){
		Map<String,Object> paramMap =  new HashMap<>();
		paramMap.put("jktzsbh",jktzsbh);
		ZzhxmJktzs zzhqfdz = (ZzhxmJktzs)zzhxmJktzsDao.findObjectByFieldsMap(ZzhxmJktzs.class,paramMap);
		return zzhqfdz;
	}

	/**
	 * 根据清分缴款联系id查询信息
	 * @param qfjklxid
	 */
	public ZzhxmJktzs getByQfjklxid(String qfjklxid){
		Map<String,Object> paramMap =  new HashMap<>();
		paramMap.put("qfjklxid",qfjklxid);
		ZzhxmJktzs zzhxmJktzs = (ZzhxmJktzs)zzhxmJktzsDao.findObjectByFieldsMap(ZzhxmJktzs.class,paramMap);
		return zzhxmJktzs;
	}
}
