package com.jshx.zzhxm.service;

import com.jshx.core.base.service.BaseService;
import com.jshx.core.base.vo.Pagination;
import com.jshx.zzhgl.entity.Zzh;
import com.jshx.zzhxm.entity.*;
import com.jshx.zzhxmhistory.entity.ZzhxmHistory;

import java.util.List;
import java.util.Map;

public interface ZzhxmJktzsService extends BaseService
{

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap);
	public List<ZzhxmJktzs> findZzhxmJktzs(Map<String, Object> paraMap);
	public List<YzsMaterialCol> findYzsMaterialCol(Map<String, Object> paraMap);
	public ZzhxmJktzs getByXmdm(String xmdm);
	public ZzhxmJktzs getByJfdmwybh(String jfdmwybh);
	public ZzhxmJktzs getByJktzsbh(String jktzsbh);

	/**
	 * 根据清分缴款联系id查询信息
	 * @param qfjklxid
	 */
	public ZzhxmJktzs getByQfjklxid(String qfjklxid);


	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public ZzhxmJktzs getById(String id);
	public YzsMaterialCol getByYzsId(String id);

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(ZzhxmJktzs model);
	public void save(YzsMaterialCol yzsMaterialCol);

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(ZzhxmJktzs model);
	public void update(YzsMaterialCol yzsMaterialCol);

	public void updateNotSave(ZzhxmJktzs model);

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	public void delete(String[] ids);

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	public void deleteWithFlag(String ids);

	/**
	 * 接口1保存信息
	 * @param zzhxmJktzs
	 * @param zzhxmSfxxListzl
	 * @param zzh
	 */
	public void saveJK1(ZzhxmJktzs zzhxmJktzs,List<ZzhxmSfxx> zzhxmSfxxListzl,Zzh zzh);

	/**
	 * 接口2保存信息
	 * @param zzh
	 * @param zzhxmJktzs
	 */
	public void saveJK2(Zzh zzh,ZzhxmJktzs zzhxmJktzs);

	void saveByTrans(ZzhxmJktzs jktzs, List<ZzhxmSfxx> zzhxmSfxx, Zzhxm zzhxm, Zzh zzhgl);

    int invalidNotice(ZzhxmJktzs jktzs, ZzhxmJktzsHistory jktzsHistory, List<ZzhxmSfxxHistory> sfxxHistories, Zzh accountDetail);
}
