package com.jshx.yzscw.yzscwpzgl.dao.impl;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.yzscw.yzscwfzhskm.dao.YzscwfzhskmDao;
import com.jshx.yzscw.yzscwfzhskm.entity.Yzscwfzhskm;
import com.jshx.yzscw.yzscwpzgl.dao.YzscwpzglDao;
import com.jshx.yzscw.yzscwpzgl.entity.Yzscwpzgl;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component("yzscwpzglDao")
public class YzscwpzglDaoImpl extends BaseDaoImpl implements YzscwpzglDao {
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findYzscwpzglByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findYzscwpzgl(Map<String, Object> paraMap){
		return this.findListByHqlId("findYzscwpzglByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Yzscwpzgl getById(String id)
	{
		return (Yzscwpzgl)this.getObjectById(Yzscwpzgl.class, id);
	}

	/**
	 * 保存信息
	 * @param yzscwpzgl 信息
	 */
	public void save(Yzscwpzgl yzscwpzgl)
	{
		yzscwpzgl.setId(null);
		this.saveOrUpdateObject(yzscwpzgl);
	}

	/**
	 * 修改信息
	 * @param yzscwpzgl 信息
	 */
	public void update(Yzscwpzgl yzscwpzgl)
	{
		this.saveOrUpdateObject(yzscwpzgl);
	}

	/**
	 * 物理删除信息
	 * @param id 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Yzscwpzgl.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param id 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Yzscwpzgl yzscwpzgl = (Yzscwpzgl)this.getObjectById(Yzscwpzgl.class, id);
		yzscwpzgl.setDelFlag(1);
		this.saveObject(yzscwpzgl);
	}
}
