package com.jshx.yzscw.yzscwfzhskm.service;

import com.jshx.core.base.service.BaseService;
import com.jshx.core.base.vo.Pagination;
import com.jshx.yzscw.yzscwfzhskm.entity.Yzscwfzhskm;

import java.util.List;
import java.util.Map;

public interface YzscwfzhskmService extends BaseService
{

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap);

	public List<Yzscwfzhskm> findYzscwfzhskm(Map<String, Object> paraMap);

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Yzscwfzhskm getById(String id);


	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Yzscwfzhskm model);

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Yzscwfzhskm model);

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	public void delete(String[] ids);

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	public void deleteWithFlag(List<String> ids);

	/**
	 * 获取子科目集合
	 * @param paraMap
	 * @return
	 */
    List<Yzscwfzhskm> findKmListByParentKmdm(Map<String, Object> paraMap);

	Yzscwfzhskm findKmglByKmdm(String selKmgl);

    void updateAndChildren(Yzscwfzhskm yzscwfzhskm);

	List<Yzscwfzhskm> findYzscwfzhskmListByParentId(String parentId);
}
