package com.jshx.xmdrb.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.xmdrb.dao.XmdrbDao;
import com.jshx.xmdrb.entity.Xmdrb;
import com.jshx.xmdrb.service.XmdrbService;

@Service("xmdrbService")
public class XmdrbServiceImpl extends BaseServiceImpl implements XmdrbService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("xmdrbDao")
	private XmdrbDao xmdrbDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return xmdrbDao.findByPage(page, paraMap);
	}
	
	public List findXmdrb(Map<String, Object> paraMap)
	{
		return xmdrbDao.findXmdrb(paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Xmdrb getById(String id)
	{
		return xmdrbDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(Xmdrb xmdrb)
	{
		xmdrbDao.save(xmdrb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(Xmdrb xmdrb)
	{
		xmdrbDao.update(xmdrb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=xmdrbDao.findXmdrb(paraMap);
		
		xmdrbDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    xmdrbDao.deleteWithFlag(id);
			}
		}
	}

	
	public void saveList(List<Xmdrb> list) {
		if (null != list && list.size() > 0) {
			for (Xmdrb bean : list) {
				Map<String,String> paraMap = new HashMap<String,String>();
				paraMap.put("xmbh",bean.getXmbh() );
				paraMap.put("xxbbh",bean.getXxbbh());
				List<Xmdrb> lists= xmdrbDao.findListByHqlId("findXmdrbByMap", paraMap);
				boolean fas=false;
				if(lists.size() ==0){
					this.save(bean);
					fas=true;
				}else{
					    for (Xmdrb xmdrb : lists) {
					    	 if(xmdrb.getStarts().equals("0")){
									this.save(bean);
									fas=true;
							 }
						}
					    for (Xmdrb xmdrb : lists) {
					    	if(xmdrb.getStarts().equals("1")){
					    		bean.setStarts("2");
					    		this.save(bean);
					    		fas=true;
					    	}
					    }
					  }
				//异常代码
				 if(!fas){
					 bean.setStarts("999");
					 this.save(bean);
				 }
				}
			}
		}
		
	
}
