package com.jshx.schedule.service.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.schedule.dao.Schedule1Dao;
import com.jshx.schedule.entity.Schedule1;
import com.jshx.schedule.service.Schedule1Service;

@Service("schedule1Service")
public class Schedule1ServiceImpl extends BaseServiceImpl implements Schedule1Service
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("schedule1Dao")
	private Schedule1Dao schedule1Dao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return schedule1Dao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Schedule1 getById(String id)
	{
		return schedule1Dao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(Schedule1 schedule1)
	{
		schedule1Dao.save(schedule1);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(Schedule1 schedule1)
	{
		schedule1Dao.update(schedule1);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=schedule1Dao.findSchedule1(paraMap);
		
		schedule1Dao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    schedule1Dao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public List<Schedule1> findAll(Map<String, Object> paraMap)
	{
		return schedule1Dao.findSchedule1(paraMap);
	}
}
