package com.jshx.rfxm.dao;

import com.jshx.core.base.dao.BaseDao;
import com.jshx.core.base.vo.Pagination;
import com.jshx.rfxm.entity.Rfxm;
import com.jshx.rfxm.entity.RfxmSfxx;

import java.util.List;
import java.util.Map;


public interface RfxmSfxxDao extends BaseDao
{

	/**
	 * 查询所有记录
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findRfxmSfxx(Map<String, Object> paraMap);

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public RfxmSfxx getById(String id);

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(RfxmSfxx model);

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(RfxmSfxx model);

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id);

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id);

	/*List<Map> findZhxmSfxx(Map<String, Object> paraMap);*/

    Pagination findByPage(Pagination page, Map<String, Object> paraMap);
}
