package com.jshx.paymentItemDelayFree.entity;

import java.sql.Blob;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

import com.jshx.core.base.entity.BaseModel;
import com.jshx.module.admin.entity.User;


/**
 * 实体类模板（目前仅适配MS-SQLServer数据库）
 * @author
 *
 */
@SuppressWarnings("serial")
@Entity
@Table(name="PAYMENT_ITEM_DELAY_FREE")
public class PaymentItemDelayFree extends BaseModel
{
	/**
	 * 部门代码
	 */
	private String deptId;

	/**
	 * 删除标记
	 */
	private Integer delFlag;

	
	/**
	 * 关联项目ID
	 */
	private String relateId;

	/**
	 * 免缴金额
	 */
	private String freeAmount;
	
	/**
	 * 当前实时余额
	 */
	private String currentAmount;

	/**
	 * 备注 
	 */
	private String remark;
	
	/**
	 * 经办意见
	 */
	private String operatorComment;
	
	/**
	 * 复核意见
	 */
	private String checkComment;
	/**
	 * 类型	1：免缴	2：其它
	 */
	private String type;
	
	/**
	 * 登记文号
	 */
	private String registNo;
	
	/**
	 * 批准日期
	 */
	private Date passDate;
	
	/**
	 * 经办用户
	 */
	private User dealUser;
	
	/**
	 * 复核用户
	 */
	private User checkUser;
	
	/**
	 * 单位代码
	 */
	private String dwdm;

	
	public PaymentItemDelayFree(){
	}
	
	public PaymentItemDelayFree(String id, String relateId, String freeAmount){
this.id = id;

this.relateId = relateId;

this.freeAmount = freeAmount;
}


	@Column
	public String getDeptId()
	{
		return deptId;
	}

	public void setDeptId(String deptId)
	{
		this.deptId = deptId;
	}

	@Column
	public Integer getDelFlag()
	{
		return delFlag;
	}

	public void setDelFlag(Integer delFlag)
	{
		this.delFlag = delFlag;
	}

	
	@Column(name="RELATE_ID")
	public String getRelateId()
	{
		return this.relateId;
	}

	public void setRelateId(String relateId)
	{
		this.relateId = relateId;
	}

	@Column(name="FREE_AMOUNT")
	public String getFreeAmount()
	{
		return this.freeAmount;
	}

	public void setFreeAmount(String freeAmount)
	{
		this.freeAmount = freeAmount;
	}

	@Column(name="CURRENT_AMOUNT")
	public String getCurrentAmount() {
		return currentAmount;
	}

	public void setCurrentAmount(String currentAmount) {
		this.currentAmount = currentAmount;
	}

	@Column(name="REMARK")
	public String getRemark()
	{
		return this.remark;
	}

	public void setRemark(String remark)
	{
		this.remark = remark;
	}

	@Column(name="OPERATOR_COMMENT")
	public String getOperatorComment() {
		return operatorComment;
	}

	public void setOperatorComment(String operatorComment) {
		this.operatorComment = operatorComment;
	}

	@Column(name="CHECK_COMMENT")
	public String getCheckComment() {
		return checkComment;
	}

	public void setCheckComment(String checkComment) {
		this.checkComment = checkComment;
	}

	@Column(name="TYPE")
	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	@Column(name="REGIST_NO")
	public String getRegistNo() {
		return registNo;
	}

	public void setRegistNo(String registNo) {
		this.registNo = registNo;
	}

	@Column(name="PASS_DATE")
	public Date getPassDate() {
		return passDate;
	}

	public void setPassDate(Date passDate) {
		this.passDate = passDate;
	}

	@ManyToOne(fetch = FetchType.EAGER, targetEntity=User.class)
	@JoinColumn(name = "CREATEUSERID",updatable=false,insertable=false)
	public User getDealUser() {
		return dealUser;
	}

	public void setDealUser(User dealUser) {
		this.dealUser = dealUser;
	}

	@ManyToOne(fetch = FetchType.EAGER, targetEntity=User.class)
	@JoinColumn(name = "UPDATEUSERID",updatable=false,insertable=false)
	public User getCheckUser() {
		return checkUser;
	}

	public void setCheckUser(User checkUser) {
		this.checkUser = checkUser;
	}
	
	@Column(name="DWDM")
	public String getDwdm() {
		return dwdm;
	}

	public void setDwdm(String dwdm) {
		this.dwdm = dwdm;
	}

}
