package com.jshx.jkfsjlb.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.jkfsjlb.entity.Jkfsjlb;
import com.jshx.jkfsjlb.dao.JkfsjlbDao;

@Component("jkfsjlbDao")
public class JkfsjlbDaoImpl extends BaseDaoImpl implements JkfsjlbDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findJkfsjlbByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findJkfsjlb(Map<String, Object> paraMap){
		return this.findListByHqlId("findJkfsjlbByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Jkfsjlb getById(String id)
	{
		return (Jkfsjlb)this.getObjectById(Jkfsjlb.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Jkfsjlb jkfsjlb)
	{
		jkfsjlb.setId(null);
		this.saveOrUpdateObject(jkfsjlb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Jkfsjlb jkfsjlb)
	{
		this.saveOrUpdateObject(jkfsjlb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Jkfsjlb.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Jkfsjlb jkfsjlb = (Jkfsjlb)this.getObjectById(Jkfsjlb.class, id);
		jkfsjlb.setDelFlag(1);
		this.saveObject(jkfsjlb);
	}
}
