package com.jshx.jfzm.web;

import com.google.gson.Gson;
import com.jshx.common.utils.FileUtils;
import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.core.utils.StringUtil;
import com.jshx.core.utils.Struts2Util;
import com.jshx.core.utils.SysPropertiesUtil;
import com.jshx.jktzs.entity.Jktzs;
import com.jshx.jktzs.service.JktzsService;
import com.jshx.paymentItemHis.entity.PaymentItemHis;
import com.jshx.paymentItemHis.service.PaymentItemHisService;
import com.jshx.rfxm.entity.Rfxm;
import com.jshx.rfxm.entity.RfxmSfxx;
import com.jshx.rfxm.service.RfxmService;
import com.jshx.rfxm.service.RfxmSfxxService;
import com.jshx.wwjdclinfo.entity.Wwjdclinfo;
import com.jshx.wwjdclinfo.service.WwjdclinfoService;
import com.jshx.wwsqys.entity.Wwsqys;
import com.jshx.wwsqys.service.WwsqysService;
import com.jshx.xmxxb.entity.Xmxxb;
import com.jshx.xmxxb.service.XmxxbService;
import com.jshx.zsdw.service.ZsdwService;
import com.neusoft.egov.utils.TextUtils;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JfzmAction extends BaseAction {



    @Autowired
    RfxmService rfxmService;
    @Autowired
    RfxmSfxxService rfxmSfxxService;
    @Autowired
    XmxxbService xmxxbService;
    @Autowired
    PaymentItemHisService paymentItemHisService;
    @Autowired
    private WwsqysService wwsqysService;
    @Autowired
    private WwjdclinfoService wwjdclinfoService;

    private List<Wwjdclinfo> wwjdclinfos = new ArrayList<>();


    @Autowired
    private ZsdwService zsdwService;

    /**
     * 分页信息
     */
    private Pagination pagination;

    Rfxm rfxm = new Rfxm();
    Xmxxb xmxxb = new Xmxxb();
    PaymentItemHis paymentItemHis = new PaymentItemHis();

    String id;



    /**
     * 缴费证明列表
     * @throws Exception
     */
    public void list() throws Exception{
        Map<String, Object> paraMap = new HashMap<String, Object>();

        if(pagination==null)
            pagination = new Pagination(this.getRequest());

        if(null != rfxm){

            //设置查询条件，开发人员可以在此增加过滤条件
            /**
             *	    			"rfxm.xkzh": $("#xkzh").val(),
             * 					"rfxm.zslxdbh": $("#zslxdbh").val(),
             * 					"rfxm.xxylbbh": $("#xxylbbh").val(),
             * 					"rfxm.xmbh": $("#xmbh").val(),
             * 					"rfxm.jsdwmc": $("#jsdwmc").val(),
             * 					"rfxm.gcxmmc": $("#gcxmmc").val(),
             * 					"rfxm.paymentLink": $("#paymentLink").val(),
             * 					"rfxm.isRfyz": $("#isRfyz").val(),
             * 					"rfxm.mjyj": $("#mjyj").val()
             */
            if (!TextUtils.isEmpty(rfxm.getXkzh())){
                paraMap.put("xkzh", "%" + rfxm.getXkzh().trim() + "%");
            }
            if (!TextUtils.isEmpty(rfxm.getZslxdbh())){
                paraMap.put("zslxdbh", "%" + rfxm.getZslxdbh().trim() + "%");
            }
            if (!TextUtils.isEmpty(rfxm.getXxylbbh())){
                paraMap.put("xxylbbh", "%" + rfxm.getXxylbbh().trim() + "%");
            }
            if (!TextUtils.isEmpty(rfxm.getXmbh())){
                paraMap.put("xmbh", "%" + rfxm.getXmbh().trim() + "%");
            }
            if (!TextUtils.isEmpty(rfxm.getJsdwmc())){
                paraMap.put("jsdwmc", "%" + rfxm.getJsdwmc().trim() + "%");
            }
            if (!TextUtils.isEmpty(rfxm.getGcxmmc())){
                paraMap.put("gcxmmc", "%" + rfxm.getGcxmmc().trim() + "%");
            }

            if (rfxm.getPaymentLink() != null && rfxm.getPaymentLink() > 0){
                paraMap.put("paymentLink", rfxm.getPaymentLink());
            }
            if (rfxm.getIsRfyz() != null){
                paraMap.put("isRfyz", rfxm.getIsRfyz());
            }
            if (!TextUtils.isEmpty(rfxm.getMjyj())){
                paraMap.put("mjyj", rfxm.getMjyj().trim());
            }

        }
        if(!this.getLoginUser().getIsSuperAdmin()){
            String dwdm=zsdwService.getDwdm(this.getLoginUserDepartmentId());
            paraMap.put("dwdm", dwdm);
        }

        JsonConfig config = new JsonConfig();
        config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());
        Map<String, String> codeMap = new HashMap<String, String>();
        //此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId

        config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap));
        pagination = rfxmService.findByPage(pagination, paraMap);
        for (int i = 0; i < pagination.list.size(); i++) {
            Rfxm r = (Rfxm) pagination.list.get(i);
            if(r.getPaymentHisId() != null) {
                PaymentItemHis pih = paymentItemHisService.getById(r.getPaymentHisId());
                Map<String, Object> pm = new HashMap<>();
                pm.put("rfxmid", id);
                List<RfxmSfxx> rfxmSfxxList = rfxmSfxxService.findRfxmSfxx(pm);
                RfxmSfxx sfxx = rfxmSfxxList == null || rfxmSfxxList.size() == 0 ? null : rfxmSfxxList.get(0);

                //TODO 1,判断是否显示同步按钮  2，判断是否置灰
                r.setShowTb(r.getIsSl() != 1 ? 1 : 0);//房改办,竖联,不显示施工许可

                try {
                    r.setShowYb(Double.parseDouble(pih.getPtyjje()) != 0 ? 1 : 0);//配套费=0,不显示一般缴费证明
                } catch (Exception e) {

                }

                if(r.getIsRfyz() != null && r.getIsRfyz() == 1) {//人防用章后可以同步
                    r.setEnableTb(1);
                } else if(sfxx != null && sfxx.getTqjn() != null &&  sfxx.getTqjn() == 1 && sfxx.getStatus() != 0) {//显示补录时可以同步
                    r.setEnableTb(1);
                } else {
                    r.setEnableTb(0);
                }
            }
        }

        convObjectToJson(pagination, config);
    }

    /**
     * 同步缴费证明
     */
    public void sync() {

    }

    /**
     * 打印缴费证明时，查询所需要的数据
     */
    public String print() {
        rfxm = rfxmService.getById(id);
        xmxxb = xmxxbService.getById(rfxm.getXmxxbId());
        paymentItemHis = paymentItemHisService.getById(rfxm.getPaymentHisId());
        return VIEW;
    }

    public String fujian() {
        xmxxb = xmxxbService.getBySlbh(xmxxb.getSlbh());
        Map map = new HashMap();
        map.put("xxylb",xmxxb.getXxylb());
        Pagination  pagination1 = wwjdclinfoService.findByPage(new Pagination(1,0),map);
        wwjdclinfos = pagination1.getListOfObject();
        return EDIT;
    }

    private File file; //文件上传

    /**
     * 凭证上传
     * 先缓存至服务器
     */
    public String fujiantongbu() throws Exception
    {
        String fileName1="";
        String rubiaopath ="";
        //id : uploadName;ids:uploadShowName
        String ids = "一般缴款书";
        if(file!=null && StringUtil.isNotEmpty(id))
        {
            //TODO 上传文件
            String path = SysPropertiesUtil.jdlj(this.getRequest())
                    + File.separator+ "wwupload"+ File.separator+"bjcl" +File.separator+xmxxb.getXxylb()+File.separator;
            rubiaopath = "wwupload"+ File.separator+"bjcl" +File.separator+xmxxb.getXxylb()+File.separator+id;
            rubiaopath = rubiaopath.replaceAll("\\\\", "/").trim();
            path = path.replaceAll("\\\\", "/").trim();
            fileName1 = FileUtils.uploadFile(file,id, path);
        }
        Wwjdclinfo wwjdclinfo = new Wwjdclinfo();
        wwjdclinfo.setDeptId(this.getLoginUserDepartmentId());
        wwjdclinfo.setDelFlag(0);

        xmxxb = xmxxbService.getByXxylb(xmxxb.getXxylb());
//			List<Wwsqys> ls = wwsqysService.findxxylb(xmxxb.getXxylb());
        if(xmxxb != null && "9".equals(xmxxb.getHfsz()))
        {
            List<Wwsqys> wwsqyss = wwsqysService.findxxylb(xmxxb.getXxylb());
            wwjdclinfo.setWwsqbh(wwsqyss.get(0).getWwsqbh());
        }
        else
        {
            wwjdclinfo.setWwsqbh("xxsbxm");
        }

        wwjdclinfo.setScdz(rubiaopath);
        wwjdclinfo.setScwjm(id);
        wwjdclinfo.setFjqm(ids);
//		wwjdclinfo.setWwsqbh(wwsqys.getWwsqbh());
        wwjdclinfo.setXxylb(xmxxb.getXxylb());
        //查询表中是否存在，若存在则覆盖
        Map<String, Object> paraMap = new HashMap<String, Object>();
        Pagination pagination =new Pagination(1,100);
        paraMap.put("xxylb",xmxxb.getXxylb());
        paraMap.put("fjqm",ids);
        pagination = wwjdclinfoService.findByPage(pagination,paraMap);
        List<Wwjdclinfo> wwjdclinfos = pagination.getListOfObject();
        if(CollectionUtils.isEmpty(wwjdclinfos))
        {
            wwjdclinfoService.save(wwjdclinfo);
        }
        else
        {
            Wwjdclinfo wwjdclinfo1 = wwjdclinfos.get(0);
            wwjdclinfo1.setFjqm(ids);
            wwjdclinfo1.setScwjm(id);
            wwjdclinfo1.setScdz(rubiaopath);
            wwjdclinfoService.update(wwjdclinfo1);
        }
        return RELOAD;
    }


    public Pagination getPagination() {
        return pagination;
    }

    public void setPagination(Pagination pagination) {
        this.pagination = pagination;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Rfxm getRfxm() {
        return rfxm;
    }

    public void setRfxm(Rfxm rfxm) {
        this.rfxm = rfxm;
    }

    public Xmxxb getXmxxb() {
        return xmxxb;
    }

    public void setXmxxb(Xmxxb xmxxb) {
        this.xmxxb = xmxxb;
    }

    public PaymentItemHis getPaymentItemHis() {
        return paymentItemHis;
    }

    public void setPaymentItemHis(PaymentItemHis paymentItemHis) {
        this.paymentItemHis = paymentItemHis;
    }

    public List<Wwjdclinfo> getWwjdclinfos() {
        return wwjdclinfos;
    }

    public void setWwjdclinfos(List<Wwjdclinfo> wwjdclinfos) {
        this.wwjdclinfos = wwjdclinfos;
    }

    public File getFile() {
        return file;
    }

    public void setFile(File file) {
        this.file = file;
    }


}
