package com.jshx.hisxrddfs.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.hisxrddfs.entity.Hisxrddfs;
import com.jshx.hisxrddfs.dao.HisxrddfsDao;

@Component("hisxrddfsDao")
public class HisxrddfsDaoImpl extends BaseDaoImpl implements HisxrddfsDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findHisxrddfsByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findHisxrddfs(Map<String, Object> paraMap){
		return this.findListByHqlId("findHisxrddfsByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Hisxrddfs getById(String id)
	{
		return (Hisxrddfs)this.getObjectById(Hisxrddfs.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Hisxrddfs hisxrddfs)
	{
		hisxrddfs.setId(null);
		this.saveOrUpdateObject(hisxrddfs);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Hisxrddfs hisxrddfs)
	{
		this.saveOrUpdateObject(hisxrddfs);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Hisxrddfs.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Hisxrddfs hisxrddfs = (Hisxrddfs)this.getObjectById(Hisxrddfs.class, id);
		hisxrddfs.setDelFlag(1);
		this.saveObject(hisxrddfs);
	}
}
