package com.jshx.hisxlfymxb.service.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.hisxlfymxb.dao.HisxlfymxbDao;
import com.jshx.hisxlfymxb.entity.Hisxlfymxb;
import com.jshx.hisxlfymxb.service.HisxlfymxbService;

@Service("hisxlfymxbService")
public class HisxlfymxbServiceImpl extends BaseServiceImpl implements HisxlfymxbService
{
	/**
	 * Dao类
	 */
	@Autowired()
	@Qualifier("hisxlfymxbDao")
	private HisxlfymxbDao hisxlfymxbDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return hisxlfymxbDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Hisxlfymxb getById(String id)
	{
		return hisxlfymxbDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(Hisxlfymxb hisxlfymxb)
	{
		hisxlfymxbDao.save(hisxlfymxb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(Hisxlfymxb hisxlfymxb)
	{
		hisxlfymxbDao.update(hisxlfymxb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list = Arrays.asList(ids);

		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects = hisxlfymxbDao.findHisxlfymxb(paraMap);

		hisxlfymxbDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
		String[] idArray = ids.split("\\|");
		if (null != idArray)
		{
			for (String id : idArray)
			{
				if (id != null && !id.trim().equals(""))
					hisxlfymxbDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public List<Hisxlfymxb> query(Map<String, Object> map)
	{
		return hisxlfymxbDao.findHisxlfymxb(map);
	}
}
