package com.jshx.hisxlddfs.web;

import java.io.FileInputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.hisxlddfs.entity.Hisxlddfs;
import com.jshx.hisxlddfs.service.HisxlddfsService;

import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

public class HisxlddfsAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	/**
	 * 实体类
	 */
	private Hisxlddfs hisxlddfs = new Hisxlddfs();

	/**
	 * 业务类
	 */
	@Autowired
	private HisxlddfsService hisxlddfsService;

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;

	private Date queryOperateTimeStart;

	private Date queryOperateTimeEnd;

	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;
	private String acceptNo;
	private String computerType;

	public String getComputerType()
	{
		return computerType;
	}

	public void setComputerType(String computerType)
	{
		this.computerType = computerType;
	}

	public String getAcceptNo()
	{
		return acceptNo;
	}

	public void setAcceptNo(String acceptNo)
	{
		this.acceptNo = acceptNo;
	}

	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception
	{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if (pagination == null)
			pagination = new Pagination(this.getRequest());

		if (null != hisxlddfs)
		{
			// 设置查询条件，开发人员可以在此增加过滤条件
			if ((null != hisxlddfs.getDwdm()) && (0 < hisxlddfs.getDwdm().trim().length()))
			{
				paraMap.put("dwdm", "%" + hisxlddfs.getDwdm().trim() + "%");
			}

			if ((null != hisxlddfs.getAcceptNo()) && (0 < hisxlddfs.getAcceptNo().trim().length()))
			{
				paraMap.put("acceptNo", "%" + hisxlddfs.getAcceptNo().trim() + "%");
			}

			if ((null != hisxlddfs.getComputerType()) && (0 < hisxlddfs.getComputerType().trim().length()))
			{
				paraMap.put("computerType", "%" + hisxlddfs.getComputerType().trim() + "%");
			}

			if (null != queryOperateTimeStart)
			{
				paraMap.put("startOperateTime", queryOperateTimeStart);
			}

			if (null != queryOperateTimeEnd)
			{
				paraMap.put("endOperateTime", queryOperateTimeEnd);
			}
		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class, new DateJsonValueProcessor());
		Map<String, String> codeMap = new HashMap<String, String>();
		// 此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId

		config.registerJsonValueProcessor(String.class, new CodeJsonValueProcessor(codeMap));
		final String filter = "id|dwdm|acceptNo|computerType|buildingNo|floor|area0001|area0002|area0003|area0004|area0005|area0007|area0006|operatorname|operateTime|";
		if (filter != null && filter.length() > 1)
		{
			config.setJsonPropertyFilter(new PropertyFilter()
			{
				public boolean apply(Object source, String name, Object value)
				{
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = hisxlddfsService.findByPage(pagination, paraMap);

		convObjectToJson(pagination, config);
	}

	public String list1() throws Exception
	{
		hisxlddfs.setComputerType(computerType);
		hisxlddfs.setAcceptNo(acceptNo);
		return "success";
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception
	{
		if ((null != hisxlddfs) && (null != hisxlddfs.getId()))
			hisxlddfs = hisxlddfsService.getById(hisxlddfs.getId());

		return VIEW;
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception
	{
		view();
		return EDIT;
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception
	{
		FileInputStream in = null;
		try
		{
			// 设置Blob字段
			setBlobField(in);
		} finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				} catch (Exception ex)
				{
				}
			}
		}

		if ("add".equalsIgnoreCase(this.flag))
		{
			hisxlddfs.setDeptId(this.getLoginUserDepartmentId());
			hisxlddfs.setDelFlag(0);
			hisxlddfsService.save(hisxlddfs);
		}
		else
		{
			hisxlddfsService.update(hisxlddfs);
		}

		return RELOAD;
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != hisxlddfs)
		{
			try
			{
				// 此处将File对象转换成blob对象，并设置到hisxlddfs中去

			} catch (Exception ex)
			{
				ex.printStackTrace();
			}
		}
	}

	/**
	 * 删除信息
	 */
	public String delete() throws Exception
	{
		try
		{
			hisxlddfsService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		} catch (Exception e)
		{
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}

	public String getIds()
	{
		return ids;
	}

	public void setIds(String ids)
	{
		this.ids = ids;
	}

	public Pagination getPagination()
	{
		return pagination;
	}

	public void setPagination(Pagination pagination)
	{
		this.pagination = pagination;
	}

	public Hisxlddfs getHisxlddfs()
	{
		return this.hisxlddfs;
	}

	public void setHisxlddfs(Hisxlddfs hisxlddfs)
	{
		this.hisxlddfs = hisxlddfs;
	}

	public String getFlag()
	{
		return flag;
	}

	public void setFlag(String flag)
	{
		this.flag = flag;
	}

	public Date getQueryOperateTimeStart()
	{
		return this.queryOperateTimeStart;
	}

	public void setQueryOperateTimeStart(Date queryOperateTimeStart)
	{
		this.queryOperateTimeStart = queryOperateTimeStart;
	}

	public Date getQueryOperateTimeEnd()
	{
		return this.queryOperateTimeEnd;
	}

	public void setQueryOperateTimeEnd(Date queryOperateTimeEnd)
	{
		this.queryOperateTimeEnd = queryOperateTimeEnd;
	}

}
