package com.jshx.hissfcjbxxb.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.hissfcjbxxb.entity.Hissfcjbxxb;
import com.jshx.hissfcjbxxb.dao.HissfcjbxxbDao;

@Component("hissfcjbxxbDao")
public class HissfcjbxxbDaoImpl extends BaseDaoImpl implements HissfcjbxxbDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findHissfcjbxxbByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findHissfcjbxxb(Map<String, Object> paraMap){
		return this.findListByHqlId("findHissfcjbxxbByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Hissfcjbxxb getById(String id)
	{
		return (Hissfcjbxxb)this.getObjectById(Hissfcjbxxb.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Hissfcjbxxb hissfcjbxxb)
	{
		hissfcjbxxb.setId(null);
		this.saveOrUpdateObject(hissfcjbxxb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Hissfcjbxxb hissfcjbxxb)
	{
		this.saveOrUpdateObject(hissfcjbxxb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Hissfcjbxxb.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Hissfcjbxxb hissfcjbxxb = (Hissfcjbxxb)this.getObjectById(Hissfcjbxxb.class, id);
		hissfcjbxxb.setDelFlag(1);
		this.saveObject(hissfcjbxxb);
	}
}
