package com.jshx.fawen.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.fawen.entity.Fawen;
import com.jshx.fawen.dao.FawenDao;

@Component("fawenDao")
public class FawenDaoImpl extends BaseDaoImpl implements FawenDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findFawenByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findFawen(Map<String, Object> paraMap){
		return this.findListByHqlId("findFawenByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Fawen getById(String id)
	{
		return (Fawen)this.getObjectById(Fawen.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Fawen fawen)
	{
		fawen.setId(null);
		this.saveOrUpdateObject(fawen);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Fawen fawen)
	{
		this.saveOrUpdateObject(fawen);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Fawen.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Fawen fawen = (Fawen)this.getObjectById(Fawen.class, id);
		fawen.setDelFlag(1);
		this.saveObject(fawen);
	}

	@Override
	public Pagination findMailSendByPage(Pagination pagination, Map<String, Object> paraMap) {
		return this.findPageBySqlId("fawenDao_findMailSendByPage", paraMap,pagination);
	}
}
