package com.jshx.epQysq.web;

import java.io.File;
import java.io.FileInputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;

import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.base.vo.UploadFile;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.core.utils.DateUtil;
import com.jshx.core.utils.Struts2Util;
import com.jshx.core.utils.SysPropertiesUtil;
import com.jshx.epQysq.entity.EpQysq;
import com.jshx.epQysq.service.ActivitiController;
import com.jshx.epQysq.service.EpQysqService;

import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

public class EpQysqAction extends BaseAction {

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	/**
	 * 实体类
	 */
	private EpQysq epQysq = new EpQysq();

	/**
	 * 业务类
	 */
	@Autowired
	private EpQysqService epQysqService;

	@Autowired
	private ActivitiController activitiController;

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;

	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;

	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception {
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if (pagination == null)
			pagination = new Pagination(this.getRequest());

		if (null != epQysq) {
			// 设置查询条件，开发人员可以在此增加过滤条件
			if ((null != epQysq.getTitle()) && (0 < epQysq.getTitle().trim().length())) {
				paraMap.put("title", "%" + epQysq.getTitle().trim() + "%");
			}

			if ((null != epQysq.getUsername()) && (0 < epQysq.getUsername().trim().length())) {
				paraMap.put("username", "%" + epQysq.getUsername().trim() + "%");
			}

			if ((null != epQysq.getEmail()) && (0 < epQysq.getEmail().trim().length())) {
				paraMap.put("email", "%" + epQysq.getEmail().trim() + "%");
			}

			if ((null != epQysq.getMobile()) && (0 < epQysq.getMobile().trim().length())) {
				paraMap.put("mobile", "%" + epQysq.getMobile().trim() + "%");
			}

		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class, new DateJsonValueProcessor());
		Map<String, String> codeMap = new HashMap<String, String>();
		// 此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId

		config.registerJsonValueProcessor(String.class, new CodeJsonValueProcessor(codeMap));
		final String filter = "id|title|username|email|mobile|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = epQysqService.findByPage(pagination, paraMap);

		convObjectToJson(pagination, config);
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception {
		if ((null != epQysq) && (null != epQysq.getId()))
			epQysq = epQysqService.getById(epQysq.getId());

		return VIEW;
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception {
		view();
		return EDIT;
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception {
		if ("add".equalsIgnoreCase(this.flag)) {
			epQysq.setDeptId(this.getLoginUserDepartmentId());
			epQysq.setDelFlag(0);
			epQysqService.save(epQysq);

			Map variables = new HashMap();
			variables.put("moveStatus", "usertask1");
			variables.put("nextUser", nextUser);
			variables.put("applyUserId", getLoginUserId());
			String defId = activitiController.startProcessInstance("demo", epQysq.getId(), getLoginUserId(), variables);
			epQysq.setProcessId(defId);
			epQysqService.update(epQysq);
		} else {
			epQysqService.update(epQysq);
		}

		return RELOAD;
	}

	/**
	 * 删除信息
	 */
	public String delete() throws Exception {
		try {
			epQysqService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		} catch (Exception e) {
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}

	private List btnList;
	private List list;
	private String taskId;

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	public String getMoveStatus() {
		return moveStatus;
	}

	public void setMoveStatus(String moveStatus) {
		this.moveStatus = moveStatus;
	}

	public List<File> getUpload() {
		return upload;
	}

	public void setUpload(List<File> upload) {
		this.upload = upload;
	}

	public List<String> getUploadFileName() {
		return uploadFileName;
	}

	public void setUploadFileName(List<String> uploadFileName) {
		this.uploadFileName = uploadFileName;
	}

	public List<String> getUploadContentType() {
		return uploadContentType;
	}

	public void setUploadContentType(List<String> uploadContentType) {
		this.uploadContentType = uploadContentType;
	}

	public String initCompleteTask() {
		if ((null != epQysq) && (null != epQysq.getId()))
			epQysq = (EpQysq) epQysqService.getById(epQysq.getId());

		btnList = activitiController.buttonList(taskId);
		// 显示每一步流程
		list = activitiController.instanceDiagram(epQysq.getProcessId());

		return SUCCESS;
	}
	public String index() {
		return SUCCESS;
	}
	public void createTodoTaskQuery() {
		if (pagination == null)
			pagination = new Pagination(this.getRequest());

		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class, new DateJsonValueProcessor());
		Map paraMap = new HashMap();
		paraMap.put("SqlId", "toDoTaskQuery");
		paraMap.put("userId", getLoginUserId());
		pagination = activitiController.findBySqlId(pagination, paraMap);
		convObjectToJson(pagination, config);
	}

	private String processDefinitionId;

	private final static String nextUser = "402880e92db726b5012db729f65f0001";

	private String message;

	private String moveStatus;

	private List<File> upload;
	private List<String> uploadFileName;
	private List<String> uploadContentType;

	public String saveGeneric() {
		uploadAttach(taskId, processDefinitionId);
		Map map = new HashMap();
		map.put("nextUser", nextUser);
		map.put("moveStatus", moveStatus);
		map.put("message", message);
		activitiController.passProcess(taskId, message, map);

		return SUCCESS;
	}

	private boolean uploadAttach(String taskId, String processInstanceId) {
		try {
			if ((this.upload != null) && (!this.upload.isEmpty())) {
				for (int i = 0; i < this.upload.size(); i++) {
					File file = (File) this.upload.get(i);
					UploadFile uploadFile = new UploadFile();
					uploadFile.setFileName((String) this.uploadFileName.get(i));
					uploadFile.setFileType((String) this.uploadContentType.get(i));
					uploadFile.setUploadFile(file);
					String rename = UUID.randomUUID().toString() + "."
							+ getFileSuffix((String) this.uploadFileName.get(i));
					String path = Struts2Util.getServletContext().getRealPath("/");
					uploadFile.setId(rename);
					uploadFile.setFilePath(path + SysPropertiesUtil.getProperty("uploadFile") + "\\"
							+ DateUtil.convertDateToString(DateUtil.DATE_FORMAT_YYYYMMDD, new Date()) + "\\");
					uploadFile.uploadToServer();
					uploadFile.setFilePath(SysPropertiesUtil.getProperty("uploadFile") + "\\"
							+ DateUtil.convertDateToString(DateUtil.DATE_FORMAT_YYYYMMDD, new Date()) + "\\");
					activitiController.createAttachment((String) this.uploadContentType.get(i), taskId,
							processInstanceId, (String) this.uploadFileName.get(i), uploadFile.getFilePath() + rename);
				}

			}

			return true;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return false;
	}

	public String getFileSuffix(String fileName) {
		String filesuffix = null;
		StringTokenizer fx = new StringTokenizer(fileName, ". ");
		while (fx.hasMoreTokens()) {
			filesuffix = fx.nextToken();
		}
		return filesuffix;
	}

	public List getBtnList() {
		return btnList;
	}

	public void setBtnList(List btnList) {
		this.btnList = btnList;
	}

	public List getList() {
		return list;
	}

	public void setList(List list) {
		this.list = list;
	}

	public String getTaskId() {
		return taskId;
	}

	public void setTaskId(String taskId) {
		this.taskId = taskId;
	}

	public String getIds() {
		return ids;
	}

	public void setIds(String ids) {
		this.ids = ids;
	}

	public Pagination getPagination() {
		return pagination;
	}

	public void setPagination(Pagination pagination) {
		this.pagination = pagination;
	}

	public EpQysq getEpQysq() {
		return this.epQysq;
	}

	public void setEpQysq(EpQysq epQysq) {
		this.epQysq = epQysq;
	}

	public String getFlag() {
		return flag;
	}

	public void setFlag(String flag) {
		this.flag = flag;
	}

}
