package com.jshx.elicense.service.impl;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.elicense.dao.ELicenseDao;
import com.jshx.elicense.entity.ELicense;
import com.jshx.elicense.service.ELicenseService;
import com.jshx.jktzs.dao.JktzsDao;
import com.jshx.jktzs.entity.Jktzs;
import com.jshx.zzhxm.dao.ZzhxmJktzsDao;
import com.jshx.zzhxm.entity.ZzhxmJktzs;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("eLicenseService")
public class ELicenseServiceImpl extends BaseServiceImpl implements ELicenseService {

    @Autowired
    @Qualifier("eLicenseDao")
    private ELicenseDao eLicenseDao;

    @Autowired
    @Qualifier("jktzsDao")
    private JktzsDao jktzsDao;

    @Autowired
    @Qualifier("zzhxmjktzsDao")
    private ZzhxmJktzsDao zzhxmJktzsDao;

    @Override
    public Pagination findByPage(Pagination page, Map<String, Object> paraMap) {
        return eLicenseDao.findByPage(page, paraMap);
    }

    @Override
    public List<ELicense> findELicenseList(Map<String, Object> paraMap) {
        return eLicenseDao.findELicenseList(paraMap);
    }

    @Override
    public boolean hasContacted(String id, String eLicenseId) {
        Map<String, Object> paraMap = new HashMap<>();
        ELicense model = eLicenseDao.getById(eLicenseId);
        if ( "1".equals(model.getProjectType().trim()) || "2".equals(model.getProjectType())) {
            paraMap.put("jktzsId", id);
        }else {
            paraMap.put("zzhxmId", id);
            paraMap.put("projectType", model.getProjectType()); // 会有一条或者两条绑定同一个一站式的记录,判断是否绑定则需要zzhxmId和type两个共同
        }
//        paraMap.put("bindFlag", "1");
        List eLicenseList = eLicenseDao.findELicenseList(paraMap);
        return CollectionUtils.isNotEmpty(eLicenseList)?true:false;
    }

    @Override
    public ELicense getById(String id) {
        return eLicenseDao.getById(id);
    }

    @Transactional
    @Override
    public void save(ELicense model) {
        eLicenseDao.save(model);
    }

    @Transactional
    @Override
    public void update(ELicense model) {
        eLicenseDao.update(model);
    }

    @Transactional
    @Override
    public void delete(String[] ids) {
        List list= Arrays.asList(ids);

        Map<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("ids", list);
        List objects=eLicenseDao.findELicenseList(paraMap);

        eLicenseDao.removeAll(objects);
    }

    @Transactional
    @Override
    public void deleteWithFlag(String ids) {
        String[] idArray = ids.split("\\|");
        if(null != idArray)
        {
            for(String id : idArray)
            {
                if(id!=null && !id.trim().equals(""))
                    eLicenseDao.deleteWithFlag(id);
            }
        }
    }

    /**
     *
     * @param updateData 电子证照
     * @param type 类型 (十位)1配套费 2一站式 (个位) 1绑定 0解绑
     */
    @Transactional
    @Override
    public void bindingProject(ELicense updateData, int type) {
        if (type == 11) {
            // 配套费绑定
            Jktzs jktzs = jktzsDao.getById(updateData.getJktzsId());
            jktzs.setElFlag("1");
            jktzs.setElicenseId(updateData.getId());
            updateData.setGhxkz(jktzs.getGhxkz());
            updateData.setJsdwmc(jktzs.getDwmc());
            updateData.setGcxmmc(jktzs.getXmmc());
            updateData.setCkbh(jktzs.getCkbh());
            jktzsDao.update(jktzs);
        }else if (type == 21){
            // 一站式绑定
            ZzhxmJktzs byId = zzhxmJktzsDao.getById(updateData.getZzhxmId());
            byId.setElFlag("1");
            updateData.setGhxkz(byId.getGhxkzbh());
            updateData.setJsdwmc(byId.getJsdwmc());
            updateData.setGcxmmc(byId.getGcxmmc());
//            updateData.setCkbh(byId.c);
            zzhxmJktzsDao.update(byId);
        }else if (type == 10) {
            // 配套费解绑
            Jktzs jktzs = jktzsDao.getById(updateData.getJktzsId());
            jktzs.setElFlag(null);
            jktzs.setElicenseId(null);
            updateData.setGhxkz(null);
            updateData.setJsdwmc(null);
            updateData.setGcxmmc(null);
            updateData.setCkbh(null);
            updateData.setBindFlag("2"); // 标记为解绑项目,方便后续操作
            updateData.setJktzsId(null); // 解绑将关联id置空
            updateData.setBindTime(null);
            updateData.setPaymentLinkType(null);
            updateData.setPaymentLinkDays(null);
            jktzsDao.update(jktzs);
        }else if (type == 20) {
            // 一站式解绑
            ZzhxmJktzs byId = zzhxmJktzsDao.getById(updateData.getZzhxmId());
            byId.setElFlag(null);
            updateData.setGhxkz(null);
            updateData.setJsdwmc(null);
            updateData.setGcxmmc(null);
            updateData.setBindFlag("2"); // 标记为解绑项目,方便后续操作
            updateData.setZzhxmId(null); // 将关联id置空
            updateData.setBindTime(null);
            updateData.setPaymentLinkType(null);
            updateData.setPaymentLinkDays(null);
            zzhxmJktzsDao.update(byId); // 先更新缴款书记录
        }
        this.update(updateData);
    }
}
