package com.jshx.elicense.dao.impl;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.elicense.dao.ELicenseDao;
import com.jshx.elicense.entity.ELicense;
import com.jshx.elicense.service.ELicenseService;
import com.jshx.zzhxm.entity.Zzhxm;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component("eLicenseDao")
public class ELicenseDaoImpl extends BaseDaoImpl implements ELicenseDao {
    @Override
    public Pagination findByPage(Pagination page, Map<String, Object> paraMap) {
        return this.findPageByHqlId("findELicenseByMap", paraMap, page);
    }

    @Override
    public List findELicenseList(Map<String, Object> paraMap) {
        return this.findListByHqlId("findELicenseByMap", paraMap);
    }

    @Override
    public ELicense getById(String id) {
        return (ELicense)this.getObjectById(ELicense.class, id);
    }

    @Override
    public void save(ELicense model) {
        model.setId(null);
        this.saveOrUpdateObject(model);
    }

    @Override
    public void update(ELicense model) {
        this.saveOrUpdateObject(model);
    }

    @Override
    public void delete(String id) {
        this.removeObjectById(ELicense.class, id);
    }

    @Override
    public void deleteWithFlag(String id) {
        ELicense model = (ELicense)this.getObjectById(ELicense.class, id);
        model.setDelFlag(1);
        this.saveObject(model);
    }
}
