package com.jshx.constantset.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.constantset.entity.ConstantSet;
import com.jshx.constantset.dao.ConstantSetDao;

@Component("constantSetDao")
public class ConstantSetDaoImpl extends BaseDaoImpl implements ConstantSetDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findConstantSetByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findConstantSet(Map<String, Object> paraMap){
		return this.findListByHqlId("findConstantSetByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public ConstantSet getById(String id)
	{
		return (ConstantSet)this.getObjectById(ConstantSet.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(ConstantSet constantSet)
	{
		constantSet.setId(null);
		this.saveOrUpdateObject(constantSet);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(ConstantSet constantSet)
	{
		this.saveOrUpdateObject(constantSet);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(ConstantSet.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		ConstantSet constantSet = (ConstantSet)this.getObjectById(ConstantSet.class, id);
		constantSet.setDelFlag(1);
		this.saveObject(constantSet);
	}
}
