package com.jshx.billlq.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.ServletActionContext;
import org.hibernate.LobHelper;
import org.hibernate.SessionFactory;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.utils.Struts2Util;
import com.jshx.module.admin.entity.Department;
import com.jshx.module.admin.entity.User;
import com.jshx.module.form.service.AttachfileService;
import com.jshx.zsdw.entity.Zsdw;
import com.jshx.zsdw.service.ZsdwService;
import com.neusoft.egov.utils.billendnumber;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.account.paymentVoucherHis.entity.PaymentVoucherHis;
import com.jshx.account.paymentVoucherHis.service.PaymentVoucherHisService;
import com.jshx.billManager.entity.Indeticur;
import com.jshx.billManager.service.BillManagerService;
import com.jshx.billlq.entity.Billlq;
import com.jshx.billlq.service.BilllqService;

public class BilllqAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	/**
	 * 实体类
	 */
	private Billlq billlq = new Billlq();
	private Indeticur indeticur = new Indeticur();

	/**
	 * 业务类
	 */
	@Autowired
	private BilllqService billlqService;
	@Autowired
	private ZsdwService zsdwService;
	@Autowired
	private BillManagerService billManagerService;
	@Autowired
	private PaymentVoucherHisService paymentVoucherHisService;
	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;
	
	private String status;
	
	private String rkDate;
	
	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;
	
	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();
		List<Indeticur> list = new ArrayList<Indeticur>();
		List<Billlq> billlqlist = new ArrayList<Billlq>();
		List<Billlq> billlqlist1 = new ArrayList<Billlq>();
		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
  
		if(null != billlq){
		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != billlq.getState()) && (0 < billlq.getState().trim().length())){
				paraMap.put("state",  billlq.getState().trim() );
			}

			if ((null != billlq.getStartno()) && (0 <  billlq.getStartno().trim().length())){
				paraMap.put("no",   billlq.getStartno().trim()+"%");
			}
			
			if ((null != status) && (0 <  status.trim().length())){
				if(status.equals("1")){
					paraMap.put("state", 1);
					paraMap.put("isrece", 1);
				}
				if(status.equals("2")){
					paraMap.put("isprint", 1);
					paraMap.put("state",0);
					paraMap.put("isrece", 1);
				}
				if(status.equals("3")){
					paraMap.put("isrece", 3);
				}
			}else{
				paraMap.put("isrece", 1);
			}
			if ((null != rkDate) && (0 <  rkDate.trim().length())){
				paraMap.put("rkDate", rkDate);
			}

		}
		
		List lists = billManagerService.findByIndeticurPage(paraMap);
		//list = pagination.list;
		for(int i=0;i<lists.size();i++)
		{
//			Indeticur indeticur = (Indeticur) lists.get(i);
//			PaymentVoucherHis paymentVoucherHis	=paymentVoucherHisService.getByVoucherCode(indeticur.getNo());
			Map<String,Object> map =(Map<String,Object>) lists.get(i);
			PaymentVoucherHis paymentVoucherHis	=paymentVoucherHisService.getByVoucherCode(map.get("NO").toString());
			if(paymentVoucherHis!=null)
			
			{
				if("0".equals(paymentVoucherHis.getApplyStatus())||"1".equals(paymentVoucherHis.getApplyStatus()))
				{
					Billlq bq = new Billlq();
					bq.setId(map.get("ROW_ID").toString());
					if(map.get("NO").toString()!=null){
						bq.setStartno((map.get("NO").toString().length()>15)?map.get("NO").toString():map.get("NO").toString().substring(0, 9));
					}
					if(map.get("SEQUENCEID")!=null){
						bq.setSequentID(map.get("SEQUENCEID").toString());
					}	
					if(map.get("ZSDW")!=null){
						bq.setZsdw(map.get("ZSDW").toString());
					}
				    bq.setEndno(paymentVoucherHis.getApplyStatus());
				    if(map.get("STATE")!=null){
				    	bq.setState(map.get("STATE").toString());
				    }
				    if(map.get("ISRECE")!=null){
				    	bq.setIsrece(map.get("ISRECE").toString());
				    }
					if(map.get("RKDATE")!=null){
						bq.setJxTime(map.get("RKDATE").toString());
					}	
					bq.setJsdw(paymentVoucherHis.getPayerName());
					bq.setSalary(paymentVoucherHis.getAmount());
					bq.setPrintDate(paymentVoucherHis.getPrintDate());
					billlqlist.add(bq);
				}
			}
		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|zsdw|startno|person|endno|lqtime|count|state|jsdw|printDate|salary|isrece|jxTime|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = billlqService.findByPage(pagination, paraMap);
		int pageNumber = pagination.getPageNumber();
		int pageSize=  pagination.getPageSize();
		int firstresult = (pageNumber-1)*pageSize;
		int lastResult = pageNumber*pageSize-1;
		for(int i=0;i<billlqlist.size();i++)
		{
			if(i>=firstresult&&i<=lastResult)
			{
				billlqlist1.add(billlqlist.get(i));
			}
		}
		pagination.list=billlqlist1;
		pagination.setTotalCount(billlqlist.size());
		convObjectToJson(pagination, config);
	}
	
	public String execute()
	{
		ids =this.getRequestParameter("ids");
		return SUCCESS;
	}
	
	public void list1() throws Exception{
 		Map<String, Object> paraMap = new HashMap<String, Object>();
		
		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
  
		if(null != billlq){
		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != billlq.getZsdw()) && (0 < billlq.getZsdw().trim().length())){
				paraMap.put("zsdw", "%" + billlq.getZsdw().trim() + "%");
			}

			if ((null != billlq.getStartno()) && (0 <  billlq.getStartno().trim().length())){
				paraMap.put("no",   "%"+billlq.getStartno().trim()+"%");
			}
			if ((null != status) && (0 <  status.trim().length())){
				if(status.equals("1")){
					paraMap.put("state", 1);
					paraMap.put("isrece", 1);
				}
				if(status.equals("2")){
					paraMap.put("isprint", 1);
					paraMap.put("state",0);
					paraMap.put("isrece", 1);
				}
				if(status.equals("3")){
					paraMap.put("isrece", 3);
				}
				if(status.equals("4")){
					paraMap.put("isprint", 0);
					paraMap.put("isrece", 1);
				}
			}else{
				paraMap.put("isrece", 1);
			}

		}
		paraMap.put("sequenceID", ids);
		
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "ID|ZSDW|PERSON|NO|STATE|CREATETIME|ISPRINT|RKTIME|PRINTDATE|RKDATE|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = billManagerService.findByIndeticurPage(pagination, paraMap);
		List<Map<String,String>> list = pagination.list;
		for(Map map:list)
		{
			String no = map.get("NO").toString();

			map.put("NO", no.length()>15?no.substring(0, 19):no.substring(0, 9));
	
		}
		pagination.setList(list);
		pagination.setListOfObject(list);
		convObjectToJson(pagination, config);
	}
	
	public void isExit()
	{
		 JSONObject jsonObject = new JSONObject();
		 Map<String, Object> paraMap = new HashMap<String, Object>();
		 Map<String, Object> paraMap1 = new HashMap<String, Object>();
		 paraMap.put("isrece", 0);
		 paraMap1.put("isrece", 0);
		try {
			getResponse().setContentType("application/json;charset=UTF-8");
			getResponse().setCharacterEncoding("utf-8");
			getResponse().setHeader("Charset", "utf-8");
			getResponse().setHeader("Cache-Control", "no-cache");
			String count = (String) this.getRequest().getParameter("xxxx");
			String no = (String) this.getRequest().getParameter("no");
			no=buwei(no,no.length());
			paraMap.put("no", no);
			paraMap.put("sequenceID",ids);
			paraMap.put("isrece", 0);
			Indeticur indeticur=	billManagerService.findIndeticurByNo(paraMap);
			
			if(indeticur==null)
			{
				jsonObject.put("status", "y");
				jsonObject.put("info","开始号段"+no.substring(0,9)+"已经被领取或者不存在,请确认!");
				getResponse().getWriter().println(jsonObject.toString());	
			}else
			{
				paraMap1.put("sequenceID",ids);
				paraMap1.put("isrece", 0);
				int number = billManagerService.findcountByMap(paraMap1);
				if(Integer.parseInt(count)>number)
				{
					jsonObject.put("status", "y");
					jsonObject.put("info","领取的票据张数不能超过"+number+"张");
					
					getResponse().getWriter().println(jsonObject.toString());
				}else
				{
					jsonObject.put("status", "n");
					getResponse().getWriter().println(jsonObject.toString());
				}
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		if((null != billlq)&&(null != billlq.getId()))
			billlq = billlqService.getById(billlq.getId());
		
		return VIEW;
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception{
		//view();
	//	ids = this.getRequestParameter("ids");
		billlq.setSequentID(ids);
	    return EDIT;
	}
	
	public void findEndNo() throws Exception
	{
		JSONObject jsonObject = new JSONObject();
		getResponse().setContentType("application/json;charset=UTF-8");
		getResponse().setCharacterEncoding("utf-8");
		getResponse().setHeader("Charset", "utf-8");
		getResponse().setHeader("Cache-Control", "no-cache");
		 Map<String, Object> paraMap = new HashMap<String, Object>();
		try{
			String count = (String) this.getRequest().getParameter("xxxx");
			String startNo = (String) this.getRequest().getParameter("no");
			int length =startNo.substring(0, 9).length();
			int end = Integer.parseInt(startNo.substring(0, 9))+Integer.parseInt(count)-1;
			for(int i=Integer.parseInt(startNo.substring(0, 9));i<=end;i++)
			{
				String no = buwei(String.valueOf(i),length);
				paraMap.put("no", no);
				paraMap.put("sequenceID", ids);
				paraMap.put("isrece", 0);
				Indeticur Indeticur =billManagerService.findIndeticurByNo(paraMap);
				if(Indeticur==null)
				{
					end++;
				}
			}
			String endNO = String.valueOf(end);
			endNO= buwei(endNO,length);
			jsonObject.put("result", true);
			jsonObject.put("info",endNO.substring(0, 9));
			getResponse().getWriter().println(jsonObject.toString());	
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		FileInputStream in = null;
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}		

			String startNo =billlq.getStartno().substring(0, 9);
			int length =billlq.getStartno().length();
			int end = Integer.parseInt(startNo)+Integer.parseInt(billlq.getCount())-1;

			for(int i=Integer.parseInt(startNo);i<=end;i++)
			{
				String no = buwei(String.valueOf(i),length);
				paraMap.put("no", no);
				paraMap.put("sequenceID", billlq.getSequentID());
				paraMap.put("isrece", 0);
				Indeticur Indeticur =billManagerService.findIndeticurByNo(paraMap);
				if(Indeticur!=null)
				{
					Indeticur.setIsrece(1);
					Indeticur.setPerson(billlq.getPerson());
					Indeticur.setState("0");
					Indeticur.setZsdw(billlq.getZsdw());
//					billManagerService.update(Indeticur);
				}else
				{
					end++;
				}
			}
			String endNO = String.valueOf(end);
			endNO= buwei(endNO,length);
			billlq.setDeptId(this.getLoginUserDepartmentId());
			billlq.setDelFlag(0);
			billlq.setEndno(endNO.substring(0, 9));
//			billlqService.save(billlq);

		return RELOAD;
	}

	private String no2Sequence(String no) {
		// 如果是旧的，返回9位，如果是新的，返回19位，计算需要取后八位
		if (no.length()<15) {
			return no.substring(0,9);
		}else {
			return no.substring(0,19);
		}

	}
	private String buwei(String no,int length)
	{
		String s ="";
		 StringBuffer sb = null;
		 while (no.length() < length) {
	           sb = new StringBuffer();
	           sb.append("0").append(no);// 左补0
	           no = sb.toString();
	          
	     }

		 s = no+billendnumber.getCode(no);
		 return s;
	}

	// 针对二十位计算补位
	private String buwei1(String no) {
		return no + billendnumber.getCode(no);
	}
	private String buwei2(String no, int length	) {
		String s ="";
		StringBuffer sb = null;
		while (no.length() < length) {
			sb = new StringBuffer();
			sb.append("0").append(no);// 左补0
			no = sb.toString();
		}
		return no;
	}
	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != billlq)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到billlq中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }

	/**
	 * 删除信息 票据作废
	 */
	public String delete() throws Exception{
	    try{
	    	
	    	Indeticur indeticur=	billManagerService.getIndeticurById(ids);
	    	indeticur.setIsrece(3);
	    	billManagerService.update(indeticur);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public Billlq getBilllq(){
		return this.billlq;
	}

	public void setBilllq(Billlq billlq){
		this.billlq = billlq;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }

	public Indeticur getIndeticur() {
		return indeticur;
	}

	public void setIndeticur(Indeticur indeticur) {
		this.indeticur = indeticur;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getRkDate() {
		return rkDate;
	}

	public void setRkDate(String rkDate) {
		this.rkDate = rkDate;
	}
       
   
}
