/*     */ package cn.com.jshx.sxt;
/*     */ 
/*     */ import cn.com.jshx.util.Config;
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.io.PrintStream;
/*     */ import java.net.InetSocketAddress;
/*     */ import java.net.Socket;
/*     */ import java.net.SocketAddress;
/*     */ import java.nio.ByteBuffer;
/*     */ import java.util.Map;

import org.apache.commons.lang3.StringUtils;
/*     */ 
/*     */ 
/*     */ public class NetMsgclient
/*     */ {
/*  26 */   protected Socket socket = null;
/*  27 */   protected InputStream input = null;
/*  28 */   protected OutputStream output = null;
/*  29 */   public static int seq = 0;
/*     */   private String ipAddress;
/*     */   private int port;
/*     */   private String username;
/*     */   private String password;
/*     */ 
/*     */   public NetMsgclient()
/*     */   {
/*  32 */     this.socket = new Socket();
/*     */   }
/*     */ 
/*     */   public void connect(String host, int port)
/*     */     throws IOException
/*     */   {
/*  45 */     if (!this.socket.isConnected()) {
/*  46 */       SocketAddress endpoint = new InetSocketAddress(host, port);
/*     */ 
/*  48 */       this.socket.connect(endpoint, 10000);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void connect()
/*     */     throws IOException
/*     */   {
/*  61 */     if (!this.socket.isConnected()) {
/*  62 */       SocketAddress endpoint = new InetSocketAddress(this.ipAddress, this.port);
/*     */ 
/*  64 */       this.socket.connect(endpoint, 10000);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void disconnect()
/*     */     throws IOException
/*     */   {
/*  74 */     if (!this.socket.isClosed())
/*  75 */       this.socket.close(); 
/*     */   }
/*     */ 
/*  78 */   public void forceDisconnect() throws IOException { this.socket.close(); }
/*     */ 
/*     */ 
/*     */   public boolean anthenMsg()
/*     */     throws IOException
/*     */   {
/*  85 */     return msgRequest(this.username, this.password);
/*     */   }
/*     */ 
/*     */   public boolean msgRequest(String account, String verifyCode)
/*     */     throws IOException
/*     */   {
/*  97 */     short[] Pattern = (short[])MsgConst.NET_HEAD_REQ.clone();
/*  98 */     byte[] usrBuf = account.getBytes();
/*     */ 
/* 100 */     byte[] pwdBuf = NetMd5.GetByteMD5(account + verifyCode);
/* 101 */     short length = 0;
/*     */ 
/* 103 */     length = (short)(length + 6);
/*     */ 
/* 105 */     short a_length = (short)(4 + usrBuf.length);
/*     */ 
/* 107 */     short v_length = (short)(4 + pwdBuf.length);
/*     */ 
/* 109 */     length = (short)(length + a_length + v_length);
/*     */ 
/* 111 */     Pattern[1] = length;
/*     */ 
/* 113 */     ByteBuffer byteBuf = ByteBuffer.allocate(length);
/*     */ 
/* 115 */     for (int i = 0; i < Pattern.length; i++)
/*     */     {
/* 117 */       byteBuf.putShort(Pattern[i]);
/*     */     }
/*     */ 
/* 121 */     byteBuf.putShort((short)2);
/* 122 */     byteBuf.putShort(a_length);
/* 123 */     byteBuf.put(usrBuf);
/*     */ 
/* 126 */     byteBuf.putShort((short)3);
/* 127 */     byteBuf.putShort(v_length);
/* 128 */     byteBuf.put(pwdBuf);
/*     */ 
/* 130 */     return checkResponse(send(byteBuf.array(), 14));
/*     */   }
/*     */ 
/*     */   public int record(int sendType, String recPhone, String msg)
/*     */     throws IOException
/*     */   {
/* 144 */     short[] Pattern = (short[])MsgConst.NET_HEAD_BODY_REQ.clone();
/*     */ 
/* 146 */     byte[] recPhoneBuf = recPhone.getBytes();
/* 147 */     byte[] msgBuf = msg.getBytes("gbk");
/* 148 */     short length = 0;
/*     */ 
/* 150 */     int seq = getSeq();
/*     */ 
/* 153 */     length = (short)(length + 6);
/*     */ 
/* 155 */     short a_length = 8;
/*     */ 
/* 157 */     short b_length = 8;
/*     */ 
/* 159 */     short c_length = (short)(4 + recPhoneBuf.length);
/*     */ 
/* 161 */     short d_length = (short)(4 + msgBuf.length);
/*     */ 
/* 166 */     length = (short)(length + a_length + b_length + c_length + d_length);
/*     */ 
/* 168 */     Pattern[1] = length;
/*     */ 
/* 170 */     ByteBuffer byteBuf = ByteBuffer.allocate(length);
/*     */ 
/* 172 */     for (int i = 0; i < Pattern.length; i++)
/*     */     {
/* 174 */       byteBuf.putShort(Pattern[i]);
/*     */     }
/*     */ 
/* 178 */     byteBuf.putShort((short)4);
/* 179 */     byteBuf.putShort(a_length);
/* 180 */     byteBuf.putInt(seq);
/*     */ 
/* 183 */     byteBuf.putShort((short)5);
/* 184 */     byteBuf.putShort(b_length);
/* 185 */     byteBuf.putInt(sendType);
/*     */ 
/* 188 */     byteBuf.putShort((short)6);
/* 189 */     byteBuf.putShort(c_length);
/* 190 */     byteBuf.put(recPhoneBuf);
/*     */ 
/* 193 */     byteBuf.putShort((short)7);
/* 194 */     byteBuf.putShort(d_length);
/* 195 */     byteBuf.put(msgBuf);
/*     */ 
/* 198 */     return checkBodyResponse(send(byteBuf.array(), 22));
/*     */   }
/*     */ 
/*     */   public synchronized int getSeq()
/*     */   {
/* 205 */     seq += 1;
/* 206 */     return seq;
/*     */   }
/*     */ 
/*     */   public byte[] ints2bytes(short[] num) {
/* 210 */     int len = num.length * 4;
/* 211 */     byte[] b = new byte[len];
/*     */ 
/* 213 */     for (int i = 0; i < num.length; i++) {
/* 214 */       for (int j = 0; j < 4; j++) {
/* 215 */         b[(i * 4 + j)] = ((byte)(num[i] >>> 24 - j * 8));
/*     */       }
/*     */     }
/*     */ 
/* 219 */     return b;
/*     */   }
/*     */ 
/*     */   protected byte[] send(byte[] data, int rep_size)
/*     */     throws IOException
/*     */   {
/* 233 */     if (this.input == null) {
/* 234 */       this.input = new DataInputStream(this.socket.getInputStream());
/*     */     }
/*     */ 
/* 237 */     if (this.output == null) {
/* 238 */       this.output = new DataOutputStream(this.socket.getOutputStream());
/*     */     }
/*     */ 
/* 241 */     this.output.write(data);
/* 242 */     this.output.flush();
/*     */ 
/* 244 */     byte[] rep = new byte[rep_size];
/* 245 */     int Timeout = 15000;
/* 246 */     while ((this.input.available() < rep_size) && (Timeout > 0)) {
/*     */       try {
/* 248 */         Thread.sleep(5L);
/* 249 */         Timeout -= 5;
/*     */       } catch (InterruptedException e) {
/* 251 */         break;
/*     */       }
/*     */     }
/*     */ 
/* 255 */     this.input.read(rep);
/*     */ 
/* 257 */     return rep;
/*     */   }
/*     */ 
/*     */   public void initParameters(String ipAddress, int port, String username, String password)
/*     */   {
/* 270 */     this.ipAddress = ipAddress;
/* 271 */     this.port = port;
/* 272 */     this.username = username;
/* 273 */     this.password = password;
/*     */   }
/*     */ 
/*     */   public static boolean sendSms(Map<String, String> map, String tel, String message)
/*     */   {
/* 280 */     String host = (String)map.get("sxt_address");
/* 281 */     if (StringUtils.isEmpty(host))
/*     */     {
/* 283 */       host = Config.getProperty("sxt_address", "218.94.58.243");
/*     */     }
/*     */ 
/* 287 */     String port = (String)map.get("sxt_port");
/* 288 */     if (StringUtils.isEmpty(port))
/*     */     {
/* 290 */       port = Config.getProperty("sxt_port", "9001");
/*     */     }
/*     */ 
/* 294 */     String account = (String)map.get("sxt_user");
/* 295 */     if (StringUtils.isEmpty(account))
/*     */     {
/* 297 */       account = Config.getProperty("sxt_user", "Hongxin");
/*     */     }
/*     */ 
/* 301 */     String verifyCode = (String)map.get("sxt_password");
/* 302 */     if (StringUtils.isEmpty(verifyCode))
/*     */     {
/* 304 */       verifyCode = Config.getProperty("sxt_password", "jshx2008");
/*     */     }
/*     */ 
/* 307 */     boolean res = false;
/* 308 */     NetMsgclient client = new NetMsgclient();
/*     */     try
/*     */     {
/* 311 */       client.connect(host, Integer.parseInt(port));
/* 312 */       res = client.msgRequest(account, verifyCode);
/* 313 */       if (res)
/*     */       {
/* 315 */         int rep = client.record(1, tel, message);
/* 316 */         res = rep == 0;
/*     */       }
/* 318 */       client.disconnect();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */       try
/*     */       {
/* 324 */         client.forceDisconnect();
/*     */       }
/*     */       catch (IOException e1)
/*     */       {
/* 328 */         e1.printStackTrace();
/*     */       }
/*     */     }
/* 331 */     return res;
/*     */   }
/*     */ 
/*     */   public static void main(String[] args) throws IOException {
/* 335 */     NetMsgclient client = new NetMsgclient();
/*     */     try {
/* 337 */       client.connect("218.94.58.243", 9001);
/* 338 */       boolean result = client.msgRequest("Hongxin", "jshx2008");
/*     */ 
/* 340 */       if (result)
/* 341 */         System.out.println("验证成功");
/*     */       else {
/* 343 */         System.out.println("验证失败");
/*     */       }
/* 345 */       int rep = client.record(1, "18915982348", "ceshi");
/* 346 */       if (rep > -1) {
/* 347 */         if (rep == 0)
/* 348 */           System.out.println("提交成功");
/*     */         else {
/* 350 */           System.out.println("提交失败");
/*     */         }
/*     */       }
/*     */ 
/* 354 */       client.disconnect();
/*     */     } catch (Exception e) {
/* 356 */       client.forceDisconnect();
/*     */     }
/*     */   }
/*     */ 
/*     */   public int checkHeadResponse(byte[] rep)
/*     */   {
/* 366 */     int ret = -1;
/* 367 */     ByteBuffer buf = ByteBuffer.wrap(rep);
/*     */ 
/* 369 */     buf.getShort();
/* 370 */     buf.getShort();
/* 371 */     short headType = buf.getShort();
/*     */ 
/* 373 */     if (headType == MsgConst.NET_HEAD_RSP[2])
/*     */     {
/* 375 */       buf.getShort();
/* 376 */       buf.getShort();
/* 377 */       ret = buf.getInt();
/*     */     }
/* 379 */     return ret;
/*     */   }
/*     */ 
/*     */   public int checkBodyResponse(byte[] rep)
/*     */   {
/* 388 */     int ret = -1;
/* 389 */     ByteBuffer buf = ByteBuffer.wrap(rep);
/*     */ 
/* 391 */     buf.getShort();
/* 392 */     buf.getShort();
/* 393 */     short headType = buf.getShort();
/*     */ 
/* 395 */     if (headType == MsgConst.NET_HEAD_BODY_RSP[2])
/*     */     {
/* 398 */       while (buf.remaining() > 0) {
/* 399 */         short type = buf.getShort();
/* 400 */         if (type == 1)
/*     */         {
/* 402 */           buf.getShort();
/* 403 */           ret = buf.getInt();
/*     */         }
/*     */         else
/*     */         {
/* 407 */           short length = buf.getShort();
/*     */ 
/* 409 */           buf.position(buf.position() + length - 4);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 414 */     return ret;
/*     */   }
/*     */ 
/*     */   public boolean checkResponse(byte[] rep)
/*     */   {
/* 423 */     ByteBuffer buf = ByteBuffer.wrap(rep);
/*     */ 	 buf.getShort();
			buf.getShort();
			buf.getShort();
			
			buf.getShort();
			buf.getShort();

/* 431 */     int ret = buf.getInt();
/* 432 */     return ret == 0;
/*     */   }
/*     */ }

/* Location:           C:\Users\Administrator\Desktop\message-1.0.1.jar
 * Qualified Name:     cn.com.jshx.sxt.NetMsgclient
 * JD-Core Version:    0.6.2
 */