package com.jshx.extend.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.jshx.core.base.entity.BaseModel;
import com.jshx.module.admin.entity.CodeValue;
import com.jshx.module.admin.extend.ICodeValueExtendInfo;
/**
 * 一维代码扩展信息
 * 
 * @author Chenjian
 *
 */
@Entity
@Table(name = "CODE_VALUE_EXTEND")
public class CodeValueExtend extends BaseModel implements ICodeValueExtendInfo {
	
	private static final long serialVersionUID = 7622495469115321598L;
	
	private String codeValueId;
	
	private CodeValue value;
	
	private String info;

	@Override
	public void setCodeValue(CodeValue value) {
		this.value = value;
	}

	@Override
	public void setCodeValueId(String codeValueId) {
		this.codeValueId = codeValueId;
	}

	@ManyToOne(targetEntity = CodeValue.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "CODE_VALUE_ID", insertable = false, updatable = false)
	public CodeValue getValue() {
		return value;
	}

	public void setValue(CodeValue value) {
		this.value = value;
	}

	@Column(name = "INFO", length = 40)
	public String getInfo() {
		return info;
	}

	public void setInfo(String info) {
		this.info = info;
	}

	@Column(name = "CODE_VALUE_ID", length = 40)
	public String getCodeValueId() {
		return codeValueId;
	}

}
