package org.activiti.bpmn.model;

import java.util.*;

/**
 * 修改Activiti源码,添加自定义的配置属性
 *
 * Created by chenjian on 16/5/11.
 */
public class UserTask extends Task {

    protected String assignee;
    protected String owner;
    protected String priority;
    protected String formKey;
    protected String dueDate;
    protected String category;
    protected String extensionId;
    protected List<String> candidateUsers = new ArrayList<String>();
    protected List<String> candidateGroups = new ArrayList<String>();
    protected List<FormProperty> formProperties = new ArrayList<FormProperty>();
    protected List<ActivitiListener> taskListeners = new ArrayList<ActivitiListener>();
    protected String skipExpression;
    protected String targetUrl;
    protected Boolean isAllowedBack;
    protected Boolean isAllowedWithdrawal;
    protected Boolean isAllowedChangeAssign;
    protected String backCompensationBean;
    protected List<FreeFlowProperty> freeFlowProperty = new ArrayList<FreeFlowProperty>();
    protected List<DelayProperty> delayProperty = new ArrayList<DelayProperty>();


    protected Map<String, Set<String>> customUserIdentityLinks = new HashMap<String, Set<String>>();
    protected Map<String, Set<String>> customGroupIdentityLinks = new HashMap<String, Set<String>>();

    protected List<CustomProperty> customProperties = new ArrayList<CustomProperty>();

    public String getAssignee() {
        return assignee;
    }
    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }
    public String getOwner() {
        return owner;
    }
    public void setOwner(String owner) {
        this.owner = owner;
    }
    public String getPriority() {
        return priority;
    }
    public void setPriority(String priority) {
        this.priority = priority;
    }
    public String getFormKey() {
        return formKey;
    }
    public void setFormKey(String formKey) {
        this.formKey = formKey;
    }
    public String getDueDate() {
        return dueDate;
    }
    public void setDueDate(String dueDate) {
        this.dueDate = dueDate;
    }
    public String getCategory() {
        return category;
    }
    public void setCategory(String category) {
        this.category = category;
    }
    public String getExtensionId() {
        return extensionId;
    }
    public void setExtensionId(String extensionId) {
        this.extensionId = extensionId;
    }
    public boolean isExtended() {
        return extensionId != null && !extensionId.isEmpty();
    }
    public List<String> getCandidateUsers() {
        return candidateUsers;
    }
    public void setCandidateUsers(List<String> candidateUsers) {
        this.candidateUsers = candidateUsers;
    }
    public List<String> getCandidateGroups() {
        return candidateGroups;
    }
    public void setCandidateGroups(List<String> candidateGroups) {
        this.candidateGroups = candidateGroups;
    }
    public List<FormProperty> getFormProperties() {
        return formProperties;
    }
    public void setFormProperties(List<FormProperty> formProperties) {
        this.formProperties = formProperties;
    }
    public List<ActivitiListener> getTaskListeners() {
        return taskListeners;
    }
    public void setTaskListeners(List<ActivitiListener> taskListeners) {
        this.taskListeners = taskListeners;
    }

    public String getTargetUrl() {
        return targetUrl;
    }

    public void setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
    }

    public Boolean getAllowedBack() {
        return isAllowedBack;
    }

    public void setAllowedBack(Boolean allowedBack) {
        isAllowedBack = allowedBack;
    }

    public Boolean getAllowedWithdrawal() {
        return isAllowedWithdrawal;
    }
    
    public void setAllowedWithdrawal(Boolean allowedWithdrawal) {
        isAllowedWithdrawal = allowedWithdrawal;
    }

    public Boolean getAllowedChangeAssign() {
        return isAllowedChangeAssign;
    }

    public void setAllowedChangeAssign(Boolean allowedChangeAssign) {
        isAllowedChangeAssign = allowedChangeAssign;
    }

    public void setBackCompensationBean(String backCompensationBean) {
        this.backCompensationBean = backCompensationBean;
    }

    public String getBackCompensationBean() {
        return backCompensationBean;
    }

    public List<FreeFlowProperty> getFreeFlowProperty() {
        return freeFlowProperty;
    }
    public void setFreeFlowProperty(List<FreeFlowProperty> freeFlowProperty) {
        this.freeFlowProperty = freeFlowProperty;
    }
    
    public List<DelayProperty> getDelayProperty() {
        return delayProperty;
    }
    public void setDelayProperty(List<DelayProperty> delayProperty) {
        this.delayProperty = delayProperty;
    }

    public void addCustomUserIdentityLink(String userId, String type){
        Set<String> userIdentitySet = customUserIdentityLinks.get(type);

        if(userIdentitySet == null){
            userIdentitySet = new HashSet<String>();
            customUserIdentityLinks.put(type, userIdentitySet);
        }

        userIdentitySet.add(userId);
    }

    public void addCustomGroupIdentityLink(String groupId, String type){
        Set<String> groupIdentitySet = customGroupIdentityLinks.get(type);

        if(groupIdentitySet == null){
            groupIdentitySet = new HashSet<String>();
            customGroupIdentityLinks.put(type, groupIdentitySet);
        }

        groupIdentitySet.add(groupId);
    }

    public Map<String, Set<String>> getCustomUserIdentityLinks() {
        return customUserIdentityLinks;
    }

    public void setCustomUserIdentityLinks(
            Map<String, Set<String>> customUserIdentityLinks) {
        this.customUserIdentityLinks = customUserIdentityLinks;
    }

    public Map<String, Set<String>> getCustomGroupIdentityLinks() {
        return customGroupIdentityLinks;
    }

    public void setCustomGroupIdentityLinks(Map<String, Set<String>> customGroupIdentityLinks) {
        this.customGroupIdentityLinks = customGroupIdentityLinks;
    }

    public List<CustomProperty> getCustomProperties() {
        return customProperties;
    }
    public void setCustomProperties(List<CustomProperty> customProperties) {
        this.customProperties = customProperties;
    }

    public String getSkipExpression() {
        return skipExpression;
    }

    public void setSkipExpression(String skipExpression) {
        this.skipExpression = skipExpression;
    }
    public UserTask clone() {
        UserTask clone = new UserTask();
        clone.setValues(this);
        return clone;
    }

    public void setValues(UserTask otherElement) {
        super.setValues(otherElement);
        setAssignee(otherElement.getAssignee());
        setOwner(otherElement.getOwner());
        setFormKey(otherElement.getFormKey());
        setDueDate(otherElement.getDueDate());
        setPriority(otherElement.getPriority());
        setCategory(otherElement.getCategory());
        setExtensionId(otherElement.getExtensionId());
        setSkipExpression(otherElement.getSkipExpression());
        setTargetUrl(otherElement.getTargetUrl());

        setCandidateGroups(new ArrayList<String>(otherElement.getCandidateGroups()));
        setCandidateUsers(new ArrayList<String>(otherElement.getCandidateUsers()));

        setCustomGroupIdentityLinks(otherElement.customGroupIdentityLinks);
        setCustomUserIdentityLinks(otherElement.customUserIdentityLinks);

        formProperties = new ArrayList<FormProperty>();
        if (otherElement.getFormProperties() != null && !otherElement.getFormProperties().isEmpty()) {
            for (FormProperty property : otherElement.getFormProperties()) {
                formProperties.add(property.clone());
            }
        }
        
        freeFlowProperty = new ArrayList<FreeFlowProperty>();
        if (otherElement.getFreeFlowProperty() != null && !otherElement.getFreeFlowProperty().isEmpty()) {
            for (FreeFlowProperty property : otherElement.getFreeFlowProperty()) {
            	freeFlowProperty.add(property.clone());
            }
        }
        
        delayProperty = new ArrayList<DelayProperty>();
        if (otherElement.getDelayProperty() != null && !otherElement.getDelayProperty().isEmpty()) {
            for (DelayProperty property : otherElement.getDelayProperty()) {
            	delayProperty.add(property.clone());
            }
        }

        taskListeners = new ArrayList<ActivitiListener>();
        if (otherElement.getTaskListeners() != null && !otherElement.getTaskListeners().isEmpty()) {
            for (ActivitiListener listener : otherElement.getTaskListeners()) {
                taskListeners.add(listener.clone());
            }
        }
    }
}
