package com.jshx.activiti.listener;

import com.jshx.activiti.util.ActivitiVarConstants;
import com.jshx.module.admin.entity.User;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.history.HistoricIdentityLink;
import org.activiti.engine.task.Task;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

/**
 * 设置邮件任务中的收发件人
 *
 * Created by chenjian on 16/5/25.
 */
public class MailTaskListener extends AbstractListener implements ExecutionListener{

    private static final String INITIATOR_MAIL = "initiatorMail";
    private static final String ASSIGNEE_MAIL = "assigneeMail";

    @Override
    public void notify(DelegateExecution execution) throws Exception {
        initService();

        List<HistoricIdentityLink> list = historyService.getHistoricIdentityLinksForProcessInstance(execution.getProcessInstanceId());
        String creator = list.get(0).getUserId();
        User user = userService.findUserByLoginId(creator);
        if(StringUtils.isNotEmpty(user.getEmail()))
            execution.setVariable(INITIATOR_MAIL, user.getEmail());

        StringBuilder sb = new StringBuilder();
        List<Task> taskList = activitiService.findPreTaskByDefKey(execution.getProcessInstanceId(), execution.getCurrentActivityId());
        if(taskList.isEmpty())
            return;
        Task task = taskList.get(0);
        String assignee = task.getAssignee();
        if(StringUtils.isNotEmpty(assignee)){
            user = userService.findUserByLoginId(assignee);
            if(StringUtils.isNotEmpty(user.getEmail()))
                sb.append(user.getEmail()).append(",");
        }else{
            findCandidate(sb, execution, task);
        }

        if(sb.length()>1)
            execution.setVariable(ASSIGNEE_MAIL, sb.substring(0, sb.length()-1));
    }

    /**
     * 获取候选人或者候选用户组
     *
     * @param sb
     * @param execution
     * @param task
     */
    private void findCandidate(StringBuilder sb, DelegateExecution execution, Task task){
        BpmnModel bpmnModel = repositoryService.getBpmnModel(execution.getProcessDefinitionId());
        List<Process> listp = bpmnModel.getProcesses();
        org.activiti.bpmn.model.Process process = listp.get(0);
        UserTask userTask = ( UserTask) process.getFlowElement(task.getTaskDefinitionKey());
        List<String> candicateUsers = userTask.getCandidateUsers();
        List<String> candicateGroups = userTask.getCandidateGroups();

        List<String> taskCandidateUsers = (List<String>)runtimeService.getVariable(task.getExecutionId(), task.getTaskDefinitionKey()+ ActivitiVarConstants.TASK_CANDIDATE_USERS);
        List<String> taskCandidateGroups = (List<String>)runtimeService.getVariable(task.getExecutionId(), task.getTaskDefinitionKey()+ActivitiVarConstants.TASK_CANDIDATE_GROUPS);
        if(taskCandidateUsers!=null)
            candicateUsers.addAll(taskCandidateUsers);
        if(taskCandidateGroups!=null)
            candicateGroups.addAll(taskCandidateGroups);

        for(String candicateUser: candicateUsers){
            User user = userService.findUserByLoginId(candicateUser);
            if(StringUtils.isNotEmpty(user.getEmail()))
                sb.append(user.getEmail()).append(",");
        }
        for(String candicateGroup: candicateGroups){
            String[] candicateGroupArr = candicateGroup.split("\\|");
            String deptCode = null;
            String roleName;
            if(candicateGroupArr.length>1){
                deptCode = candicateGroupArr[0];
                roleName = candicateGroupArr[1];
            }else{
                roleName = candicateGroup;
            }
            List<User> userList = userService.findUserByRoleInDept(roleName, deptCode);
            for(User user: userList){
                if(StringUtils.isNotEmpty(user.getEmail()))
                    sb.append(user.getEmail()).append(",");
            }
        }
    }
}
