package com.jshx.activiti.listener;

import com.jshx.activiti.service.ActivitiMailService;
import com.jshx.core.exception.BasalException;
import com.jshx.core.utils.SpringContextHolder;
import org.activiti.engine.delegate.DelegateTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 发送邮件给当前任务的办理人
 *
 * Created by chenjian on 16/6/15.
 */
public class MailListener extends NoficationListener  {

    private static final Logger logger = LoggerFactory.getLogger(MailListener.class);

    private ActivitiMailService activitiMailService;

    @Override
    public void notify(DelegateTask delegateTask) {
        initService();
        if(activitiMailService==null)
            activitiMailService = SpringContextHolder.getBean("activitiMailService");

        try{
            activitiMailService.sendNewTaskNotification(delegateTask);
        }catch(BasalException e){
            logger.error("发送邮件失败", e);
        }
    }


}
