<%@page language="java" pageEncoding="UTF-8" isELIgnored="false" %>
<%@include file="/common/header.jsp" %>
<%@taglib prefix="activiti" uri="/activiti/tags" %>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <%@include file="/common/jsLib.jsp" %>
	<style type="text/css">
		.edit_status{
			border-color:red;
			border-style:solid;
		}
	</style>
    <script>
	    function view(row_Id){
	    	var dt=new Date();
	        createSimpleWindow("win_accountBank","查看银行到账","${ctx}/jsp/accountBank/accountBankView.action?accountBank.id="+row_Id+"&dt="+dt.getTime(),800,300);
	    	
	    }
    
		function opendoc(id)
		{
			window.location.href="${ctx}/jsp/accountBank/downloadFile.action?attachId="+id;
		}
		
		function update(){
			$("#amount").removeAttr("readonly");
			$("#amount").addClass("edit_status");
			$("#button_update").hide();
			$("#button_save").show();
			$("#button_cancel").show();
		}
		
		function cancel(){
			$("#amount").attr("readonly","readonly");
			$("#amount").removeClass("edit_status");
			$("#button_update").show();
			$("#button_save").hide();
			$("#button_cancel").hide();
		}
		
		function save(){
			$.ajax({
                url: "updateAmount.action",
                type: 'post',
                dataType: 'json',
                async: false,
                data: {
                	amount : $("#amount").val(),
                	taskId : "${taskId}"
                },
                error: function () {
                    $.messager.alert('错误', '提交出错！');
                },
                success: function (data) {
                    if (data.result) {
                        $.messager.alert('提示', '修改成功！', "info", function(){
                        	cancel();
                        });
                    } else {
                        $.messager.alert('错误', '办理时出错！');
                    }
                }
            });
		}
    	
		//待缴款办理
    	function dealPending(){
			var flag = 0;
    		var rows = $('#pagination').datagrid('getSelections');
        	var ids = "";
			for(var i=0;i<rows.length;i++){
				ids += rows[i].id+"|";
				if(1==rows[i].hasInvoice){
					flag = 1;
				}
			}
			if(rows.length<1){
			    $.messager.alert('提示','至少选择一项办理！');
			    return false;
			}
			var developUnit = rows[0].developUnit;
			var tip = false;//单位不一致提示
			for(var i=1;i<rows.length;i++){
				if(developUnit != rows[i].developUnit){
					tip = true;
					break;
				}
			}
			if(tip){
				$.messager.confirm("提示", "选择的单位不一致，是否继续?", function(result) {
					if(result){
						parent.addTab("accountDeal","一般项目办理","jsp/accountBank/dealPending.action?ids="+encodeURIComponent(ids)+"&flag="+flag);
					}
				});
			}else{
				parent.addTab("accountDeal","一般项目办理","jsp/accountBank/dealPending.action?ids="+encodeURIComponent(ids)+"&flag="+flag);
			}
    	}
		
    	//缓缴款办理
    	function dealDelay(){
			var flag = 0;
    		var rows = $('#pagination').datagrid('getSelections');
        	var ids = "";
			for(var i=0;i<rows.length;i++){
				ids += rows[i].id+"|";
				if(1==rows[i].hasInvoice){
					flag = 1;
				}
			}
			if(rows.length<1){
			    $.messager.alert('提示','至少选择一项办理！');
			    return false;
			}
			if(rows.length>1){
			    $.messager.alert('提示','缓缴款项目只能选择一项办理！');
			    return false;
			}
			var developUnit = rows[0].developUnit;
			parent.addTab("accountDeal","缓缴款项目办理","jsp/accountBank/dealDelay.action?ids="+encodeURIComponent(ids)+"&flag="+flag);
    	}
		
    	function reloadDate(){
            $('#pagination').datagrid('clearSelections');
        	search_accountBank();
        }
    
    	function search_accountBank(){
        	var queryParams = {
				"accountBank.developUnit": $("#developUnit").val(),
				"queryArrivalTimeStart": $("#queryArrivalTimeStart").val(),
				"queryArrivalTimeEnd": $("#queryArrivalTimeEnd").val(),
				"accountBank.hasInvoice":$("#hasInvoice").val(),
				"accountBank.status":$("#status").val()
			};        	
        	$('#pagination').datagrid('options').queryParams = queryParams;
        	$('#pagination').datagrid('clearSelections');
        	$("#pagination").datagrid('load'); 
        }
        
        $(function(){
        	$('#pagination').datagrid($.extend(window.dg_cm_pp,{
				title:'银行到账信息',
				url:'accountBankQuery.action',
	        	queryParams:{
	        		"accountBank.developUnit": $("#developUnit").val(),
					"queryArrivalTimeStart": $("#queryArrivalTimeStart").val(),
					"queryArrivalTimeEnd": $("#queryArrivalTimeEnd").val(),
					"accountBank.hasInvoice":$("#hasInvoice").val(),
					"accountBank.status":$("#status").val()
	        	},
				frozenColumns:[[
				    {field:'id',checkbox:true}
				]],
				columns:[[
					{field:'op',title:'操作',width:50,formatter:function(value,rec){return "<a class='btn_01_mini' onclick=view('"+rec.id+"') >查看<b></b></a>&nbsp;"}},
				    {field:'developUnit',title:'建设单位',width:200},
					{field:'amount',title:'金额',width:100,formatter: function (value, row, index){
						   if (row != null && ""!=value) {
					           return (parseFloat(value).toFixed(2) + '').replace(/\d{1,3}(?=(\d{3})+(\.\d*)?$)/g, '$&,');
					     }
					}},
					{field:'arrivalTime',title:'到账时间',width:100},
					{field:'hasInvoice',title:'有无凭证',width:100,formatter:function(value,rec){
						if('0'==rec.hasInvoice)
							return "有";
						else if('1'==rec.hasInvoice)
							return "无";
					}}
					
				]],
				toolbar:[{
					id:'btnHandle',
					text:'一般项目办理',
					iconCls:'icon-ok',
					handler:function(){
						 dealPending();
					}
				},{
					id:'btnHandle',
					text:'缓缴款项目办理',
					iconCls:'icon-ok',
					handler:function(){
						dealDelay();
					}
				}],
				onLoadSuccess: function(data){//加载完毕后获取所有的checkbox遍历
			        if (data.rows.length > 0) {
			            //循环判断操作为新增的不能选择
			            for (var i = 0; i < data.rows.length; i++) {
			                if (data.rows[i].status == 1) {
			                	$("input[type='checkbox']")[0].disabled = true;
			                    $("input[type='checkbox']")[i+1].disabled = true;
			                }else{
			                	$("input[type='checkbox']")[0].disabled = false;
			                }
			            }
			        }
			    },
			    onClickRow: function(rowIndex, rowData){
			        //加载完毕后获取所有的checkbox遍历
			        $("input[type='checkbox']").each(function(index, el){
			            //如果当前的复选框不可选，则不让其选中
			            if (el.disabled == true) {
			                $('#pagination').datagrid('unselectRow', index - 1);
			            }
			        })
			    }
			}));
		});
    </script>

</head>

<body validform="true">
 <div class="page_content">
   	<div class="box_01 submitdata">
		<div class="inner12px">
			<div class="cell boxBmargin12">
            	<div>
					<table width="100%">
						<tr>
							<th width="15%">建设单位</th>
							<td width="35%">
								<input name="accountBank.developUnit" id="developUnit" value="${accountBank.developUnit}" type="text">
							</td>
							<th width="15%">到账时间</th>
							<td width="35%">
								<input name="queryArrivalTimeStart" id="queryArrivalTimeStart" style="width: 140px"
									value="<fmt:formatDate type='both' value='${queryArrivalTimeStart}' />"
									type="text" class="Wdate"
									onfocus="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss'})">
								至
								<input name="queryArrivalTimeEnd" id="queryArrivalTimeEnd" style="width: 140px"
									value="<fmt:formatDate type='both' value='${queryArrivalTimeEnd}' />"
									type="text" class="Wdate"
									onfocus="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss'})">
							</td>
						</tr>
						<tr>
							<th width="15%">有无凭证</th>
							<td width="35% ">
								<cus:SelectOneTag property="accountBank.hasInvoice" id="hasInvoice" defaultText='请选择' codeName="有无凭证" value="${accountBank.hasInvoice}" style="width: 136px;" />
							</td>
							<th width="15%">确认状态</th>
							<td width="35%">
								<cus:SelectOneTag property="accountBank.status" id="status" codeName="财务确认状态" value="${accountBank.status}" style="width: 136px;" />
							</td>
						</tr>
						<tr>
							<td colspan="4" align="center">
								<a href="###" class="btn_01" onclick="search_accountBank()" >查询<b></b></a>&nbsp;
								<a href="###" class="btn_01" onclick="clear_form(document.myform);" >清空<b></b></a>&nbsp;				
							</td>
						</tr>
					</table>
				</div>
			</div>
			<div id="pagination"></div>
        </div>
    </div>
</div>
</body>
</html>
