/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.BlobDBAccess;
import oracle.sql.DatumWithConnection;

public class BLOB
extends DatumWithConnection
implements Blob {
    public static final int MAX_CHUNK_SIZE = 32768;
    public static final int DURATION_SESSION = 10;
    public static final int DURATION_CALL = 12;
    static final int OLD_WRONG_DURATION_SESSION = 1;
    static final int OLD_WRONG_DURATION_CALL = 2;
    public static final int MODE_READONLY = 0;
    public static final int MODE_READWRITE = 1;
    BlobDBAccess dbaccess;
    int dbChunkSize;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Sat_Feb__2_11:39:32_PST_2008";

    protected BLOB() {
    }

    public BLOB(oracle.jdbc.OracleConnection oracleConnection) throws SQLException {
        this(oracleConnection, null);
    }

    public BLOB(oracle.jdbc.OracleConnection oracleConnection, byte[] byArray) throws SQLException {
        super(byArray);
        BLOB.assertNotNull(oracleConnection);
        this.setPhysicalConnectionOf(oracleConnection);
        this.dbaccess = this.getPhysicalConnection().createBlobDBAccess();
        this.dbChunkSize = -1;
    }

    public long length() throws SQLException {
        return this.getDBAccess().length(this);
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        if (n < 0 || l < 1L) {
            DatabaseError.throwSqlException(68, "getBytes()");
        }
        byte[] byArray = null;
        if (n == 0) {
            byArray = new byte[]{};
        } else {
            long l2 = 0L;
            byte[] byArray2 = new byte[n];
            l2 = this.getBytes(l, n, byArray2);
            if (l2 > 0L) {
                if (l2 == (long)n) {
                    byArray = byArray2;
                } else {
                    byArray = new byte[(int)l2];
                    System.arraycopy(byArray2, 0, byArray, 0, (int)l2);
                }
            }
        }
        return byArray;
    }

    public InputStream getBinaryStream() throws SQLException {
        return this.getDBAccess().newInputStream(this, this.getBufferSize(), 0L);
    }

    public long position(byte[] byArray, long l) throws SQLException {
        return this.getDBAccess().position(this, byArray, l);
    }

    public long position(Blob blob, long l) throws SQLException {
        return this.getDBAccess().position(this, (BLOB)blob, l);
    }

    public int getBytes(long l, int n, byte[] byArray) throws SQLException {
        return this.getDBAccess().getBytes(this, l, n, byArray);
    }

    public int putBytes(long l, byte[] byArray) throws SQLException {
        return this.setBytes(l, byArray);
    }

    public int putBytes(long l, byte[] byArray, int n) throws SQLException {
        return this.setBytes(l, byArray, 0, n);
    }

    public OutputStream getBinaryOutputStream() throws SQLException {
        return this.setBinaryStream(0L);
    }

    public byte[] getLocator() {
        return this.getBytes();
    }

    public void setLocator(byte[] byArray) {
        this.setBytes(byArray);
    }

    public int getChunkSize() throws SQLException {
        if (this.dbChunkSize <= 0) {
            this.dbChunkSize = this.getDBAccess().getChunkSize(this);
        }
        return this.dbChunkSize;
    }

    public int getBufferSize() throws SQLException {
        int n;
        int n2 = n = this.getChunkSize();
        n2 = n >= 32768 || n <= 0 ? 32768 : 32768 / n * n;
        return n2;
    }

    public static BLOB empty_lob() throws SQLException {
        return BLOB.getEmptyBLOB();
    }

    public static BLOB getEmptyBLOB() throws SQLException {
        byte[] byArray = new byte[86];
        byArray[1] = 84;
        byArray[5] = 24;
        BLOB bLOB = new BLOB();
        bLOB.setShareBytes(byArray);
        return bLOB;
    }

    public boolean isEmptyLob() throws SQLException {
        boolean bl = (this.shareBytes()[5] & 0x10) != 0;
        return bl;
    }

    public OutputStream getBinaryOutputStream(long l) throws SQLException {
        return this.setBinaryStream(l);
    }

    public InputStream getBinaryStream(long l) throws SQLException {
        return this.getDBAccess().newInputStream(this, this.getBufferSize(), l);
    }

    public void trim(long l) throws SQLException {
        this.truncate(l);
    }

    public static BLOB createTemporary(Connection connection, boolean bl, int n) throws SQLException {
        int n2 = n;
        if (n == 1) {
            n2 = 10;
        }
        if (n == 2) {
            n2 = 12;
        }
        if (connection == null || n2 != 10 && n2 != 12) {
            DatabaseError.throwSqlException(68);
        }
        OracleConnection oracleConnection = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin();
        return BLOB.getDBAccess(oracleConnection).createTemporaryBlob(oracleConnection, bl, n2);
    }

    public static void freeTemporary(BLOB bLOB) throws SQLException {
        if (bLOB == null) {
            return;
        }
        bLOB.freeTemporary();
    }

    public static boolean isTemporary(BLOB bLOB) throws SQLException {
        if (bLOB == null) {
            return false;
        }
        return bLOB.isTemporary();
    }

    public void freeTemporary() throws SQLException {
        this.getDBAccess().freeTemporary(this);
    }

    public boolean isTemporary() throws SQLException {
        return this.getDBAccess().isTemporary(this);
    }

    public void open(int n) throws SQLException {
        this.getDBAccess().open(this, n);
    }

    public void close() throws SQLException {
        this.getDBAccess().close(this);
    }

    public boolean isOpen() throws SQLException {
        return this.getDBAccess().isOpen(this);
    }

    public int setBytes(long l, byte[] byArray) throws SQLException {
        return this.getDBAccess().putBytes(this, l, byArray, 0, byArray != null ? byArray.length : 0);
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        return this.getDBAccess().putBytes(this, l, byArray, n, n2);
    }

    public OutputStream setBinaryStream(long l) throws SQLException {
        return this.getDBAccess().newOutputStream(this, this.getBufferSize(), l);
    }

    public void truncate(long l) throws SQLException {
        if (l < 0L) {
            DatabaseError.throwSqlException(68);
        }
        this.getDBAccess().trim(this, l);
    }

    public Object toJdbc() throws SQLException {
        return this;
    }

    public boolean isConvertibleTo(Class clazz) {
        String string = clazz.getName();
        return string.compareTo("java.io.InputStream") == 0 || string.compareTo("java.io.Reader") == 0;
    }

    public Reader characterStreamValue() throws SQLException {
        BlobDBAccess blobDBAccess = this.getDBAccess();
        this.getInternalConnection();
        return blobDBAccess.newConversionReader(this, 8);
    }

    public InputStream asciiStreamValue() throws SQLException {
        BlobDBAccess blobDBAccess = this.getDBAccess();
        this.getInternalConnection();
        return blobDBAccess.newConversionInputStream(this, 2);
    }

    public InputStream binaryStreamValue() throws SQLException {
        return this.getBinaryStream();
    }

    public Object makeJdbcArray(int n) {
        return new BLOB[n];
    }

    public BlobDBAccess getDBAccess() throws SQLException {
        if (this.dbaccess == null) {
            if (this.isEmptyLob()) {
                DatabaseError.throwSqlException(98);
            }
            this.dbaccess = this.getInternalConnection().createBlobDBAccess();
        }
        if (this.getPhysicalConnection().isClosed()) {
            DatabaseError.throwSqlException(8);
        }
        return this.dbaccess;
    }

    public static BlobDBAccess getDBAccess(Connection connection) throws SQLException {
        return ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin().createBlobDBAccess();
    }

    public Connection getJavaSqlConnection() throws SQLException {
        return super.getJavaSqlConnection();
    }
}

