/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jshx.sender;

import cn.com.jshx.platform.DownMessage;
import cn.com.jshx.platform.SysInterLocator;
import cn.com.jshx.sender.interfaces.Sender;
import cn.com.jshx.util.Config;
import java.rmi.RemoteException;
import java.util.Map;
import javax.xml.rpc.ServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SMPlatformSender
implements Sender {
    private static final Log logger = LogFactory.getLog(SMPlatformSender.class);
    private static String platformAddr = Config.getProperty("systemAddr");
    private String responseStart = "<Response>";
    private String responseEnd = "</Response>";

    @Override
    public int send(String mobile, String content) {
        String response;
        block6: {
            DownMessage message = new DownMessage();
            message.setRecNumber(mobile);
            message.setRecContent(content);
            SysInterLocator sysInterLocator = new SysInterLocator();
            sysInterLocator.setSysInterHttpPortEndpointAddress(platformAddr);
            logger.debug((Object)("send message:" + message.toXML()));
            response = sysInterLocator.getSysInterHttpPort().sysSendMessage(message.toXML());
            logger.debug((Object)("response message:" + response));
            if (-1 != response.indexOf(this.responseStart)) break block6;
            return 0xFFFFFF;
        }
        try {
            String errorCode = response.substring(response.indexOf(this.responseStart) + this.responseStart.length(), response.indexOf(this.responseEnd));
            if (Integer.parseInt(errorCode) == 0) {
                return 0;
            }
            return 0xFFFFFF;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            logger.error((Object)("send message error,exception:" + e.toString()));
        }
        catch (ServiceException e) {
            e.printStackTrace();
            logger.error((Object)("send message error,exception:" + e.toString()));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            logger.error((Object)("send message error,exception:" + e.toString()));
        }
        return 0xFFFFFF;
    }

    @Override
    public int send(Map<String, String> map, String mobile, String content) {
        return 0;
    }
}

