/*
 * Decompiled with CFR 0.152.
 */
package com.fr.write.config;

import com.fr.general.ComparatorUtils;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.stable.ArrayUtils;
import com.fr.stable.ColumnRow;
import com.fr.stable.ColumnRowGroup;
import com.fr.stable.ColumnRowRelated;
import com.fr.stable.Constants;
import com.fr.stable.FormulaProvider;
import com.fr.stable.ParameterProvider;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.write.WriteCellAble;
import com.fr.stable.xml.StableXMLUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;

public class ColumnConfig
implements XMLable {
    public static final String XML_TAG = "ColumnConfig";
    private String name;
    private Object value;
    private boolean isKey;
    private boolean skipUnmodified;

    public ColumnConfig() {
    }

    public ColumnConfig(String string, Object object, boolean bl) {
        this(string, object, bl, false);
    }

    public ColumnConfig(String string, Object object, boolean bl, boolean bl2) {
        this.name = string;
        this.value = object;
        this.isKey = bl;
        this.skipUnmodified = bl2;
    }

    public String getColumnName() {
        return this.name;
    }

    public void setColumnName(String string) {
        this.name = string;
    }

    public Object getColumnValue() {
        return this.value;
    }

    public boolean isModified(CalculatorProvider calculatorProvider) {
        Object[] objectArray;
        if (this.value instanceof ColumnRowRelated && !ArrayUtils.isEmpty(objectArray = ((ColumnRowRelated)this.value).getRelatedColumnRows())) {
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = calculatorProvider.resolveRelateCellElements((ColumnRow)objectArray[i]);
                if (!this.modifyOrNo(object)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean modifyOrNo(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass().isArray()) {
            int n;
            Object[] objectArray = (Object[])object;
            WriteCellAble[] writeCellAbleArray = new WriteCellAble[objectArray.length];
            for (n = 0; n < objectArray.length; ++n) {
                writeCellAbleArray[n] = (WriteCellAble)objectArray[n];
            }
            for (n = 0; n < writeCellAbleArray.length; ++n) {
                if (!this.modifyOrNo(writeCellAbleArray[n])) continue;
                return true;
            }
            return false;
        }
        if (((WriteCellAble)object).isNewInsert()) {
            return true;
        }
        Object object2 = ((WriteCellAble)object).getOriValue();
        Object object3 = ((WriteCellAble)object).getValue();
        if (object2 == Constants.INIT_NULL) {
            return false;
        }
        if (object3 instanceof FormulaProvider && ComparatorUtils.equals("TFC", ((FormulaProvider)object3).getXmlTag())) {
            return true;
        }
        return object2 != Constants.INIT_NULL && !ComparatorUtils.equals(object2, object3);
    }

    public boolean isDeleted(CalculatorProvider calculatorProvider) {
        Object[] objectArray;
        if (this.value instanceof ColumnRowRelated && !ArrayUtils.isEmpty(objectArray = ((ColumnRowRelated)this.value).getRelatedColumnRows())) {
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = calculatorProvider.resolveRelateCellElements((ColumnRow)objectArray[i]);
                if (!this.deleteOrNo(object)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDeletedColumnRow(CalculatorProvider calculatorProvider) {
        Object[] objectArray;
        if (this.value instanceof ColumnRow && !ArrayUtils.isEmpty(objectArray = ((ColumnRow)this.value).getRelatedColumnRows())) {
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = calculatorProvider.resolveRelateCellElements((ColumnRow)objectArray[i]);
                if (!this.deleteOrNoWriteCellAble(object)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean deleteOrNoWriteCellAble(Object object) {
        if (object instanceof WriteCellAble) {
            return ((WriteCellAble)object).isDel();
        }
        return false;
    }

    private boolean deleteOrNo(Object object) {
        if (object == null) {
            return false;
        }
        if (!object.getClass().isArray()) {
            return this.deleteOrNoWriteCellAble(object);
        }
        Object[] objectArray = (Object[])object;
        for (int i = 0; i < objectArray.length; ++i) {
            if (!this.deleteOrNo(objectArray[i])) continue;
            return true;
        }
        return false;
    }

    public void setColumnValue(Object object) {
        this.value = object;
    }

    public boolean isKey() {
        return this.isKey;
    }

    public boolean isSkipUnmodified() {
        return this.skipUnmodified;
    }

    public void setSkipUnmodified(boolean bl) {
        this.skipUnmodified = bl;
    }

    public String toString() {
        return (this.isKey ? "* " : "") + this.name + ":" + this.value;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string = null;
        if (xMLableReader.isAttr()) {
            string = xMLableReader.getAttrAsString("name", null);
            if (string != null) {
                this.name = string;
            }
            this.isKey = xMLableReader.getAttrAsBoolean("isKey", false);
            this.skipUnmodified = xMLableReader.getXMLVersion().isAfterREPORT_REFECT_FOR7_0_XML_VERSION() && !xMLableReader.getXMLVersion().isAfterREPORT_REFECT_FOR7_1_XML_VERSION() ? true : xMLableReader.getAttrAsBoolean("skipUnmodified", false);
        }
        if (xMLableReader.isChildNode()) {
            Object object;
            String string2 = xMLableReader.getTagName();
            if ("ColumnRow".endsWith(string2)) {
                int n = xMLableReader.getAttrAsInt("column", 0);
                int n2 = xMLableReader.getAttrAsInt("row", 0);
                object = ColumnRow.valueOf(n, n2);
            } else if (ColumnRowGroup.XML_TAG.endsWith(string2)) {
                ColumnRowGroup columnRowGroup = new ColumnRowGroup();
                object = xMLableReader.readXMLObject(columnRowGroup);
            } else {
                object = "Parameter".equals(string2) ? StableXMLUtils.readParameter(xMLableReader) : ("Object".equals(string2) || "O".equals(string2) ? GeneralXMLTools.readObject(xMLableReader) : "");
            }
            this.setColumnValue(object);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG).attr("name", this.name).attr("isKey", this.isKey).attr("skipUnmodified", this.skipUnmodified);
        if (this.value instanceof ColumnRow) {
            ColumnRow columnRow = (ColumnRow)this.value;
            StableXMLUtils.writeColumnRow(xMLPrintWriter, columnRow);
        } else if (this.value instanceof ColumnRowGroup) {
            ((ColumnRowGroup)this.value).writeXML(xMLPrintWriter);
        } else if (this.value instanceof ParameterProvider) {
            StableXMLUtils.writeParameter(xMLPrintWriter, (ParameterProvider)this.value);
        } else {
            GeneralXMLTools.writeObject(xMLPrintWriter, this.value);
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        return object instanceof ColumnConfig && ((ColumnConfig)object).isKey == this.isKey && ((ColumnConfig)object).skipUnmodified == this.skipUnmodified && ComparatorUtils.equals(((ColumnConfig)object).name, this.name) && ComparatorUtils.equals(((ColumnConfig)object).value, this.value);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

