/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.utils;

import com.fr.base.ConfigManager;
import com.fr.base.FRContext;
import com.fr.base.TemplateUtils;
import com.fr.base.Utils;
import com.fr.data.NetworkHelper;
import com.fr.general.ComparatorUtils;
import com.fr.general.FArray;
import com.fr.general.FRLogger;
import com.fr.general.GeneralUtils;
import com.fr.general.Inter;
import com.fr.general.SiteCenter;
import com.fr.general.web.ParameterConsts;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.ExtraClassManager;
import com.fr.privilege.session.PrivilegeInfoSessionMananger;
import com.fr.script.Calculator;
import com.fr.stable.BaseSessionFilterParameterManager;
import com.fr.stable.CodeUtils;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.fun.RequestParameterCollector;
import com.fr.stable.fun.WebLocaleProvider;
import com.fr.stable.web.Device;
import com.fr.web.AttachmentHelper;
import com.fr.web.ImportJsCssProvider;
import com.fr.web.ResourceType;
import com.fr.web.utils.DefaultRequestParameterCollector;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebUtils {
    private WebUtils() {
    }

    public static String getHTTPRequestParameter(HttpServletRequest httpServletRequest, String string) {
        return NetworkHelper.getHTTPRequestParameter(httpServletRequest, string);
    }

    public static String getHTTPRequestParameter(HttpServletRequest httpServletRequest, String ... stringArray) {
        return NetworkHelper.getHTTPRequestParameter(httpServletRequest, stringArray);
    }

    public static boolean getHTTPRequestBoolParameter(HttpServletRequest httpServletRequest, String string) {
        return NetworkHelper.getHTTPRequestBoolParameter(httpServletRequest, string);
    }

    public static int getHTTPRequestIntParameter(HttpServletRequest httpServletRequest, String string) {
        return WebUtils.getHTTPRequestIntParameter(httpServletRequest, string, -1);
    }

    public static int getHTTPRequestIntParameter(HttpServletRequest httpServletRequest, String string, int n) {
        return NetworkHelper.getHTTPRequestIntParameter(httpServletRequest, string, n);
    }

    public static String getReportTitleFromRequest(HttpServletRequest httpServletRequest) {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "reportlet");
        if (string == null) {
            string = WebUtils.getHTTPRequestParameter(httpServletRequest, "reportlets");
        }
        if (string == null) {
            string = WebUtils.getHTTPRequestParameter(httpServletRequest, "resultlet");
        }
        return string;
    }

    public static String createServletURL(HttpServletRequest httpServletRequest) {
        return NetworkHelper.createServletURL(httpServletRequest);
    }

    public static PrintWriter createPrintWriter(HttpServletResponse httpServletResponse) throws IOException {
        return NetworkHelper.createPrintWriter(httpServletResponse);
    }

    public static PrintWriter createPrintWriter(HttpServletResponse httpServletResponse, String string) throws IOException {
        return NetworkHelper.createPrintWriter(httpServletResponse, string);
    }

    public static void printAsJSON(HttpServletResponse httpServletResponse, JSONObject jSONObject) throws Exception {
        WebUtils.printAsString(httpServletResponse, jSONObject.toString());
    }

    public static void printAsJSON(HttpServletResponse httpServletResponse, JSONArray jSONArray) throws Exception {
        WebUtils.printAsString(httpServletResponse, jSONArray.toString());
    }

    public static void printAsString(HttpServletResponse httpServletResponse, String string) throws Exception {
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        printWriter.print(string);
        printWriter.flush();
        printWriter.close();
    }

    public static Object object2JSONable(Object object) throws JSONException {
        return WebUtils.object2JSONable(object, -1, -1);
    }

    public static Object object2JSONable(Object object, int n, int n2) throws JSONException {
        if (object instanceof Date) {
            return new JSONObject().put("date_milliseconds", new Long(((Date)object).getTime()));
        }
        if (object instanceof Image) {
            if (n2 > 0 && n > 0) {
                return AttachmentHelper.addAttachment((Image)object, n, n2).toConfig();
            }
            return AttachmentHelper.addAttachment((Image)object).toConfig();
        }
        if (object instanceof Double ? ((Double)object).isInfinite() || ((Double)object).isNaN() : object instanceof Float && (((Float)object).isInfinite() || ((Float)object).isNaN())) {
            return Utils.objectToString(object);
        }
        return object;
    }

    public static void getPageWhenOverflow(HttpServletResponse httpServletResponse, Collection collection) throws IOException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        boolean bl = StableUtils.getBytes() == null;
        String string = "";
        if (bl) {
            String string2 = SiteCenter.getInstance().acquireUrlByKind("website." + FRContext.getLocale(), "http://www.fanruan.com");
            string = "window.open(\"" + string2 + "\");";
        }
        hashMap.put("addresses", new FArray(collection));
        hashMap.put("isRegistered", string);
        hashMap.put("overflow", Inter.getLocText("FR-Engine_overflow"));
        WebUtils.writeOutTemplate("/com/fr/web/core/overflow.html", httpServletResponse, hashMap);
    }

    public static void dealWithTemplate(String string, HttpServletResponse httpServletResponse) throws IOException {
        WebUtils.writeOutTemplate(string, httpServletResponse, Collections.EMPTY_MAP);
    }

    public static void writeOutTemplate(String string, HttpServletResponse httpServletResponse, Map map) throws IOException {
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        WebUtils.setResourceContentType(string, httpServletResponse);
        TemplateUtils.dealWithTemplate(string, printWriter, map);
        printWriter.flush();
        printWriter.close();
    }

    public static boolean invalidResourcePath(String string) {
        if (StringUtils.isEmpty(string) || string.indexOf("\u0000.") != -1) {
            return true;
        }
        if (string.startsWith("http")) {
            return string.indexOf("127.0.0.1") != -1 || string.indexOf("localhost") != -1;
        }
        return string.indexOf("../../../") != -1 || string.indexOf("..//") != -1;
    }

    public static ResourceType setResourceContentType(String string, HttpServletResponse httpServletResponse) {
        if (StringUtils.isBlank(string)) {
            return ResourceType.NONE;
        }
        return WebUtils.getResourceType(httpServletResponse, string.toLowerCase());
    }

    private static ResourceType getResourceType(HttpServletResponse httpServletResponse, String string) {
        String string2 = ConfigManager.getProviderInstance().getServerCharset();
        if (string.endsWith(".png")) {
            httpServletResponse.setContentType("image/png");
        } else if (string.endsWith(".gif")) {
            httpServletResponse.setContentType("image/gif");
        } else if (string.endsWith(".jpg")) {
            httpServletResponse.setContentType("image/jpeg");
        } else {
            if (string.endsWith(".js")) {
                httpServletResponse.setContentType("text/javascript;charset=" + string2);
                return ResourceType.FILE;
            }
            if (string.endsWith(".json")) {
                httpServletResponse.setContentType("text/plain;charset=" + string2);
                return ResourceType.FILE;
            }
            if (string.endsWith(".css")) {
                httpServletResponse.setContentType("text/css;charset=" + string2);
                return ResourceType.FILE;
            }
            if (string.endsWith(".xml")) {
                httpServletResponse.setContentType("text/xml;charset=" + string2);
                return ResourceType.NONE;
            }
            if (string.endsWith(".swf")) {
                httpServletResponse.setContentType("application/x-shockwave-flash");
            } else if (string.endsWith(".jnlp")) {
                httpServletResponse.setContentType("application/x-java-jnlp-file");
            } else if (string.endsWith(".xls")) {
                httpServletResponse.setContentType("application/vnd.ms-excel");
            } else if (string.endsWith(".exe")) {
                httpServletResponse.setContentType("application/x-msdownload");
                httpServletResponse.setHeader("extension", "exe");
                httpServletResponse.setHeader("Content-disposition", "attachment; filename=AcrobatReader.exe");
            } else if (string.endsWith(".ttf")) {
                httpServletResponse.setContentType(".ttf");
            } else if (string.endsWith(".eot")) {
                httpServletResponse.setContentType(".eot");
            } else if (string.endsWith(".woff")) {
                httpServletResponse.setContentType(".woff");
            } else if (string.endsWith(".cur")) {
                httpServletResponse.setContentType(".cur");
            } else if (string.endsWith(".htc")) {
                httpServletResponse.setContentType("text/x-component");
            } else {
                if (string.endsWith(".html")) {
                    httpServletResponse.setContentType("text/html;charset=" + string2);
                    return ResourceType.FILE;
                }
                httpServletResponse.setContentType("text/html;charset=" + string2);
                return ResourceType.NONE;
            }
        }
        return ResourceType.OTHER;
    }

    public static Map createSessionIDParameterMap(HttpServletRequest httpServletRequest) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (StringUtils.isBlank(string) || WebUtils.isSpecificParameters(string)) continue;
            hashMap.put(string, WebUtils.getHTTPRequestParameter(httpServletRequest, string));
        }
        return hashMap;
    }

    private static boolean isSpecificParameters(String string) {
        return "reportlet".equalsIgnoreCase(string) || "format".equalsIgnoreCase(string) || "op".equalsIgnoreCase(string);
    }

    public static Map<String, Object> dealWithExecuteParamMap(Map<String, Object> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (map != null) {
            for (String string : map.keySet()) {
                Object object = map.get(string);
                if (!(object instanceof JSONObject)) continue;
                Map<String, Object> map2 = ((JSONObject)object).toMap();
                for (String string2 : map2.keySet()) {
                    hashMap.put(string2, map2.get(string2));
                }
            }
            hashMap.putAll(map);
        }
        for (int i = 0; i < ParameterConsts.ALL.length; ++i) {
            if (!hashMap.containsKey(ParameterConsts.ALL[i])) continue;
            hashMap.remove(ParameterConsts.ALL[i]);
        }
        return hashMap;
    }

    public static String getWebINFPath(ServletContext servletContext) {
        String string = servletContext.getRealPath("/");
        if (string == null) {
            return null;
        }
        if (!string.endsWith("/") && !string.endsWith("\\")) {
            string = string + File.separator;
        }
        return string + "WEB-INF";
    }

    public static Map parameters4SessionIDInforContainMPCache(HttpServletRequest httpServletRequest) {
        Object object;
        Map<String, Object> map = WebUtils.parameters4SessionIDInfor(httpServletRequest);
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null && (object = httpSession.getAttribute("__FR_MOBILE_PARAM_CACHE__")) != null) {
            Map map2 = (Map)object;
            map.putAll(map2);
            httpSession.removeAttribute("__FR_MOBILE_PARAM_CACHE__");
        }
        return map;
    }

    public static Map<String, Object> parameters4SessionIDInfor(HttpServletRequest httpServletRequest) {
        Object object;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (httpServletRequest == null) {
            return hashMap;
        }
        RequestParameterCollector requestParameterCollector = (RequestParameterCollector)ExtraClassManager.getInstance().getSingle("RequestParameterCollector");
        if (requestParameterCollector == null) {
            requestParameterCollector = DefaultRequestParameterCollector.getInstance();
        }
        hashMap.putAll(requestParameterCollector.getParametersFromSession(httpServletRequest));
        hashMap.putAll(requestParameterCollector.getParametersFromAttribute(httpServletRequest));
        hashMap.putAll(requestParameterCollector.getParametersFromParameter(httpServletRequest));
        hashMap.putAll(requestParameterCollector.getParametersFromJSON(httpServletRequest, hashMap));
        hashMap.putAll(requestParameterCollector.getParametersFromReqInputStream(httpServletRequest));
        HttpSession httpSession = httpServletRequest.getSession(false);
        hashMap.put("__locale__", WebUtils.getLocale(httpServletRequest));
        if (hashMap.get("__redirect_from") == null) {
            object = BaseSessionFilterParameterManager.getFilterParameters();
            for (int i = 0; i < ((String[])object).length; ++i) {
                hashMap.remove(object[i]);
            }
        }
        if (httpSession != null) {
            FArray fArray;
            String string;
            object = PrivilegeInfoSessionMananger.getCurrentAuthorities(httpSession);
            if (object != null) {
                hashMap.put("fr_authority", object);
            }
            if ((string = PrivilegeInfoSessionMananger.getCurrentUserName(httpSession)) != null) {
                hashMap.put("fr_username", string);
            }
            if ((fArray = PrivilegeInfoSessionMananger.getCurrentDepartmentAndPost(httpSession)) != null) {
                hashMap.put("fr_userposition", fArray);
            }
        }
        return hashMap;
    }

    private static void readParaFromSession(Map map, HttpSession httpSession) {
        if (httpSession != null) {
            Enumeration enumeration = httpSession.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                String string = CodeUtils.decodeText("" + e);
                map.put(string.toUpperCase(), httpSession.getAttribute("" + e));
            }
        }
    }

    private static void readParaFromAttr(Map map, HttpServletRequest httpServletRequest) {
        Enumeration enumeration = httpServletRequest.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            String string = CodeUtils.decodeText("" + e);
            try {
                if (map.containsKey(string.toUpperCase())) {
                    map.remove(string.toUpperCase());
                }
                map.put(string, WebUtils.getHTTPRequestParameter(httpServletRequest, "" + e));
            }
            catch (Exception exception) {}
        }
    }

    private static void readParaFromParameter(Map map, HttpServletRequest httpServletRequest) {
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            String string = CodeUtils.decodeText("" + e);
            try {
                if (map.containsKey(string.toUpperCase())) {
                    map.remove(string.toUpperCase());
                }
                map.put(string, WebUtils.getHTTPRequestParameter(httpServletRequest, "" + e));
                if ("reportlet".equalsIgnoreCase(string)) {
                    map.put("reportName", WebUtils.getHTTPRequestParameter(httpServletRequest, "" + e));
                }
                if ("formlet".equalsIgnoreCase(string)) {
                    map.put("formletName", WebUtils.getHTTPRequestParameter(httpServletRequest, "" + e));
                }
                map.put(URLDecoder.decode(string, "UTF-8"), WebUtils.getHTTPRequestParameter(httpServletRequest, "" + e));
            }
            catch (Exception exception) {}
        }
    }

    private static void readParaFromJSONParameter(Map map) {
        Object v2 = map.get("__parameters__");
        if (v2 instanceof String) {
            try {
                Map map2 = GeneralUtils.jsonString2Map((String)v2);
                for (Map.Entry entry : map2.entrySet()) {
                    String string = (String)entry.getKey();
                    if (!map.containsKey(string.toUpperCase())) continue;
                    map.remove(string.toUpperCase());
                }
                map.putAll(map2);
                map.remove("__parameters__");
            }
            catch (JSONException jSONException) {
                FRLogger.getLogger().error(jSONException.getMessage(), jSONException);
            }
        }
    }

    public static String getOriginalURL(HttpServletRequest httpServletRequest) {
        return NetworkHelper.getOriginalURL(httpServletRequest);
    }

    public static String getIpAddr(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getHeader("x-forwarded-for");
        if (StringUtils.isEmpty(string) || "unknown".equalsIgnoreCase(string)) {
            string = httpServletRequest.getHeader("Proxy-Client-IP");
        }
        if (StringUtils.isEmpty(string) || "unknown".equalsIgnoreCase(string)) {
            string = httpServletRequest.getHeader("WL-Proxy-Client-IP");
        }
        if (StringUtils.isEmpty(string) || "unknown".equalsIgnoreCase(string)) {
            string = httpServletRequest.getRemoteAddr();
        }
        return string == null ? "unknown" : string;
    }

    public static boolean isLocalHost(String string) {
        return "127.0.0.1".equals(string) || "localhost".equals(string) || string != null && string.startsWith("0:0:0:0:0:0:0:1");
    }

    public static int receivePageNumber(HttpServletRequest httpServletRequest) {
        Number number;
        int n = 0;
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "pn");
        if (string != null && ((number = Utils.string2Number(string)) == null || (n = number.intValue()) < 0)) {
            n = Integer.MAX_VALUE;
        }
        return n;
    }

    public static Device getDevice(HttpServletRequest httpServletRequest) {
        return Device.parse(WebUtils.getHTTPRequestParameter(httpServletRequest, "__device__"));
    }

    public static Locale getLocale(HttpServletRequest httpServletRequest) {
        if (httpServletRequest == null) {
            return FRContext.getLocale();
        }
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "fr_locale");
        String string2 = string = string == null ? WebUtils.getHTTPRequestParameter(httpServletRequest, "__fr_locale__") : string;
        if (StringUtils.isEmpty(string) && "zh_CN".equals(String.valueOf(httpServletRequest.getLocale()))) {
            return Locale.CHINA;
        }
        Locale locale = StableUtils.createLocale(string);
        locale = locale == null ? httpServletRequest.getLocale() : locale;
        return WebUtils.convertHAN(locale);
    }

    private static Locale convertHAN(Locale locale) {
        String string = String.valueOf(locale);
        if (StringUtils.contains(string.toUpperCase(), "HANS")) {
            return Locale.CHINA;
        }
        if (StringUtils.contains(string.toUpperCase(), "HANT")) {
            return Locale.TAIWAN;
        }
        if (ComparatorUtils.equals(string, "ja")) {
            return Locale.JAPAN;
        }
        Set set = ExtraClassManager.getInstance().getArray("WebLocaleProvider");
        for (WebLocaleProvider webLocaleProvider : set) {
            locale = webLocaleProvider.dispatchLocale(string);
            if (locale == null) continue;
            return locale;
        }
        return locale;
    }

    public static String getCSSLinks(Calculator calculator) {
        return WebUtils.getCSSLinks(calculator, null);
    }

    public static String getCSSLinks(Calculator calculator, ImportJsCssProvider importJsCssProvider) {
        String[] stringArray = WebUtils.getImportedCSS(importJsCssProvider);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                String string = stringArray[i];
                string = TemplateUtils.render(string, calculator);
                stringBuffer.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"");
                stringBuffer.append(string);
                stringBuffer.append("\"></link>").append('\n');
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stringBuffer.toString();
    }

    public static String getJSLinks(Calculator calculator) {
        return WebUtils.getJSLinks(calculator, null);
    }

    public static String getJSLinks(Calculator calculator, ImportJsCssProvider importJsCssProvider) {
        String[] stringArray = WebUtils.getImportedJS(importJsCssProvider);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                String string = stringArray[i];
                string = TemplateUtils.render(string, calculator);
                stringBuffer.append("<script type=\"text/javascript\" src=\"");
                stringBuffer.append(string);
                stringBuffer.append("\"></script>").append('\n');
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stringBuffer.toString();
    }

    private static String[] getImportedCSS(ImportJsCssProvider importJsCssProvider) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        ImportJsCssProvider importJsCssProvider2 = WebUtils.getGlobalWebAttr();
        if (importJsCssProvider2 != null) {
            linkedHashSet.addAll(Arrays.asList(importJsCssProvider2.getCSSImport()));
        }
        if (importJsCssProvider != null) {
            linkedHashSet.addAll(Arrays.asList(importJsCssProvider.getCSSImport()));
        }
        return linkedHashSet.toArray(new String[linkedHashSet.size()]);
    }

    private static ImportJsCssProvider getGlobalWebAttr() {
        Class<ImportJsCssProvider> clazz = StableFactory.getMarkedClass("ReportWebAttr", ImportJsCssProvider.class);
        return (ImportJsCssProvider)ConfigManager.getProviderInstance().getGlobalAttribute(clazz);
    }

    private static String[] getImportedJS(ImportJsCssProvider importJsCssProvider) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        ImportJsCssProvider importJsCssProvider2 = WebUtils.getGlobalWebAttr();
        if (importJsCssProvider2 != null) {
            linkedHashSet.addAll(Arrays.asList(importJsCssProvider2.getJSImport()));
        }
        if (importJsCssProvider != null) {
            linkedHashSet.addAll(Arrays.asList(importJsCssProvider.getJSImport()));
        }
        return linkedHashSet.toArray(new String[linkedHashSet.size()]);
    }
}

