/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web;

import com.fr.general.ComparatorUtils;
import javax.servlet.ServletConfig;

public final class J2EEContainer {
    public static final String UNKNOWN = "Unknown";
    public static final String JETTY = "Jetty";
    public static final String TOMCAT = "Tomcat";
    public static final String WEBSPHERE = "Websphere";
    public static final String WEBLOGIC = "WebLogic";
    public static final String JBOSS = "JBoss";
    private static final String JBOSS7 = "JBoss7";
    public static final String RESIN = "Resin";
    public static final String APUSIC = "Apusic";
    private static final int INDEXOFHIGHJBOSSVERSION = -1;
    public static String PROVIDER = "Unknown";

    private J2EEContainer() {
    }

    public static void init(ServletConfig servletConfig) {
        String string = servletConfig.getClass().getName();
        String string2 = servletConfig.getServletContext().getServerInfo();
        if (string2.startsWith(JETTY)) {
            PROVIDER = JETTY;
        } else if (string2.startsWith("IBM WebSphere")) {
            PROVIDER = WEBSPHERE;
        } else if (string2.startsWith(WEBLOGIC)) {
            PROVIDER = WEBLOGIC;
        } else if (string2.startsWith(JBOSS) && string2.indexOf("7.") != -1) {
            PROVIDER = JBOSS7;
        } else if (string2.startsWith(JBOSS)) {
            PROVIDER = JBOSS;
        } else if (string2.startsWith("Apache Tomcat")) {
            PROVIDER = TOMCAT;
        } else if (string2.startsWith(RESIN)) {
            PROVIDER = RESIN;
        } else if (string.startsWith("com.apusic")) {
            PROVIDER = APUSIC;
        }
    }

    public static boolean isWebLogic() {
        return ComparatorUtils.equals(WEBLOGIC, PROVIDER);
    }

    public static boolean isJetty() {
        return ComparatorUtils.equals(JETTY, PROVIDER);
    }

    public static boolean isWebSphere() {
        return ComparatorUtils.equals(WEBSPHERE, PROVIDER);
    }

    public static boolean isTomcat() {
        return ComparatorUtils.equals(TOMCAT, PROVIDER);
    }

    public static boolean isJBoss() {
        return ComparatorUtils.equals(JBOSS, PROVIDER);
    }

    public static boolean isJBoss7() {
        return ComparatorUtils.equals(JBOSS7, PROVIDER);
    }

    public static boolean isResin() {
        return ComparatorUtils.equals(RESIN, PROVIDER);
    }

    public static boolean isApusic() {
        return ComparatorUtils.equals(APUSIC, PROVIDER);
    }
}

