/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web;

import com.fr.base.ConfigManager;
import com.fr.base.FRContext;
import com.fr.base.IconManager;
import com.fr.general.ModuleContext;
import com.fr.general.RegistEditionException;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.ExtraClassManager;
import com.fr.plugin.PluginLoader;
import com.fr.record.DBRecordManager;
import com.fr.script.Calculator;
import com.fr.stable.BuildContext;
import com.fr.stable.FRException;
import com.fr.stable.ProductConstants;
import com.fr.stable.fun.PerformanceProcessor;
import com.fr.stable.fun.SessionPrivilegeFilterProvider;
import com.fr.stable.monitor.MemoryAlarmException;
import com.fr.web.Browser;
import com.fr.web.J2EEContainer;
import com.fr.web.core.A.oD;
import com.fr.web.core.ErrorHandlerHelper;
import com.fr.web.core.ReportDispatcher;
import com.fr.web.core.ServerEnv;
import com.fr.web.core.gzip.GZIPResponseWrapper;
import com.fr.web.utils.ThreadLocalUtils;
import com.fr.web.utils.WebUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseServlet
extends HttpServlet {
    private static final long serialVersionUID = 2204797189775876731L;
    private static String reportName;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        J2EEContainer.init(servletConfig);
        ServletContext servletContext = this.getServletContext();
        if (!BuildContext.hasSetBuildFilePath()) {
            BuildContext.setBuildFilePath(this.buildPropertiesPath());
        }
        try {
            if (FRContext.getCurrentEnv() == null) {
                this.initEnvAndPlugin(servletContext);
            }
            FRContext.getLogger().initRecord(DBRecordManager.getInstance());
            FRContext.getLogger().setLogLevel(ConfigManager.getProviderInstance().getServerLogLevel());
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        servletContext.setAttribute(((Object)((Object)this)).getClass().getName(), (Object)this);
        ModuleContext.startModule(this.moduleToStart());
    }

    private void initEnvAndPlugin(ServletContext servletContext) {
        FRContext.setCurrentEnv(new ServerEnv(servletContext));
        PluginLoader.init();
        PerformanceProcessor performanceProcessor = (PerformanceProcessor)ExtraClassManager.getInstance().getSingle("PerformanceProcessor");
        if (performanceProcessor != null) {
            performanceProcessor.closeLogRecord();
        }
    }

    public abstract String moduleToStart();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse object) throws IOException, ServletException {
        this.initWebAppName(httpServletRequest);
        BaseServlet.saveRequestContext(httpServletRequest);
        GZIPResponseWrapper gZIPResponseWrapper = null;
        try {
            String string = httpServletRequest.getHeader("accept-encoding");
            gZIPResponseWrapper = this.initGzipResponseWrapper(httpServletRequest, (HttpServletResponse)object, string);
            if (gZIPResponseWrapper != null) {
                object = gZIPResponseWrapper;
            }
            object.addHeader("P3P", "CP=CAO PSA OUR");
            Set set = ExtraClassManager.getInstance().getArray("SessionPrivilegeFilterProvider");
            for (SessionPrivilegeFilterProvider sessionPrivilegeFilterProvider : set) {
                sessionPrivilegeFilterProvider.addSecurityResponseHeader((HttpServletResponse)object);
            }
            ReportDispatcher.dealWithRequest(httpServletRequest, object);
        }
        catch (RegistEditionException registEditionException) {
            this.processRegisterException(httpServletRequest, (HttpServletResponse)object, registEditionException);
        }
        catch (MemoryAlarmException memoryAlarmException) {
            FRContext.getLogger().errorWithServerLevel(memoryAlarmException.getMessage(), memoryAlarmException);
            ErrorHandlerHelper.getErrorHandler().error(httpServletRequest, (HttpServletResponse)object, memoryAlarmException);
            System.gc();
        }
        catch (FRException fRException) {
            ErrorHandlerHelper.getErrorHandler().error(httpServletRequest, (HttpServletResponse)object, fRException);
        }
        catch (Exception exception) {
            FRContext.getLogger().errorWithServerLevel(exception.getMessage(), exception);
            ErrorHandlerHelper.getErrorHandler().error(httpServletRequest, (HttpServletResponse)object, exception);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            FRContext.getLogger().errorWithServerLevel(outOfMemoryError.getMessage(), outOfMemoryError);
            ErrorHandlerHelper.getErrorHandler().error(httpServletRequest, (HttpServletResponse)object, outOfMemoryError);
            System.gc();
        }
        catch (Throwable throwable) {
            FRContext.getLogger().errorWithServerLevel(throwable.getMessage(), throwable);
        }
        finally {
            if (gZIPResponseWrapper != null) {
                gZIPResponseWrapper.finishResponse();
            }
            ThreadLocalUtils.clear();
        }
    }

    private void processRegisterException(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, RegistEditionException registEditionException) throws IOException {
        if (registEditionException.isAjax()) {
            PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("exception", "FAILPASS");
                if (registEditionException.getFUNC() != null) {
                    jSONObject.put("func", registEditionException.getFUNC().toString());
                }
            }
            catch (JSONException jSONException) {
                FRContext.getLogger().error(registEditionException.getMessage());
            }
            printWriter.write(jSONObject.toString());
            printWriter.flush();
            printWriter.close();
        } else {
            FRContext.getLogger().errorWithServerLevel(registEditionException.getMessage(), registEditionException);
            ErrorHandlerHelper.getErrorHandler().error(httpServletRequest, httpServletResponse, registEditionException);
        }
    }

    private GZIPResponseWrapper initGzipResponseWrapper(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) {
        if (this.needGzip(httpServletRequest, string) && Browser.resolve(httpServletRequest).supportGzip()) {
            return new GZIPResponseWrapper(httpServletResponse);
        }
        return null;
    }

    private boolean needGzip(HttpServletRequest httpServletRequest, String string) {
        return ConfigManager.getProviderInstance().isSupportGzip() && !"false".equals(WebUtils.getHTTPRequestParameter(httpServletRequest, "gzip")) && string != null && string.indexOf("gzip") != -1;
    }

    private void initWebAppName(HttpServletRequest httpServletRequest) {
        if (ProductConstants.WEB_APP_NAME == null && (ProductConstants.WEB_APP_NAME = httpServletRequest.getContextPath()).startsWith("/")) {
            ProductConstants.WEB_APP_NAME = ProductConstants.WEB_APP_NAME.substring(1);
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGet(httpServletRequest, httpServletResponse);
    }

    public static void saveRequestContext(HttpServletRequest httpServletRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(httpServletRequest.getScheme());
        stringBuffer.append("://");
        stringBuffer.append(httpServletRequest.getServerName());
        stringBuffer.append(':');
        stringBuffer.append(httpServletRequest.getServerPort());
        ThreadLocalUtils.clear();
        Calculator.setThreadSavedParameter("remoteServletURL", BaseServlet.getServletURL(httpServletRequest));
        Calculator.setThreadSavedParameter("servletURL", WebUtils.createServletURL(httpServletRequest));
        Calculator.setThreadSavedParameter("session_heart_beat", Boolean.toString(ConfigManager.getProviderInstance().isSendHeartBeat()));
        Calculator.setThreadSavedParameter("serverURL", stringBuffer);
        Calculator.setThreadSavedParameter("serverSchema", httpServletRequest.getScheme());
        Calculator.setThreadSavedParameter("serverName", httpServletRequest.getServerName());
        Calculator.setThreadSavedParameter("serverPort", Integer.toString(httpServletRequest.getServerPort()));
        Calculator.setThreadSavedParameter("contextPath", httpServletRequest.getContextPath());
        String string = WebUtils.getReportTitleFromRequest(httpServletRequest);
        reportName = string == null ? reportName : string;
        Calculator.setThreadSavedParameter("reportName", reportName);
    }

    private static String getServletURL(HttpServletRequest httpServletRequest) {
        String string = WebUtils.createServletURL(httpServletRequest);
        boolean bl = ConfigManager.getProviderInstance().isUseResServer();
        if (bl) {
            return ConfigManager.getProviderInstance().getResServerPath();
        }
        return string;
    }

    public long getLastModified(HttpServletRequest httpServletRequest) {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "resource");
        if (string != null) {
            return oD._().M(string);
        }
        String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "op");
        if ("toolbar_icon".equalsIgnoreCase(string2)) {
            return IconManager.getLastModified();
        }
        return -1L;
    }

    public String buildPropertiesPath() {
        return "/com/fr/stable/build.properties";
    }
}

