/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.collections.map;

import com.fr.stable.collections.array.FloatArray;
import com.fr.stable.collections.array.IntArray;
import com.fr.stable.collections.utils.GdxRuntimeException;
import com.fr.stable.collections.utils.MathUtils;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntFloatMap
implements Iterable<Entry> {
    private static final int PRIME1 = -1105259343;
    private static final int PRIME2 = -1262997959;
    private static final int PRIME3 = -825114047;
    private static final int EMPTY = 0;
    public int size;
    int[] keyTable;
    float[] valueTable;
    int capacity;
    int stashSize;
    float zeroValue;
    boolean hasZeroValue;
    private float loadFactor;
    private int hashShift;
    private int mask;
    private int threshold;
    private int stashCapacity;
    private int pushIterations;
    private Entries entries1;
    private Entries entries2;
    private Values values1;
    private Values values2;
    private Keys keys1;
    private Keys keys2;

    public IntFloatMap() {
        this(51, 0.8f);
    }

    public IntFloatMap(int n) {
        this(n, 0.8f);
    }

    public IntFloatMap(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("initialCapacity must be >= 0: " + n);
        }
        if ((n = MathUtils.nextPowerOfTwo((int)Math.ceil((float)n / f))) > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large: " + n);
        }
        this.capacity = n;
        if (f <= 0.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0: " + f);
        }
        this.loadFactor = f;
        this.threshold = (int)((float)this.capacity * f);
        this.mask = this.capacity - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(this.capacity);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(this.capacity)) * 2);
        this.pushIterations = Math.max(Math.min(this.capacity, 8), (int)Math.sqrt(this.capacity) / 8);
        this.keyTable = new int[this.capacity + this.stashCapacity];
        this.valueTable = new float[this.keyTable.length];
    }

    public IntFloatMap(IntFloatMap intFloatMap) {
        this((int)Math.floor((float)intFloatMap.capacity * intFloatMap.loadFactor), intFloatMap.loadFactor);
        this.stashSize = intFloatMap.stashSize;
        System.arraycopy(intFloatMap.keyTable, 0, this.keyTable, 0, intFloatMap.keyTable.length);
        System.arraycopy(intFloatMap.valueTable, 0, this.valueTable, 0, intFloatMap.valueTable.length);
        this.size = intFloatMap.size;
        this.zeroValue = intFloatMap.zeroValue;
        this.hasZeroValue = intFloatMap.hasZeroValue;
    }

    public void put(int n, float f) {
        int n2;
        if (n == 0) {
            this.zeroValue = f;
            if (!this.hasZeroValue) {
                this.hasZeroValue = true;
                ++this.size;
            }
            return;
        }
        int[] nArray = this.keyTable;
        int n3 = n & this.mask;
        int n4 = nArray[n3];
        if (n == n4) {
            this.valueTable[n3] = f;
            return;
        }
        int n5 = this.hash2(n);
        int n6 = nArray[n5];
        if (n == n6) {
            this.valueTable[n5] = f;
            return;
        }
        int n7 = this.hash3(n);
        int n8 = nArray[n7];
        if (n == n8) {
            this.valueTable[n7] = f;
            return;
        }
        int n9 = n2 + this.stashSize;
        for (n2 = this.capacity; n2 < n9; ++n2) {
            if (n != nArray[n2]) continue;
            this.valueTable[n2] = f;
            return;
        }
        if (n4 == 0) {
            nArray[n3] = n;
            this.valueTable[n3] = f;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        if (n6 == 0) {
            nArray[n5] = n;
            this.valueTable[n5] = f;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        if (n8 == 0) {
            nArray[n7] = n;
            this.valueTable[n7] = f;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(n, f, n3, n4, n5, n6, n7, n8);
    }

    public void putAll(IntFloatMap intFloatMap) {
        for (Entry entry : intFloatMap.entries()) {
            this.put(entry.key, entry.value);
        }
    }

    private void putResize(int n, float f) {
        if (n == 0) {
            this.zeroValue = f;
            this.hasZeroValue = true;
            return;
        }
        int n2 = n & this.mask;
        int n3 = this.keyTable[n2];
        if (n3 == 0) {
            this.keyTable[n2] = n;
            this.valueTable[n2] = f;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n4 = this.hash2(n);
        int n5 = this.keyTable[n4];
        if (n5 == 0) {
            this.keyTable[n4] = n;
            this.valueTable[n4] = f;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n6 = this.hash3(n);
        int n7 = this.keyTable[n6];
        if (n7 == 0) {
            this.keyTable[n6] = n;
            this.valueTable[n6] = f;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(n, f, n2, n3, n4, n5, n6, n7);
    }

    private void push(int n, float f, int n2, int n3, int n4, int n5, int n6, int n7) {
        float f2;
        int n8;
        int[] nArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n9 = this.mask;
        int n10 = 0;
        int n11 = this.pushIterations;
        while (true) {
            switch (MathUtils.random(2)) {
                case 0: {
                    n8 = n3;
                    f2 = fArray[n2];
                    nArray[n2] = n;
                    fArray[n2] = f;
                    break;
                }
                case 1: {
                    n8 = n5;
                    f2 = fArray[n4];
                    nArray[n4] = n;
                    fArray[n4] = f;
                    break;
                }
                default: {
                    n8 = n7;
                    f2 = fArray[n6];
                    nArray[n6] = n;
                    fArray[n6] = f;
                }
            }
            n2 = n8 & n9;
            n3 = nArray[n2];
            if (n3 == 0) {
                nArray[n2] = n8;
                fArray[n2] = f2;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n4 = this.hash2(n8);
            n5 = nArray[n4];
            if (n5 == 0) {
                nArray[n4] = n8;
                fArray[n4] = f2;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n6 = this.hash3(n8);
            n7 = nArray[n6];
            if (n7 == 0) {
                nArray[n6] = n8;
                fArray[n6] = f2;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            if (++n10 == n11) break;
            n = n8;
            f = f2;
        }
        this.putStash(n8, f2);
    }

    private void putStash(int n, float f) {
        if (this.stashSize == this.stashCapacity) {
            this.resize(this.capacity << 1);
            this.put(n, f);
            return;
        }
        int n2 = this.capacity + this.stashSize;
        this.keyTable[n2] = n;
        this.valueTable[n2] = f;
        ++this.stashSize;
        ++this.size;
    }

    public float get(int n, float f) {
        if (n == 0) {
            if (!this.hasZeroValue) {
                return f;
            }
            return this.zeroValue;
        }
        int n2 = n & this.mask;
        if (this.keyTable[n2] != n && this.keyTable[n2 = this.hash2(n)] != n && this.keyTable[n2 = this.hash3(n)] != n) {
            return this.getStash(n, f);
        }
        return this.valueTable[n2];
    }

    private float getStash(int n, float f) {
        int n2;
        int[] nArray = this.keyTable;
        int n3 = n2 + this.stashSize;
        for (n2 = this.capacity; n2 < n3; ++n2) {
            if (n != nArray[n2]) continue;
            return this.valueTable[n2];
        }
        return f;
    }

    public float getAndIncrement(int n, float f, float f2) {
        if (n == 0) {
            if (this.hasZeroValue) {
                float f3 = this.zeroValue;
                this.zeroValue += f2;
                return f3;
            }
            this.hasZeroValue = true;
            this.zeroValue = f + f2;
            ++this.size;
            return f;
        }
        int n2 = n & this.mask;
        if (n != this.keyTable[n2] && n != this.keyTable[n2 = this.hash2(n)] && n != this.keyTable[n2 = this.hash3(n)]) {
            return this.getAndIncrementStash(n, f, f2);
        }
        float f4 = this.valueTable[n2];
        this.valueTable[n2] = f4 + f2;
        return f4;
    }

    private float getAndIncrementStash(int n, float f, float f2) {
        int n2;
        int[] nArray = this.keyTable;
        int n3 = n2 + this.stashSize;
        for (n2 = this.capacity; n2 < n3; ++n2) {
            if (n != nArray[n2]) continue;
            float f3 = this.valueTable[n2];
            this.valueTable[n2] = f3 + f2;
            return f3;
        }
        this.put(n, f + f2);
        return f;
    }

    public float remove(int n, float f) {
        if (n == 0) {
            if (!this.hasZeroValue) {
                return f;
            }
            this.hasZeroValue = false;
            --this.size;
            return this.zeroValue;
        }
        int n2 = n & this.mask;
        if (n == this.keyTable[n2]) {
            this.keyTable[n2] = 0;
            float f2 = this.valueTable[n2];
            --this.size;
            return f2;
        }
        n2 = this.hash2(n);
        if (n == this.keyTable[n2]) {
            this.keyTable[n2] = 0;
            float f3 = this.valueTable[n2];
            --this.size;
            return f3;
        }
        n2 = this.hash3(n);
        if (n == this.keyTable[n2]) {
            this.keyTable[n2] = 0;
            float f4 = this.valueTable[n2];
            --this.size;
            return f4;
        }
        return this.removeStash(n, f);
    }

    float removeStash(int n, float f) {
        int n2;
        int[] nArray = this.keyTable;
        int n3 = n2 + this.stashSize;
        for (n2 = this.capacity; n2 < n3; ++n2) {
            if (n != nArray[n2]) continue;
            float f2 = this.valueTable[n2];
            this.removeStashIndex(n2);
            --this.size;
            return f2;
        }
        return f;
    }

    void removeStashIndex(int n) {
        --this.stashSize;
        int n2 = this.capacity + this.stashSize;
        if (n < n2) {
            this.keyTable[n] = this.keyTable[n2];
            this.valueTable[n] = this.valueTable[n2];
        }
    }

    public void shrink(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: " + n);
        }
        if (this.size > n) {
            n = this.size;
        }
        if (this.capacity <= n) {
            return;
        }
        n = MathUtils.nextPowerOfTwo(n);
        this.resize(n);
    }

    public void clear(int n) {
        if (this.capacity <= n) {
            this.clear();
            return;
        }
        this.hasZeroValue = false;
        this.size = 0;
        this.resize(n);
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        int[] nArray = this.keyTable;
        int n = this.capacity + this.stashSize;
        while (n-- > 0) {
            nArray[n] = 0;
        }
        this.hasZeroValue = false;
        this.size = 0;
        this.stashSize = 0;
    }

    public boolean containsValue(float f) {
        if (this.hasZeroValue && this.zeroValue == f) {
            return true;
        }
        int[] nArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n = this.capacity + this.stashSize;
        while (n-- > 0) {
            if (nArray[n] == 0 || fArray[n] != f) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(float f, float f2) {
        if (this.hasZeroValue && Math.abs(this.zeroValue - f) <= f2) {
            return true;
        }
        float[] fArray = this.valueTable;
        int n = this.capacity + this.stashSize;
        while (n-- > 0) {
            if (!(Math.abs(fArray[n] - f) <= f2)) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(int n) {
        if (n == 0) {
            return this.hasZeroValue;
        }
        int n2 = n & this.mask;
        if (this.keyTable[n2] != n && this.keyTable[n2 = this.hash2(n)] != n && this.keyTable[n2 = this.hash3(n)] != n) {
            return this.containsKeyStash(n);
        }
        return true;
    }

    private boolean containsKeyStash(int n) {
        int n2;
        int[] nArray = this.keyTable;
        int n3 = n2 + this.stashSize;
        for (n2 = this.capacity; n2 < n3; ++n2) {
            if (n != nArray[n2]) continue;
            return true;
        }
        return false;
    }

    public int findKey(float f, int n) {
        if (this.hasZeroValue && this.zeroValue == f) {
            return 0;
        }
        int[] nArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n2 = this.capacity + this.stashSize;
        while (n2-- > 0) {
            if (nArray[n2] == 0 || fArray[n2] != f) continue;
            return nArray[n2];
        }
        return n;
    }

    public void ensureCapacity(int n) {
        int n2 = this.size + n;
        if (n2 >= this.threshold) {
            this.resize(MathUtils.nextPowerOfTwo((int)Math.ceil((float)n2 / this.loadFactor)));
        }
    }

    private void resize(int n) {
        int n2 = this.capacity + this.stashSize;
        this.capacity = n;
        this.threshold = (int)((float)n * this.loadFactor);
        this.mask = n - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(n);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(n)) * 2);
        this.pushIterations = Math.max(Math.min(n, 8), (int)Math.sqrt(n) / 8);
        int[] nArray = this.keyTable;
        float[] fArray = this.valueTable;
        this.keyTable = new int[n + this.stashCapacity];
        this.valueTable = new float[n + this.stashCapacity];
        int n3 = this.size;
        this.size = this.hasZeroValue ? 1 : 0;
        this.stashSize = 0;
        if (n3 > 0) {
            for (int i = 0; i < n2; ++i) {
                int n4 = nArray[i];
                if (n4 == 0) continue;
                this.putResize(n4, fArray[i]);
            }
        }
    }

    private int hash2(int n) {
        return ((n *= -1262997959) ^ n >>> this.hashShift) & this.mask;
    }

    private int hash3(int n) {
        return ((n *= -825114047) ^ n >>> this.hashShift) & this.mask;
    }

    public int hashCode() {
        int n = 0;
        if (this.hasZeroValue) {
            n += Float.floatToIntBits(this.zeroValue);
        }
        int[] nArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n2 = this.capacity + this.stashSize;
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[i];
            if (n3 == 0) continue;
            n += n3 * 31;
            float f = fArray[i];
            n += Float.floatToIntBits(f);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntFloatMap)) {
            return false;
        }
        IntFloatMap intFloatMap = (IntFloatMap)object;
        if (intFloatMap.size != this.size) {
            return false;
        }
        if (intFloatMap.hasZeroValue != this.hasZeroValue) {
            return false;
        }
        if (this.hasZeroValue && intFloatMap.zeroValue != this.zeroValue) {
            return false;
        }
        int[] nArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n = this.capacity + this.stashSize;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            if (n2 == 0) continue;
            float f = intFloatMap.get(n2, 0.0f);
            if (f == 0.0f && !intFloatMap.containsKey(n2)) {
                return false;
            }
            float f2 = fArray[i];
            if (f == f2) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        int n;
        if (this.size == 0) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('{');
        int[] nArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n2 = nArray.length;
        if (this.hasZeroValue) {
            stringBuilder.append("0=");
            stringBuilder.append(this.zeroValue);
        } else {
            while (n2-- > 0) {
                n = nArray[n2];
                if (n == 0) continue;
                stringBuilder.append(n);
                stringBuilder.append('=');
                stringBuilder.append(fArray[n2]);
                break;
            }
        }
        while (n2-- > 0) {
            n = nArray[n2];
            if (n == 0) continue;
            stringBuilder.append(", ");
            stringBuilder.append(n);
            stringBuilder.append('=');
            stringBuilder.append(fArray[n2]);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.entries();
    }

    public Entries entries() {
        if (this.entries1 == null) {
            this.entries1 = new Entries(this);
            this.entries2 = new Entries(this);
        }
        if (!this.entries1.valid) {
            this.entries1.reset();
            this.entries1.valid = true;
            this.entries2.valid = false;
            return this.entries1;
        }
        this.entries2.reset();
        this.entries2.valid = true;
        this.entries1.valid = false;
        return this.entries2;
    }

    public Values values() {
        if (this.values1 == null) {
            this.values1 = new Values(this);
            this.values2 = new Values(this);
        }
        if (!this.values1.valid) {
            this.values1.reset();
            this.values1.valid = true;
            this.values2.valid = false;
            return this.values1;
        }
        this.values2.reset();
        this.values2.valid = true;
        this.values1.valid = false;
        return this.values2;
    }

    public Keys keys() {
        if (this.keys1 == null) {
            this.keys1 = new Keys(this);
            this.keys2 = new Keys(this);
        }
        if (!this.keys1.valid) {
            this.keys1.reset();
            this.keys1.valid = true;
            this.keys2.valid = false;
            return this.keys1;
        }
        this.keys2.reset();
        this.keys2.valid = true;
        this.keys1.valid = false;
        return this.keys2;
    }

    public static class Keys
    extends MapIterator {
        public Keys(IntFloatMap intFloatMap) {
            super(intFloatMap);
        }

        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        public int next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            int n = this.nextIndex == -1 ? 0 : this.map.keyTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return n;
        }

        public IntArray toArray() {
            IntArray intArray = new IntArray(true, this.map.size);
            while (this.hasNext) {
                intArray.add(this.next());
            }
            return intArray;
        }
    }

    public static class Values
    extends MapIterator {
        public Values(IntFloatMap intFloatMap) {
            super(intFloatMap);
        }

        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        public float next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            float f = this.nextIndex == -1 ? this.map.zeroValue : this.map.valueTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return f;
        }

        public FloatArray toArray() {
            FloatArray floatArray = new FloatArray(true, this.map.size);
            while (this.hasNext) {
                floatArray.add(this.next());
            }
            return floatArray;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entries
    extends MapIterator
    implements Iterable<Entry>,
    Iterator<Entry> {
        private Entry entry = new Entry();

        public Entries(IntFloatMap intFloatMap) {
            super(intFloatMap);
        }

        @Override
        public Entry next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            int[] nArray = this.map.keyTable;
            if (this.nextIndex == -1) {
                this.entry.key = 0;
                this.entry.value = this.map.zeroValue;
            } else {
                this.entry.key = nArray[this.nextIndex];
                this.entry.value = this.map.valueTable[this.nextIndex];
            }
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return this.entry;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        public Iterator<Entry> iterator() {
            return this;
        }

        @Override
        public void remove() {
            super.remove();
        }
    }

    private static class MapIterator {
        static final int INDEX_ILLEGAL = -2;
        static final int INDEX_ZERO = -1;
        public boolean hasNext;
        final IntFloatMap map;
        int nextIndex;
        int currentIndex;
        boolean valid = true;

        public MapIterator(IntFloatMap intFloatMap) {
            this.map = intFloatMap;
            this.reset();
        }

        public void reset() {
            this.currentIndex = -2;
            this.nextIndex = -1;
            if (this.map.hasZeroValue) {
                this.hasNext = true;
            } else {
                this.findNextIndex();
            }
        }

        void findNextIndex() {
            this.hasNext = false;
            int[] nArray = this.map.keyTable;
            int n = this.map.capacity + this.map.stashSize;
            while (++this.nextIndex < n) {
                if (nArray[this.nextIndex] == 0) continue;
                this.hasNext = true;
                break;
            }
        }

        public void remove() {
            if (this.currentIndex == -1 && this.map.hasZeroValue) {
                this.map.hasZeroValue = false;
            } else {
                if (this.currentIndex < 0) {
                    throw new IllegalStateException("next must be called before remove.");
                }
                if (this.currentIndex >= this.map.capacity) {
                    this.map.removeStashIndex(this.currentIndex);
                    this.nextIndex = this.currentIndex - 1;
                    this.findNextIndex();
                } else {
                    this.map.keyTable[this.currentIndex] = 0;
                }
            }
            this.currentIndex = -2;
            --this.map.size;
        }
    }

    public static class Entry {
        public int key;
        public float value;

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

