/*
 * Decompiled with CFR 0.152.
 */
package com.fr.js;

import com.fr.base.FRContext;
import com.fr.base.Parameter;
import com.fr.base.TemplateUtils;
import com.fr.general.ComparatorUtils;
import com.fr.js.Hyperlink;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.CodeUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public class WebHyperlink
extends Hyperlink {
    private String url = "";
    private boolean useCJK = true;
    private boolean extendParameters = false;

    public WebHyperlink() {
    }

    public WebHyperlink(String string) {
        this(string, "");
    }

    public WebHyperlink(String string, String string2) {
        this.setURL(string);
        this.setTargetFrame(string2);
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String string) {
        this.url = string;
    }

    public boolean isUseCJK() {
        return this.useCJK;
    }

    public void setUseCJK(boolean bl) {
        this.useCJK = bl;
    }

    public void setExtendParameters(boolean bl) {
        this.extendParameters = bl;
    }

    public boolean isExtendParameters() {
        return this.extendParameters;
    }

    public String actionJS(Repository repository) {
        try {
            return this.createWebPath(repository);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
            return "";
        }
    }

    public JSONObject createJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.createJSONObject(repository);
        try {
            jSONObject.put("url", this.createPrefixURL(repository));
            jSONObject.put("useCJK", this.useCJK);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
        }
        return jSONObject;
    }

    public String getHyperlinkType() {
        return "web";
    }

    private String createWebPath(Repository repository) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("FR.doHyperlinkByGet(");
        JSONObject jSONObject = JSONObject.create();
        jSONObject.put("url", this.createPrefixURL(repository));
        jSONObject.put("para", this.createPara(repository));
        jSONObject.put("target", this.getTargetFrame());
        jSONObject.put("feature", this.features4NewWindow());
        jSONObject.put("title", this.getTitle());
        stringBuilder.append(jSONObject.toString());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public String createPrefixURL(Repository repository) throws Exception {
        String string = TemplateUtils.render(this.getURL());
        return CodeUtils.encodeURIComponent(CodeUtils.cjkEncode(string));
    }

    protected JSONObject createPara(Repository repository) throws JSONException {
        JSONObject jSONObject = JSONObject.create();
        for (int i = 0; i < this.parameters.length; ++i) {
            Parameter parameter = (Parameter)this.parameters[i];
            Object object = parameter.getValue();
            if (object == null) continue;
            jSONObject.put(this.useCJK ? CodeUtils.cjkEncode(parameter.getName()) : parameter.getName(), this.useCJK ? CodeUtils.cjkEncode(parameter.valueToString()) : parameter.valueToString());
        }
        if (this.isExtendParameters()) {
            this.putExtendParameters(repository, jSONObject, this.useCJK);
        }
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("URL")) {
                String string2 = null;
                string2 = xMLableReader.getElementValue();
                if (StringUtils.isNotBlank(string2)) {
                    this.setURL(string2);
                }
            } else if (string.equals("CJK")) {
                String string3 = null;
                string3 = xMLableReader.getElementValue();
                if (StringUtils.isNotBlank(string3)) {
                    this.setUseCJK(Boolean.valueOf(string3));
                }
            } else if (string.equals("extendParameters")) {
                String string4 = null;
                string4 = xMLableReader.getElementValue();
                if (StringUtils.isNotBlank(string4)) {
                    this.setExtendParameters(Boolean.valueOf(string4));
                }
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("JavaScript").attr("class", this.getClass().getName());
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("URL").textNode(this.getURL()).end();
        if (!this.isUseCJK()) {
            xMLPrintWriter.startTAG("CJK").textNode(String.valueOf(this.isUseCJK())).end();
        }
        if (this.isExtendParameters()) {
            xMLPrintWriter.startTAG("extendParameters").textNode(String.valueOf(this.isExtendParameters())).end();
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof WebHyperlink)) {
            return false;
        }
        return super.equals(object) && this.useCJK == ((WebHyperlink)object).useCJK && ComparatorUtils.equals(this.url, ((WebHyperlink)object).url) && this.extendParameters == ((WebHyperlink)object).extendParameters;
    }

    protected boolean isPost() {
        return false;
    }
}

