/*
 * Decompiled with CFR 0.152.
 */
package com.fr.general.jsqlparser.util.deparser;

import com.fr.general.jsqlparser.expression.Expression;
import com.fr.general.jsqlparser.expression.ExpressionVisitor;
import com.fr.general.jsqlparser.expression.operators.relational.ExpressionList;
import com.fr.general.jsqlparser.expression.operators.relational.ItemsListVisitor;
import com.fr.general.jsqlparser.schema.Column;
import com.fr.general.jsqlparser.statement.replace.Replace;
import com.fr.general.jsqlparser.statement.select.SelectVisitor;
import com.fr.general.jsqlparser.statement.select.SubSelect;
import java.util.Iterator;

public class ReplaceDeParser
implements ItemsListVisitor {
    protected StringBuffer buffer;
    protected ExpressionVisitor expressionVisitor;
    protected SelectVisitor selectVisitor;

    public ReplaceDeParser() {
    }

    public ReplaceDeParser(ExpressionVisitor expressionVisitor, SelectVisitor selectVisitor, StringBuffer stringBuffer) {
        this.buffer = stringBuffer;
        this.expressionVisitor = expressionVisitor;
        this.selectVisitor = selectVisitor;
    }

    public StringBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuffer stringBuffer) {
        this.buffer = stringBuffer;
    }

    public void deParse(Replace replace) {
        this.buffer.append("REPLACE " + replace.getTable().getWholeTableName());
        if (replace.getItemsList() != null) {
            if (replace.getColumns() != null) {
                this.buffer.append(" (");
                for (int i = 0; i < replace.getColumns().size(); ++i) {
                    Column column = (Column)replace.getColumns().get(i);
                    this.buffer.append(column.getWholeColumnName());
                    if (i >= replace.getColumns().size() - 1) continue;
                    this.buffer.append(", ");
                }
                this.buffer.append(") ");
            } else {
                this.buffer.append(" ");
            }
        } else {
            this.buffer.append(" SET ");
            for (int i = 0; i < replace.getColumns().size(); ++i) {
                Column column = (Column)replace.getColumns().get(i);
                this.buffer.append(column.getWholeColumnName() + "=");
                Expression expression = (Expression)replace.getExpressions().get(i);
                expression.accept(this.expressionVisitor);
                if (i >= replace.getColumns().size() - 1) continue;
                this.buffer.append(", ");
            }
        }
    }

    public void visit(ExpressionList expressionList) {
        this.buffer.append(" VALUES (");
        Iterator iterator = expressionList.getExpressions().iterator();
        while (iterator.hasNext()) {
            Expression expression = (Expression)iterator.next();
            expression.accept(this.expressionVisitor);
            if (!iterator.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append(")");
    }

    public void visit(SubSelect subSelect) {
        subSelect.getSelectBody().accept(this.selectVisitor);
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public SelectVisitor getSelectVisitor() {
        return this.selectVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor expressionVisitor) {
        this.expressionVisitor = expressionVisitor;
    }

    public void setSelectVisitor(SelectVisitor selectVisitor) {
        this.selectVisitor = selectVisitor;
    }
}

