/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.form.event.Listener;
import com.fr.form.event.Observer;
import com.fr.form.ui.Button;
import com.fr.form.ui.WidgetXmlUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONFunction;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public class MenuButton
extends Button {
    protected Button[] menuItems;

    public MenuButton(String string, String string2) {
        super(string, string2);
    }

    public String getXType() {
        return "menubutton";
    }

    public Button[] getMenuItems() {
        return this.menuItems;
    }

    public void setMenuItems(Button[] buttonArray) {
        this.menuItems = buttonArray;
    }

    public Button[] createMenuItems() {
        return this.getMenuItems();
    }

    public JSONArray itemsJO(Repository repository) throws JSONException {
        Object[] objectArray = this.createMenuItems();
        JSONArray jSONArray = new JSONArray();
        if (!ArrayUtils.isEmpty(objectArray)) {
            block0: for (int i = 0; i < objectArray.length; ++i) {
                JSONObject jSONObject = ((Button)objectArray[i]).createChildConfig(repository);
                jSONArray.put(jSONObject);
                Listener[] listenerArray = ((Observer)objectArray[i]).createListeners(repository);
                for (int j = 0; j < listenerArray.length; ++j) {
                    if (!ComparatorUtils.equals("click", listenerArray[j].getEventName())) continue;
                    jSONObject.put("handler", new JSONFunction(new String[]{"e", "item"}, listenerArray[j].getAction().createJS(repository), repository.getDevice()));
                    continue block0;
                }
            }
        }
        return jSONArray;
    }

    public JSONObject createJSONConfig(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        this.setEnabled(true);
        JSONObject jSONObject = super.createJSONConfig(repository, calculator, nodeVisitor);
        jSONObject.put("menu", this.itemsJO(repository));
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("Widget")) {
            ArrayUtils.add(this.menuItems, WidgetXmlUtils.readButton(xMLableReader));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        for (int i = 0; this.menuItems != null && i < this.menuItems.length; ++i) {
            GeneralXMLTools.writeXMLable(xMLPrintWriter, this.menuItems[i], "Widget");
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof MenuButton)) {
            return false;
        }
        return super.equals(object) && ComparatorUtils.equals(this.menuItems, ((MenuButton)object).menuItems);
    }

    public Object clone() throws CloneNotSupportedException {
        MenuButton menuButton = (MenuButton)super.clone();
        if (this.menuItems != null) {
            menuButton.menuItems = new Button[this.menuItems.length];
            for (int i = 0; i < this.menuItems.length; ++i) {
                menuButton.menuItems[i] = (MenuButton)this.menuItems[i].clone();
            }
        }
        return menuButton;
    }
}

