/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.index;

import com.fr.data.index.Entry;
import com.fr.data.index.EntryComparator;
import com.fr.data.index.SQLTypeComparator;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.general.data.index.Index;
import com.fr.general.data.index.IndexException;
import java.util.Comparator;

public abstract class AbstractIndex
implements Index {
    protected EntryComparator entryComparator = new EntryComparator();
    protected DataModel dataModel;
    protected int column;
    protected boolean isBuild;
    protected Entry[] indexes;

    public AbstractIndex() {
    }

    public AbstractIndex(DataModel dataModel, int n) {
        this.setDataModel(dataModel, n);
    }

    protected void setDataModel(DataModel dataModel, int n) {
        this.dataModel = dataModel;
        this.column = n;
    }

    protected void extractIndex() throws TableDataException {
        this.indexes = new Entry[this.dataModel.getRowCount()];
        for (int i = 0; i < this.indexes.length; ++i) {
            Entry entry;
            this.indexes[i] = entry = new Entry(this.dataModel.getValueAt(i, this.column), i);
        }
    }

    protected abstract int search(Object var1);

    protected abstract int[] searchAll(Object var1);

    protected abstract void buildIndex() throws IndexException;

    public int getRow(Object object) throws IndexException {
        this.build();
        return this.search(object);
    }

    public void build() throws IndexException {
        if (!this.isBuild) {
            if (!this.entryComparator.hasComparator()) {
                this.entryComparator.setComparator(new SQLTypeComparator());
            }
            this.buildIndex();
            this.isBuild = true;
        }
    }

    public int[] getAllRow(Object object) throws IndexException {
        this.build();
        return this.searchAll(object);
    }

    public void setComparator(Comparator comparator) {
        this.entryComparator.setComparator(comparator);
    }
}

