/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.dml;

import com.fr.base.TemplateUtils;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dml.AbstractDML;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.dml.Where;
import com.fr.general.FRLogger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class Delete
extends AbstractDML {
    private Where where;

    public Delete(Table table) {
        this(table, DialectFactory.getDefaultDialect());
    }

    public Delete(Table table, Dialect dialect) {
        this(table, null, dialect);
    }

    public Delete(Table table, Where where, Dialect dialect) {
        super(table, dialect);
        this.setWhere(where);
    }

    public void setWhere(Where where) {
        this.where = where;
    }

    public PreparedStatement createPreparedStatementByValidatedParameters(Connection connection) throws SQLException {
        String string = TemplateUtils.render("DELETE FROM ${table} ${where}", new String[]{"table", "where"}, new String[]{this.getTable().toStatementSQLString(this.dialect), this.where == null ? "" : this.where.toStatementSQLString(this.dialect)});
        FRLogger.getLogger().info(string.toString());
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        if (this.where != null) {
            this.where.applyColumnTypeValue(this.dialect, connection, this.getTable(), preparedStatement, 1);
        }
        return preparedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(Connection connection) throws SQLException {
        PreparedStatement preparedStatement = this.createPreparedStatement(connection);
        try {
            if (preparedStatement != null) {
                int n = preparedStatement.executeUpdate();
                return n;
            }
        }
        finally {
            DBUtils.closeStatement(preparedStatement);
        }
        return 0;
    }
}

