/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.dml;

import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.SybaseDialect;
import com.fr.data.core.db.dml.AbstractDML;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.tableObject.Column;
import com.fr.data.core.db.tableObject.ColumnSize;
import com.fr.data.dao.UniqueKey;
import com.fr.general.FRLogger;
import com.fr.stable.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class CreateTable
extends AbstractDML {
    private List columnsList = new ArrayList();
    private String checkFilter = null;
    private List uniqueKeyList = null;
    public static KeySqlGenerator PrimaryKeySqlGenerator = new KeySqlGenerator(){

        public String name() {
            return "PRIMARY KEY";
        }

        public boolean filter(Column column) {
            return column.isPrimaryKey();
        }

        public String extra(CreateTable createTable) {
            return "";
        }
    };

    public CreateTable(Table table, Dialect dialect) {
        super(table, dialect);
    }

    public void addColumn(Column column) {
        this.columnsList.add(column);
    }

    public void clearColumn() {
        this.columnsList.clear();
    }

    public Column getColumn(int n) {
        return (Column)this.columnsList.get(n);
    }

    public int getColumnSize() {
        return this.columnsList.size();
    }

    public void addUniqueKey(UniqueKey uniqueKey) {
        if (this.uniqueKeyList == null) {
            this.uniqueKeyList = new ArrayList();
        }
        this.uniqueKeyList.add(uniqueKey);
    }

    public void addColumn(String string, int n, int n2) {
        this.addColumn(string, n, n2, false, null, false, false);
    }

    public void addColumn(String string, int n, int n2, Boolean bl, String string2, Boolean bl2) {
        this.addColumn(string, n, n2, bl, string2, bl2, false);
    }

    public void addColumn(String string, int n, int n2, Boolean bl, Object object, Boolean bl2, Boolean bl3) {
        Column column = new Column();
        column.setName(string);
        column.setValueType(n);
        column.setColumnSize(new ColumnSize(n2));
        column.setAllowNull(bl == false);
        column.setDefaultValue(object);
        column.setPrimaryKey(bl3);
        column.setSelfIncrease(bl2);
        this.addColumn(column);
    }

    public PreparedStatement createPreparedStatementByValidatedParameters(Connection connection) throws SQLException {
        String string = this.toStatementSQLString(this.dialect, connection);
        FRLogger.getLogger().info(string);
        return connection.prepareStatement(string);
    }

    public String toStatementSQLString(Dialect dialect, Connection connection) {
        String string;
        if (this.getTable() == null) {
            return null;
        }
        if (this.columnsList.isEmpty()) {
            return null;
        }
        String string2 = this.getTable().toStatementSQLString(dialect);
        StringBuilder stringBuilder = new StringBuilder("CREATE TABLE ");
        stringBuilder.append(string2).append('(');
        int n = this.columnsList.size();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.getColumn(i).toSQL(dialect, connection, string2));
            if (i >= n - 1) continue;
            stringBuilder.append(',');
        }
        if (!(dialect instanceof SybaseDialect) && StringUtils.isNotBlank(string = this.createKeySQL(PrimaryKeySqlGenerator))) {
            stringBuilder.append(',').append(string);
        }
        if (this.uniqueKeyList != null) {
            if (dialect.supportsUniqueConstraintInCreateAlterTable()) {
                for (UniqueKey uniqueKey : this.uniqueKeyList) {
                    String string3 = uniqueKey.sqlConstraintString(dialect);
                    if (string3 == null) continue;
                    stringBuilder.append(", ").append(string3);
                }
            } else {
                throw new RuntimeException("Can not create unique key!");
            }
        }
        stringBuilder.append(')');
        FRLogger.getLogger().info(stringBuilder.toString());
        return stringBuilder.toString();
    }

    private String createKeySQL(KeySqlGenerator keySqlGenerator) {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        int n = this.getColumnSize();
        for (int i = 0; i < n; ++i) {
            if (!keySqlGenerator.filter(this.getColumn(i))) continue;
            arrayList.add(this.getColumn(i));
        }
        if (arrayList.size() < 1) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(keySqlGenerator.name() + " (");
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            stringBuffer.append(this.dialect.column2SQL(((Column)arrayList.get(n)).getName()));
            if (n >= n2 - 1) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append(')');
        stringBuffer.append(keySqlGenerator.extra(this));
        return stringBuffer.toString();
    }

    public static interface KeySqlGenerator {
        public boolean filter(Column var1);

        public String name();

        public String extra(CreateTable var1);
    }
}

