/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.dialect;

import com.fr.base.StoreProcedureParameter;
import com.fr.data.core.DataCoreUtils;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.TableProcedure;
import com.fr.data.core.db.dialect.AbstractDialect;
import com.fr.data.core.db.dialect.TriggerAction;
import com.fr.data.core.db.dialect.TypeUtils;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.field.FieldMessage;
import com.fr.data.core.db.handler.DBTimestampTypeHandler;
import com.fr.data.core.db.handler.DialectSQLTypeHandlerFactory;
import com.fr.data.core.db.handler.SQLTypeHandlerFactory;
import com.fr.data.impl.Connection;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.GeneralContext;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import java.io.InputStream;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import oracle.jdbc.OracleCallableStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDialect
extends AbstractDialect {
    public static DialectSQLTypeHandlerFactory oracleDialectSQLTypeHandlerFactory = new DialectSQLTypeHandlerFactory();
    private static final int EXPRESSION_PADDING = 100;
    private static int MAXIMUMSIZE = 4000;
    private int oracleFetchSize = 1024;
    private String sequenceName = "";
    private String table = "";
    private String column = "";
    private static Properties sequenceProperties;
    private static boolean isInitSequenceProperties;

    public OracleDialect() {
        this.left_quote = "\"";
        this.right_quote = "\"";
    }

    @Override
    public int getFetchSize() {
        return this.oracleFetchSize;
    }

    @Override
    public String createSequence(java.sql.Connection connection, String string, String string2, String string3) {
        try {
            this.createOracleSequence(connection, string, string2);
        }
        catch (SQLException sQLException) {
            FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
        }
        return string3;
    }

    private void createOracleSequence(java.sql.Connection connection, String string, String string2) throws SQLException {
        String string3;
        this.sequenceName = string3 = (string.substring(1, string.length() - 1) + "_seq").toUpperCase();
        this.table = string;
        this.column = string2;
        Statement statement = connection.createStatement();
        try {
            statement.execute("drop sequence " + string3.toUpperCase());
            statement.close();
        }
        catch (Exception exception) {
            statement.close();
        }
        PreparedStatement preparedStatement = connection.prepareStatement("create sequence " + string3 + " start with 1 increment by 1 minvalue 0 maxvalue 999999999999 cycle nocache");
        preparedStatement.execute();
        preparedStatement.close();
    }

    public static String getOravleIncCURRValue(String string, String string2) {
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        return "SELECT MAX(\"" + string2 + "\") FROM \"" + string + "\"";
    }

    private static String getSequenceByTable(String string) {
        OracleDialect.initSequenceProperties();
        return sequenceProperties.getProperty(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initSequenceProperties() {
        if (isInitSequenceProperties) {
            return;
        }
        Class<OracleDialect> clazz = OracleDialect.class;
        synchronized (OracleDialect.class) {
            if (isInitSequenceProperties) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            sequenceProperties = new Properties();
            try {
                InputStream inputStream = GeneralContext.getEnvProvider().readBean("sequence.properties", "resources");
                if (inputStream != null) {
                    sequenceProperties.load(inputStream);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            isInitSequenceProperties = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @Override
    public String getIdentitySelectString(String string, String string2, int n) throws Exception {
        return OracleDialect.getOravleIncCURRValue(string, string2);
    }

    @Override
    public String column2SQL4WhereSQL(String string, int n) {
        if (n == 1) {
            return "trim(" + this.column2SQL(string) + ")";
        }
        return this.column2SQL(string);
    }

    public void createTrigger(java.sql.Connection connection) {
        if (StringUtils.isBlank(this.sequenceName)) {
            return;
        }
        String string = this.table.substring(1, this.table.length() - 1) + "Tg";
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = this.column;
        stringBuffer.append("create or replace trigger ").append(string).append(" before insert on ").append(this.table).append(" for each row begin select ").append(this.sequenceName).append(".nextval into :new.").append(string2).append(" from dual; end;");
        this.executeTrigger(connection, stringBuffer);
    }

    private void executeTrigger(java.sql.Connection connection, StringBuffer stringBuffer) {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.execute(stringBuffer.toString());
            statement.close();
        }
        catch (SQLException sQLException) {
            FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
            try {
                statement.close();
            }
            catch (SQLException sQLException2) {
                FRLogger.getLogger().error(sQLException2.getMessage(), sQLException2);
            }
        }
    }

    @Override
    public String columnType2SQL(int n, String string) {
        int n2 = Integer.valueOf(string);
        String string2 = string;
        if (n2 > MAXIMUMSIZE) {
            string2 = "4000";
        }
        switch (n) {
            case 16: {
                return "NUMBER(1,0)";
            }
            case -5: {
                return "NUMBER";
            }
            case 4: {
                return "NUMBER";
            }
            case -6: {
                return "NUMBER";
            }
            case 5: {
                return "NUMBER";
            }
            case 3: {
                return "NUMBER";
            }
            case 8: {
                return "NUMBER";
            }
            case 6: {
                return "NUMBER";
            }
            case 2: {
                return "NUMBER";
            }
            case 7: {
                return "NUMBER";
            }
            case -3: {
                return "RAW(" + string + ")";
            }
            case -2: {
                return "RAW(" + string + ")";
            }
            case -4: {
                return "LONG RAW";
            }
            case -1: {
                return "LONG";
            }
            case 12: {
                return "VARCHAR2(" + string2 + ")";
            }
            case 1: {
                return "CHAR(" + string + ")";
            }
            case 1111: {
                return "NCLOB";
            }
            case -7: {
                return "VARCHAR2(1)";
            }
        }
        return TypeUtils.getTypeName(n);
    }

    public static String getOracleCurrentUserSchema(java.sql.Connection connection) {
        String string = "";
        String string2 = "select user from dual";
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                string = resultSet.getString("user");
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
        return string;
    }

    private String getOracleSQL(String string) {
        String string2 = "select owner,table_name from all_tables";
        if (StringUtils.isNotBlank(string)) {
            string2 = string2 + " where owner='" + string + "'";
        }
        return string2;
    }

    @Override
    public TableProcedure[] getTableProcedure(Connection connection, java.sql.Connection connection2, String string, boolean bl) throws Exception {
        boolean bl2;
        ArrayList<TableProcedure> arrayList = new ArrayList<TableProcedure>();
        String string2 = OracleDialect.getOracleCurrentUserSchema(connection2);
        boolean bl3 = bl2 = !bl && !ComparatorUtils.equals(string2, string);
        if (bl2) {
            return new TableProcedure[0];
        }
        String string3 = this.getOracleSQL(string);
        PreparedStatement preparedStatement = connection2.prepareStatement(string3);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            arrayList.add(new TableProcedure(resultSet.getString("owner"), this.processCharsetDB2Server(resultSet.getString("table_name"), connection), "TABLE", this));
        }
        resultSet.close();
        preparedStatement.close();
        return arrayList.toArray(new TableProcedure[arrayList.size()]);
    }

    @Override
    public TableProcedure[] getProcedureList(java.sql.Connection connection, ResultSet resultSet, String string, String string2) {
        String string3 = OracleDialect.getOracleCurrentUserSchema(connection);
        if (!ComparatorUtils.equals(string3, string2)) {
            return new TableProcedure[0];
        }
        return this.getUserStoreProcedure(connection, string2);
    }

    private TableProcedure[] getUserStoreProcedure(java.sql.Connection connection, String string) {
        ArrayList<TableProcedure> arrayList = new ArrayList<TableProcedure>();
        String string2 = "select distinct name, type from user_source where type in ('PACKAGE','PROCEDURE')";
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string3 = resultSet.getString("name");
                String string4 = resultSet.getString("type");
                if (ComparatorUtils.equals("PACKAGE", string4)) {
                    this.dealPackageStoreProcedure(arrayList, connection.getMetaData(), string, string3);
                    continue;
                }
                arrayList.add(new TableProcedure(string, string3, "PROCEDURE", this));
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            FRLogger.getLogger().errorWithServerLevel(sQLException.getMessage(), sQLException);
        }
        return arrayList.toArray(new TableProcedure[arrayList.size()]);
    }

    private void dealPackageStoreProcedure(List<TableProcedure> list, DatabaseMetaData databaseMetaData, String string, String string2) {
        ResultSet resultSet = null;
        try {
            resultSet = databaseMetaData.getProcedures(string2, string, "%");
            while (resultSet.next()) {
                String string3 = resultSet.getString(3);
                int n = string3.lastIndexOf(";");
                if (n > 0) {
                    string3 = string3.substring(0, n);
                }
                String string4 = resultSet.getString(1);
                string3 = string4 + "." + string3;
                list.add(new TableProcedure(resultSet.getString(2), string3, "PROCEDURE", this));
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            FRLogger.getLogger().errorWithServerLevel(sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public String getLimitString(String string, int n, int n2) {
        string = string.trim();
        boolean bl = false;
        String string2 = " for update";
        if (string.toLowerCase().endsWith(string2)) {
            string = string.substring(0, string.length() - string2.length());
            bl = true;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 100);
        stringBuffer.append("select * from ( select row_.*, rownum rownum_ from ( ");
        stringBuffer.append(string);
        stringBuffer.append(" ) row_ where rownum <= " + (n + n2) + ") where rownum_ > " + n);
        if (bl) {
            stringBuffer.append(" for update");
        }
        return stringBuffer.toString();
    }

    @Override
    public String quartzDelegateClass() {
        return "org.quartz.impl.jdbcjobstore.oracle.OracleDelegate";
    }

    @Override
    public String quartzDelegateKey() {
        return "org.quartz.jobStore.driverDelegateClass";
    }

    @Override
    public String defaultValidationQuery(java.sql.Connection connection) {
        return "select 1 from dual";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoreProcedureParameter[] getStoreProcedureDeclarationParameters(java.sql.Connection connection, String string, String string2) {
        StoreProcedureParameter[] storeProcedureParameterArray;
        ArrayList<StoreProcedureParameter> arrayList = new ArrayList<StoreProcedureParameter>();
        String string3 = this.getProcedureParametersSql(string);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            int n = 0;
            while (resultSet.next()) {
                ++n;
                storeProcedureParameterArray = resultSet.getString("argument_name");
                String string4 = resultSet.getString("Data_type");
                String string5 = resultSet.getString("in_out");
                String string6 = resultSet.getString("pls_type");
                string4 = string4 == null ? "" : string4;
                int n2 = string4.toUpperCase().indexOf("CURSOR") > -1 ? -10 : this.sql2ColumnTypeForProcedure(string6);
                StoreProcedureParameter storeProcedureParameter = string4.toUpperCase().indexOf("VARCHAR") != -1 && StringUtils.isNotEmpty(string2) ? new StoreProcedureParameter((String)(storeProcedureParameterArray == null ? "storeParameter" + n : storeProcedureParameterArray), string2, this.sql2ParameterType(string5), n2) : new StoreProcedureParameter((String)(storeProcedureParameterArray == null ? "storeParameter" + n : storeProcedureParameterArray), this.sql2ParameterType(string5), n2);
                arrayList.add(storeProcedureParameter);
            }
            storeProcedureParameterArray = arrayList.toArray(new StoreProcedureParameter[arrayList.size()]);
            Object var16_17 = null;
        }
        catch (SQLException sQLException) {
            StoreProcedureParameter[] storeProcedureParameterArray2;
            try {
                FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
                storeProcedureParameterArray2 = arrayList.toArray(new StoreProcedureParameter[arrayList.size()]);
                Object var16_18 = null;
            }
            catch (Throwable throwable) {
                Object var16_19 = null;
                DBUtils.closeResultSet(resultSet);
                DBUtils.closeStatement(statement);
                throw throwable;
            }
            DBUtils.closeResultSet(resultSet);
            DBUtils.closeStatement(statement);
            return storeProcedureParameterArray2;
        }
        DBUtils.closeResultSet(resultSet);
        DBUtils.closeStatement(statement);
        return storeProcedureParameterArray;
    }

    @Override
    public SQLTypeHandlerFactory buildSQLTypeHandlerFactory() {
        return oracleDialectSQLTypeHandlerFactory;
    }

    @Override
    public String getProcedureParametersSql(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length == 3) {
            String string2 = stringArray[1];
            String string3 = stringArray[2];
            return "select argument_name, Data_type, in_out, pls_type from sys.user_arguments WHERE OBJECT_NAME='" + string3 + "' and PACKAGE_NAME='" + string2 + "' order by position";
        }
        String string4 = stringArray[stringArray.length - 1];
        return "select argument_name, Data_type, in_out, pls_type from sys.user_arguments WHERE OBJECT_NAME='" + string4 + "' and PACKAGE_NAME is null order by position";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getTableCommentName(java.sql.Connection connection, String string, String string2, String string3) {
        ResultSet resultSet;
        Statement statement;
        block6: {
            String string4;
            statement = null;
            resultSet = null;
            try {
                try {
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery("select comments as table_comment from all_tab_comments" + OracleDialect.getDBLinkValue(string3) + " where table_name = '" + string + "' and owner = '" + string2 + "'");
                    if (!resultSet.next()) break block6;
                    string4 = resultSet.getString("table_comment");
                    Object var9_9 = null;
                }
                catch (SQLException sQLException) {
                    Object var9_11 = null;
                    DBUtils.closeResultSet(resultSet);
                    DBUtils.closeStatement(statement);
                    return "";
                }
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                DBUtils.closeResultSet(resultSet);
                DBUtils.closeStatement(statement);
                throw throwable;
            }
            DBUtils.closeResultSet(resultSet);
            DBUtils.closeStatement(statement);
            return string4;
        }
        Object var9_10 = null;
        DBUtils.closeResultSet(resultSet);
        DBUtils.closeStatement(statement);
        return "";
    }

    public static String getDBLinkValue(String string) {
        if (StringUtils.isBlank(string)) {
            return "";
        }
        return "@" + string;
    }

    private String getTableInfoString(String string, String string2, String string3) {
        Table table = new Table(string, string2);
        return "select * from " + this.table2SQL(table) + OracleDialect.getDBLinkValue(string3) + " where 1=2";
    }

    private static String getTablePrimayKeyString(String string, String string2, String string3) {
        return "select col.column_name from all_constraints" + OracleDialect.getDBLinkValue(string3) + " con, all_cons_columns" + OracleDialect.getDBLinkValue(string3) + " col where con.constraint_name = col.constraint_name  and col.owner = '" + string + "' and con.constraint_type='P' and col.table_name= '" + string2 + "'";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<FieldMessage> getDBLinkTableFieldsInfo(java.sql.Connection connection, String string, String string2, String string3) {
        ArrayList<FieldMessage> arrayList;
        Statement statement = null;
        ResultSet resultSet = null;
        ResultSet resultSet2 = null;
        try {
            statement = connection.createStatement();
            HashSet<String> hashSet = new HashSet<String>();
            resultSet = statement.executeQuery(OracleDialect.getTablePrimayKeyString(string2, string, string3));
            while (resultSet.next()) {
                hashSet.add(resultSet.getString("COLUMN_NAME"));
            }
            resultSet2 = statement.executeQuery(this.getTableInfoString(string2, string, string3));
            ResultSetMetaData resultSetMetaData = resultSet2.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            ArrayList<FieldMessage> arrayList2 = new ArrayList<FieldMessage>();
            for (int i = 0; i < n; ++i) {
                String string4 = resultSetMetaData.getColumnLabel(i + 1);
                FieldMessage fieldMessage = this.createFieldMessage();
                fieldMessage.setColumnName(string4);
                fieldMessage.setColumnType(resultSetMetaData.getColumnType(i + 1));
                fieldMessage.setColumnSize(resultSetMetaData.getColumnDisplaySize(i + 1));
                fieldMessage.setPrimaryKey(hashSet.contains(string4));
                arrayList2.add(fieldMessage);
                resultSetMetaData.getScale(i + 1);
            }
            arrayList = arrayList2;
            Object var16_17 = null;
        }
        catch (Exception exception) {
            try {
                FRLogger.getLogger().error(exception.getMessage(), exception);
                Object var16_18 = null;
            }
            catch (Throwable throwable) {
                Object var16_19 = null;
                DBUtils.closeResultSet(resultSet);
                DBUtils.closeResultSet(resultSet2);
                DBUtils.closeStatement(statement);
                throw throwable;
            }
            DBUtils.closeResultSet(resultSet);
            DBUtils.closeResultSet(resultSet2);
            DBUtils.closeStatement(statement);
            return null;
        }
        DBUtils.closeResultSet(resultSet);
        DBUtils.closeResultSet(resultSet2);
        DBUtils.closeStatement(statement);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<FieldMessage> getTableFieldsMessage(java.sql.Connection connection, String string, String string2, String string3) {
        List<FieldMessage> list = StringUtils.isBlank(string3) ? super.getTableFieldsMessage(connection, string, string2, string3) : this.getDBLinkTableFieldsInfo(connection, string, string2, string3);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            try {
                statement = connection.createStatement();
                resultSet = statement.executeQuery("select column_name, comments as column_comment from all_col_comments" + OracleDialect.getDBLinkValue(string3) + " where OWNER = '" + string2 + "' and table_name ='" + string + "'");
                HashMap<String, String> hashMap = new HashMap<String, String>();
                while (resultSet.next()) {
                    hashMap.put(resultSet.getString("COLUMN_NAME"), resultSet.getString("COLUMN_COMMENT"));
                }
                if (list != null) {
                    for (FieldMessage fieldMessage : list) {
                        String string4 = fieldMessage.getColumnName();
                        if (!hashMap.containsKey(string4)) continue;
                        fieldMessage.setColumnComment((String)hashMap.get(string4));
                    }
                }
                Object var13_13 = null;
            }
            catch (SQLException sQLException) {
                FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
                Object var13_14 = null;
                DBUtils.closeResultSet(resultSet);
                DBUtils.closeStatement(statement);
                return list;
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            DBUtils.closeResultSet(resultSet);
            DBUtils.closeStatement(statement);
            throw throwable;
        }
        DBUtils.closeResultSet(resultSet);
        DBUtils.closeStatement(statement);
        return list;
    }

    @Override
    protected String getProcedureSql(String string) {
        return "SELECT * FROM SYS.user_source WHERE NAME = '" + string + "' AND TYPE = 'PROCEDURE' ORDER BY NAME, LINE";
    }

    protected String getProcedureSql(String string, String string2) {
        return "SELECT * FROM SYS.user_source WHERE NAME = '" + string + "' AND TYPE = 'PACKAGE BODY' ORDER BY LINE";
    }

    @Override
    protected String getValueName() {
        return "TEXT";
    }

    @Override
    public ResultSet createLimitResultSet(Connection connection, java.sql.Connection connection2, Statement statement, String[] stringArray, String string, String string2, String string3, long l) throws SQLException {
        Table table = new Table(string, string2);
        String string4 = StringUtils.join(",", stringArray);
        String string5 = "select " + string4 + " from ( SELECT ROWNUM no, " + string4 + " FROM " + this.table2SQL(table) + OracleDialect.getDBLinkValue(string3) + " ) where no >" + l;
        statement.setFetchSize(2000);
        return statement.executeQuery(this.processCharset(string5, connection));
    }

    @Override
    public Statement createLimitUseStatement(java.sql.Connection connection) throws SQLException {
        return connection.createStatement(1003, 1007);
    }

    @Override
    public String createLimitSQL(String string, String[] stringArray, long l) {
        String string2 = StringUtils.join(",", stringArray);
        return "select " + string2 + " from (select ROWNUM no," + string2 + " from (" + string + ") t) where no >" + l;
    }

    @Override
    public String getSpecificRowSql(String string, int n) {
        return "select * from (select t.*, rownum rk from(" + string + ") t) where rk = " + n;
    }

    @Override
    public String getRowRangeSql(String string, int n, int n2, String[] stringArray) {
        String string2 = "select ";
        string2 = stringArray == null || stringArray.length == 0 ? string2 + "*" : string2 + StableUtils.join(stringArray, ",");
        string2 = string2 + " from (select t.*, rownum raak from(" + string + ") t) where raak > " + n + " and raak < " + (n2 + 1);
        return string2;
    }

    @Override
    public String getTopNRowSql(int n, Table table) {
        return "select * from " + this.table2SQL(table) + " where rownum <= " + n;
    }

    @Override
    public boolean isNULL(Object object) {
        return object == null || StringUtils.isEmpty(object.toString());
    }

    @Override
    public void notifyTriggerChange(java.sql.Connection connection, Table table, TriggerAction triggerAction) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("alter table ").append("\"").append(table.toString()).append("\"");
        if (triggerAction == TriggerAction.DISABLE) {
            stringBuffer.append(" disable all triggers");
        } else {
            stringBuffer.append(" enable all triggers");
            try {
                this.notifySequencesChange(connection, table);
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        }
        this.executeTrigger(connection, stringBuffer);
    }

    private void notifySequencesChange(java.sql.Connection connection, Table table) throws Exception {
        try {
            String string = "SELECT MAX(\"id\") from \"" + table.toString() + "\"";
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                long l = resultSet.getLong(1);
                if (l <= 0L) continue;
                this.changeSequences(connection, table, l);
            }
            resultSet.close();
            statement.close();
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
        }
    }

    private void changeSequences(java.sql.Connection connection, Table table, long l) throws Exception {
        String string = (table.toString() + "_seq").toUpperCase();
        String string2 = "ALTER SEQUENCE " + string + " INCREMENT BY " + l;
        String string3 = "SELECT " + string + ".NEXTVAL FROM DUAL";
        String string4 = "ALTER SEQUENCE " + string + " INCREMENT BY 1";
        Statement statement = null;
        try {
            connection.setAutoCommit(false);
            statement = connection.createStatement();
            statement.execute(string2);
            statement.execute(string3);
            statement.execute(string4);
            connection.commit();
            statement.close();
        }
        catch (SQLException sQLException) {
            if (connection != null) {
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException2) {
                    FRLogger.getLogger().error(sQLException.getMessage(), sQLException2);
                }
            }
            FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public boolean supportsUniqueViolationExceptionCheck() {
        return true;
    }

    @Override
    public boolean isUniqueViolationException(SQLException sQLException) {
        return sQLException != null && sQLException.getMessage() != null && sQLException.getMessage().indexOf("ORA-00001") > -1;
    }

    @Override
    public Object[] remoteProcedureCall(java.sql.Connection connection, String string) throws SQLException {
        Object[] objectArray = new Object[2];
        Statement statement = null;
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        int[] nArray = new int[]{1};
        if (string.indexOf("?") != -1) {
            int n = string.split("\\?").length - 1;
            statement = connection.prepareCall(string);
            preparedStatement = statement;
            for (int i = 1; i <= n; ++i) {
                preparedStatement.registerOutParameter(i, -10);
            }
        } else if (string.indexOf("$[") != -1) {
            OracleDialect.dealWithOracleProcedureStatement(connection, string, nArray, statement, (CallableStatement)preparedStatement);
        }
        preparedStatement.execute();
        if (preparedStatement instanceof OracleCallableStatement) {
            resultSet = ((OracleCallableStatement)preparedStatement).getCursor(nArray[0]);
        } else {
            Object object = preparedStatement.getObject(nArray[0]);
            if (object instanceof ResultSet) {
                resultSet = (ResultSet)object;
            } else {
                String string2 = object.toString();
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string2);
            }
        }
        objectArray[0] = statement;
        objectArray[1] = resultSet;
        return objectArray;
    }

    private static void dealWithOracleProcedureStatement(java.sql.Connection connection, String string, int[] nArray, Statement statement, CallableStatement callableStatement) throws SQLException {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n = 1;
        int n2 = 0;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n3;
            int n4;
            if ((n2 = string.indexOf("$[", n4 = n2)) < 0) {
                stringBuffer.append(string.substring(n4));
                break;
            }
            stringBuffer.append(string.substring(n4, n2));
            int n5 = string.indexOf("]$", n2 + 2);
            if (n5 <= n2) break;
            String string2 = string.substring(n2 + 2, n5);
            if (string2 == null || string2.length() <= 0) {
                n2 = n5 + 2;
                continue;
            }
            if (string2.startsWith("@")) {
                nArray[0] = n;
                string2 = string2.substring(1);
                bl = true;
            }
            if ((n3 = DataCoreUtils.calculateOracleType(string2)) == -10 && !bl) {
                nArray[0] = n;
                bl = true;
            }
            hashMap.put(new Integer(n), new Integer(n3));
            n2 = n5 + 2;
            stringBuffer.append('?');
            ++n;
        }
        statement = connection.prepareCall(stringBuffer.toString());
        callableStatement = (CallableStatement)statement;
        for (Integer n6 : hashMap.keySet()) {
            callableStatement.registerOutParameter((int)n6, (int)((Integer)hashMap.get(n6)));
        }
    }

    static {
        isInitSequenceProperties = false;
        oracleDialectSQLTypeHandlerFactory.register(91, new DBTimestampTypeHandler());
    }
}

