/*
 * Decompiled with CFR 0.152.
 */
package com.fr.clone.cloning;

import com.fr.clone.cloning.CloningException;
import com.fr.clone.cloning.FastClonerArrayList;
import com.fr.clone.cloning.FastClonerCalendar;
import com.fr.clone.cloning.FastClonerConcurrentHashMap;
import com.fr.clone.cloning.FastClonerHashMap;
import com.fr.clone.cloning.FastClonerHashSet;
import com.fr.clone.cloning.FastClonerLinkedList;
import com.fr.clone.cloning.FastClonerTreeMap;
import com.fr.clone.cloning.IDeepCloner;
import com.fr.clone.cloning.IDumpCloned;
import com.fr.clone.cloning.IFastCloner;
import com.fr.clone.cloning.IFreezable;
import com.fr.clone.cloning.IInstantiationStrategy;
import com.fr.clone.cloning.Immutable;
import com.fr.clone.cloning.ObjenesisInstantiationStrategy;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cloner {
    private final IInstantiationStrategy instantiationStrategy;
    private final Set<Class<?>> ignored = new HashSet();
    private final Set<Class<?>> ignoredInstanceOf = new HashSet();
    private final Set<Class<?>> nullInstead = new HashSet();
    private final Map<Class<?>, IFastCloner> fastCloners = new HashMap();
    private final Map<Object, Boolean> ignoredInstances = new IdentityHashMap<Object, Boolean>();
    private final ConcurrentHashMap<Class<?>, List<Field>> fieldsCache = new ConcurrentHashMap();
    private IDumpCloned dumpCloned = null;
    private boolean cloningEnabled = true;
    private boolean nullTransient = false;
    private boolean cloneSynthetics = true;
    private IDeepCloner deepCloner = new IDeepCloner(){

        @Override
        public <T> T deepClone(T t, Map<Object, Object> map) {
            try {
                return Cloner.this.cloneInternal(t, map);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalStateException(illegalAccessException);
            }
        }
    };
    private final ConcurrentHashMap<Class<?>, Boolean> immutables = new ConcurrentHashMap();
    private boolean cloneAnonymousParent = true;

    public IDumpCloned getDumpCloned() {
        return this.dumpCloned;
    }

    public void setDumpCloned(IDumpCloned iDumpCloned) {
        this.dumpCloned = iDumpCloned;
    }

    public Cloner() {
        this.instantiationStrategy = ObjenesisInstantiationStrategy.getInstance();
        this.init();
    }

    public Cloner(IInstantiationStrategy iInstantiationStrategy) {
        this.instantiationStrategy = iInstantiationStrategy;
        this.init();
    }

    public boolean isNullTransient() {
        return this.nullTransient;
    }

    public void setNullTransient(boolean bl) {
        this.nullTransient = bl;
    }

    public void setCloneSynthetics(boolean bl) {
        this.cloneSynthetics = bl;
    }

    private void init() {
        this.registerKnownJdkImmutableClasses();
        this.registerKnownConstants();
        this.registerFastCloners();
    }

    protected void registerFastCloners() {
        this.fastCloners.put(GregorianCalendar.class, new FastClonerCalendar());
        this.fastCloners.put(ArrayList.class, new FastClonerArrayList());
        this.fastCloners.put(LinkedList.class, new FastClonerLinkedList());
        this.fastCloners.put(HashSet.class, new FastClonerHashSet());
        this.fastCloners.put(HashMap.class, new FastClonerHashMap());
        this.fastCloners.put(TreeMap.class, new FastClonerTreeMap());
        this.fastCloners.put(ConcurrentHashMap.class, new FastClonerConcurrentHashMap());
    }

    protected Object fastClone(Object object, Map<Object, Object> map) throws IllegalAccessException {
        Class<?> clazz = object.getClass();
        IFastCloner iFastCloner = this.fastCloners.get(clazz);
        if (iFastCloner != null) {
            return iFastCloner.clone(object, this.deepCloner, map);
        }
        return null;
    }

    public void registerConstant(Object object) {
        this.ignoredInstances.put(object, true);
    }

    public void registerConstant(Class<?> clazz, String string) {
        try {
            Field field = clazz.getDeclaredField(string);
            field.setAccessible(true);
            Object object = field.get(null);
            this.ignoredInstances.put(object, true);
        }
        catch (SecurityException securityException) {
            throw new RuntimeException(securityException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException(noSuchFieldException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    protected void registerKnownJdkImmutableClasses() {
        this.registerImmutable(String.class);
        this.registerImmutable(Integer.class);
        this.registerImmutable(Long.class);
        this.registerImmutable(Boolean.class);
        this.registerImmutable(Class.class);
        this.registerImmutable(Float.class);
        this.registerImmutable(Double.class);
        this.registerImmutable(Character.class);
        this.registerImmutable(Byte.class);
        this.registerImmutable(Short.class);
        this.registerImmutable(Void.class);
        this.registerImmutable(BigDecimal.class);
        this.registerImmutable(BigInteger.class);
        this.registerImmutable(URI.class);
        this.registerImmutable(URL.class);
        this.registerImmutable(UUID.class);
        this.registerImmutable(Pattern.class);
    }

    protected void registerKnownConstants() {
        this.registerStaticFields(TreeSet.class, HashSet.class, HashMap.class, TreeMap.class);
    }

    public void registerStaticFields(Class<?> ... classArray) {
        for (Class<?> clazz : classArray) {
            List<Field> list = this.allFields(clazz);
            for (Field field : list) {
                int n = field.getModifiers();
                if (!Modifier.isStatic(n) || field.getType().isPrimitive()) continue;
                this.registerConstant(clazz, field.getName());
            }
        }
    }

    public void setExtraStaticFields(Set<Class<?>> set) {
        this.registerStaticFields((Class[])set.toArray());
    }

    public void dontClone(Class<?> ... classArray) {
        for (Class<?> clazz : classArray) {
            this.ignored.add(clazz);
        }
    }

    public void dontCloneInstanceOf(Class<?> ... classArray) {
        for (Class<?> clazz : classArray) {
            this.ignoredInstanceOf.add(clazz);
        }
    }

    public void setDontCloneInstanceOf(Class<?> ... classArray) {
        this.dontCloneInstanceOf(classArray);
    }

    public void nullInsteadOfClone(Class<?> ... classArray) {
        for (Class<?> clazz : classArray) {
            this.nullInstead.add(clazz);
        }
    }

    public void setExtraNullInsteadOfClone(Set<Class<?>> set) {
        this.nullInstead.addAll(set);
    }

    public void registerImmutable(Class<?> ... classArray) {
        for (Class<?> clazz : classArray) {
            this.ignored.add(clazz);
        }
    }

    public void setExtraImmutables(Set<Class<?>> set) {
        this.ignored.addAll(set);
    }

    public void registerFastCloner(Class<?> clazz, IFastCloner iFastCloner) {
        if (this.fastCloners.containsKey(clazz)) {
            throw new IllegalArgumentException(clazz + " already fast-cloned!");
        }
        this.fastCloners.put(clazz, iFastCloner);
    }

    public void unregisterFastCloner(Class<?> clazz) {
        this.fastCloners.remove(clazz);
    }

    protected <T> T newInstance(Class<T> clazz) {
        return this.instantiationStrategy.newInstance(clazz);
    }

    public <T> T fastCloneOrNewInstance(Class<T> clazz) {
        try {
            Object object = this.fastClone(clazz, null);
            if (object != null) {
                return (T)object;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        return this.newInstance(clazz);
    }

    public <T> T deepClone(T t) {
        if (t == null) {
            return null;
        }
        if (!this.cloningEnabled) {
            return t;
        }
        if (this.dumpCloned != null) {
            this.dumpCloned.startCloning(t.getClass());
        }
        IdentityHashMap<Object, Object> identityHashMap = new IdentityHashMap<Object, Object>(16);
        try {
            return this.cloneInternal(t, identityHashMap);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CloningException("error during cloning of " + t, illegalAccessException);
        }
    }

    public <T> T deepCloneDontCloneInstances(T t, Object ... objectArray) {
        if (t == null) {
            return null;
        }
        if (!this.cloningEnabled) {
            return t;
        }
        if (this.dumpCloned != null) {
            this.dumpCloned.startCloning(t.getClass());
        }
        IdentityHashMap<Object, Object> identityHashMap = new IdentityHashMap<Object, Object>(16);
        for (Object object : objectArray) {
            identityHashMap.put(object, object);
        }
        try {
            return this.cloneInternal(t, identityHashMap);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CloningException("error during cloning of " + t, illegalAccessException);
        }
    }

    public <T> T shallowClone(T t) {
        if (t == null) {
            return null;
        }
        if (!this.cloningEnabled) {
            return t;
        }
        try {
            return this.cloneInternal(t, null);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CloningException("error during cloning of " + t, illegalAccessException);
        }
    }

    protected boolean considerImmutable(Class<?> clazz) {
        return false;
    }

    protected Class<?> getImmutableAnnotation() {
        return Immutable.class;
    }

    private boolean isImmutable(Class<?> clazz) {
        Boolean bl = this.immutables.get(clazz);
        if (bl != null) {
            return bl;
        }
        if (this.considerImmutable(clazz)) {
            return true;
        }
        Class<?> clazz2 = this.getImmutableAnnotation();
        Object object = clazz.getDeclaredAnnotations();
        int n = ((Annotation[])object).length;
        for (int i = 0; i < n; ++i) {
            Annotation annotation = object[i];
            if (annotation.annotationType() != clazz2) continue;
            this.immutables.put(clazz, Boolean.TRUE);
            return true;
        }
        for (object = clazz.getSuperclass(); object != null && object != Object.class; object = ((Class)object).getSuperclass()) {
            for (Annotation annotation : ((Class)object).getDeclaredAnnotations()) {
                Immutable immutable;
                if (annotation.annotationType() != Immutable.class || !(immutable = (Immutable)annotation).subClass()) continue;
                this.immutables.put(clazz, Boolean.TRUE);
                return true;
            }
        }
        this.immutables.put(clazz, Boolean.FALSE);
        return false;
    }

    protected <T> T cloneInternal(T t, Map<Object, Object> map) throws IllegalAccessException {
        Object object;
        if (t == null) {
            return null;
        }
        if (t == this) {
            return null;
        }
        if (this.ignoredInstances.containsKey(t)) {
            return t;
        }
        if (t instanceof Enum) {
            return t;
        }
        Class<?> clazz = t.getClass();
        if (this.nullInstead.contains(clazz)) {
            return null;
        }
        if (this.ignored.contains(clazz)) {
            return t;
        }
        Object object2 = this.ignoredInstanceOf.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (!((Class)object).isAssignableFrom(clazz)) continue;
            return t;
        }
        if (this.isImmutable(clazz)) {
            return t;
        }
        if (t instanceof IFreezable && (object2 = (IFreezable)t).isFrozen()) {
            return t;
        }
        Object object3 = object2 = map != null ? map.get(t) : null;
        if (object2 != null) {
            return (T)object2;
        }
        object = this.fastClone(t, map);
        if (object != null) {
            if (map != null) {
                map.put(t, object);
            }
            return (T)object;
        }
        if (this.dumpCloned != null) {
            this.dumpCloned.startCloning(t.getClass());
        }
        if (clazz.isArray()) {
            return this.cloneArray(t, map);
        }
        return this.cloneObject(t, map, clazz);
    }

    private <T> T cloneObject(T t, Map<Object, Object> map, Class<T> clazz) throws IllegalAccessException {
        T t2 = this.newInstance(clazz);
        if (map != null) {
            map.put(t, t2);
        }
        List<Field> list = this.allFields(clazz);
        for (Field field : list) {
            boolean bl;
            int n = field.getModifiers();
            if (Modifier.isStatic(n) || this.nullTransient && Modifier.isTransient(n)) continue;
            Object object = field.get(t);
            boolean bl2 = bl = !(!this.cloneSynthetics && field.isSynthetic() || !this.cloneAnonymousParent && this.isAnonymousParent(field));
            Object object2 = map != null ? (bl ? this.cloneInternal(object, map) : object) : object;
            field.set(t2, object2);
            if (this.dumpCloned == null || object2 == object) continue;
            this.dumpCloned.cloning(field, t.getClass());
        }
        return t2;
    }

    private <T> T cloneArray(T t, Map<Object, Object> map) throws IllegalAccessException {
        Class<?> clazz = t.getClass();
        int n = Array.getLength(t);
        Object object = Array.newInstance(clazz.getComponentType(), n);
        if (map != null) {
            map.put(t, object);
        }
        if (clazz.getComponentType().isPrimitive() || this.isImmutable(clazz.getComponentType())) {
            System.arraycopy(t, 0, object, 0, n);
        } else {
            for (int i = 0; i < n; ++i) {
                Object object2 = Array.get(t, i);
                Object object3 = map != null ? this.cloneInternal(object2, map) : object2;
                Array.set(object, i, object3);
            }
        }
        return (T)object;
    }

    private boolean isAnonymousParent(Field field) {
        return "this$0".equals(field.getName());
    }

    public <T, E extends T> void copyPropertiesOfInheritedClass(T t, E e) {
        if (t == null) {
            throw new IllegalArgumentException("src can't be null");
        }
        if (e == null) {
            throw new IllegalArgumentException("dest can't be null");
        }
        Class<?> clazz = t.getClass();
        Class<?> clazz2 = e.getClass();
        if (clazz.isArray()) {
            if (!clazz2.isArray()) {
                throw new IllegalArgumentException("can't copy from array to non-array class " + clazz2);
            }
            int n = Array.getLength(t);
            for (int i = 0; i < n; ++i) {
                Object object = Array.get(t, i);
                Array.set(e, i, object);
            }
            return;
        }
        List<Field> list = this.allFields(clazz);
        List<Field> list2 = this.allFields(e.getClass());
        for (Field field : list) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            try {
                Object object = field.get(t);
                field.setAccessible(true);
                if (!list2.contains(field)) continue;
                field.set(e, object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
        }
    }

    private void addAll(List<Field> list, Field[] fieldArray) {
        for (Field field : fieldArray) {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            list.add(field);
        }
    }

    protected List<Field> allFields(Class<?> clazz) {
        List<Field> list = this.fieldsCache.get(clazz);
        if (list == null) {
            list = new LinkedList<Field>();
            Field[] fieldArray = clazz.getDeclaredFields();
            this.addAll(list, fieldArray);
            Class<?> clazz2 = clazz;
            while ((clazz2 = clazz2.getSuperclass()) != Object.class && clazz2 != null) {
                this.addAll(list, clazz2.getDeclaredFields());
            }
            this.fieldsCache.putIfAbsent(clazz, list);
        }
        return list;
    }

    public boolean isDumpClonedClasses() {
        return this.dumpCloned != null;
    }

    public void setDumpClonedClasses(boolean bl) {
        this.dumpCloned = bl ? new IDumpCloned(){

            @Override
            public void startCloning(Class<?> clazz) {
                System.out.println("clone>" + clazz);
            }

            @Override
            public void cloning(Field field, Class<?> clazz) {
                System.out.println("cloned field>" + field + "  -- of class " + clazz);
            }
        } : null;
    }

    public boolean isCloningEnabled() {
        return this.cloningEnabled;
    }

    public void setCloningEnabled(boolean bl) {
        this.cloningEnabled = bl;
    }

    public void setCloneAnonymousParent(boolean bl) {
        this.cloneAnonymousParent = bl;
    }

    public boolean isCloneAnonymousParent() {
        return this.cloneAnonymousParent;
    }

    public static Cloner standard() {
        return new Cloner();
    }

    public static Cloner shared() {
        return new Cloner(new ObjenesisInstantiationStrategy());
    }
}

