/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.background;

import com.fr.base.Base64;
import com.fr.base.BaseUtils;
import com.fr.base.GraphHelper;
import com.fr.base.background.AbstractBackground;
import com.fr.base.background.ImageSerializable;
import com.fr.general.Background;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.StableUtils;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class ImageBackground
extends AbstractBackground {
    private transient Image image = null;
    private int layout = 1;
    private int layout4Draw = 1;
    private double specifiedImageWidth = -1.0;
    private double specifiedImageHeight = -1.0;
    private static final int PAINT_WIDTH_OFFSET = 40;
    private static final int PAINT_HEIGHT_OFFSET = 40;
    private Point cellPoint = new Point(-1, -1);

    public ImageBackground() {
        this(null);
    }

    public ImageBackground(Image image) {
        this(image, 0);
    }

    public ImageBackground(Image image, int n) {
        this.setImage(image);
        this.setLayout(n);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public int getLayout() {
        return this.layout;
    }

    public int getLayout4Draw() {
        return this.layout4Draw == 1 ? this.layout : this.layout4Draw;
    }

    public void setLayout4Draw(int n) {
        this.layout4Draw = n;
    }

    public void setLayout(int n) {
        this.layout = n;
    }

    public Point getCellPoint() {
        return this.cellPoint;
    }

    public void setCellPoint(Point point) {
        this.cellPoint = point;
    }

    public Image getDefaultImage() {
        int n = (int)this.specifiedImageWidth;
        int n2 = (int)this.specifiedImageHeight;
        if (n == -1 && n2 == -1) {
            return this.getImage();
        }
        int n3 = n == -1 ? this.getImage().getWidth(null) : n;
        int n4 = n2 == -1 ? this.getImage().getHeight(null) : n2;
        BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage(n3, n4, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        this.paint(graphics2D, new Rectangle2D.Double(0.0, 0.0, n3, n4));
        bufferedImage.flush();
        graphics2D.dispose();
        return bufferedImage;
    }

    public double getSpecifiedImageWidth() {
        return this.specifiedImageWidth;
    }

    public void setSpecifiedImageWidth(double d) {
        this.specifiedImageWidth = d;
    }

    public double getSpecifiedImageHeight() {
        return this.specifiedImageHeight;
    }

    public void setSpecifiedImageHeight(double d) {
        this.specifiedImageHeight = d;
    }

    public void paint(Graphics graphics, Shape shape) {
        if (this.getImage() == null || shape == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(this.createPaint(shape, StableUtils.isNotSupportARGB(graphics2D)));
        graphics2D.fill(shape);
        graphics2D.setPaint(paint);
    }

    public void drawWithGradientLine(Graphics graphics, Shape shape) {
        if (this.getImage() == null || shape == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(this.createPaint(shape, StableUtils.isNotSupportARGB(graphics2D)));
        graphics2D.draw(shape);
        graphics2D.setPaint(paint);
    }

    public void layoutDidChange(int n, int n2) {
        int n3 = StableUtils.changeImageLayout4Draw(this.getImage(), this.getLayout(), n, n2);
        this.setLayout4Draw(n3);
    }

    private Paint createPaint(Shape shape, boolean bl) {
        Rectangle2D rectangle2D = shape.getBounds2D();
        if ((int)rectangle2D.getWidth() <= 0) {
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth() + 40.0, rectangle2D.getHeight());
        }
        if ((int)rectangle2D.getHeight() <= 0) {
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight() + 40.0);
        }
        BufferedImage bufferedImage = new BufferedImage((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), bl ? 1 : 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        GraphHelper.paintImage(graphics2D, (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), this.getImage(), this.getLayout4Draw(), 2, 1, (int)this.getSpecifiedImageWidth(), (int)this.getSpecifiedImageHeight(), bl);
        graphics2D.dispose();
        return new TexturePaint(bufferedImage, rectangle2D);
    }

    public void paint4Scroll(Graphics graphics, Shape shape, int n, int n2) {
        if (this.getImage() == null) {
            return;
        }
        Rectangle2D rectangle2D = shape.getBounds2D();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Shape shape2 = graphics2D.getClip();
        graphics2D.clip(shape);
        graphics2D.translate(rectangle2D.getX(), rectangle2D.getY());
        GraphHelper.paintImageMoved(graphics2D, (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), this.getImage(), this.getLayout(), 2, 1, (int)this.getSpecifiedImageWidth(), (int)this.getSpecifiedImageHeight(), n, n2, false);
        graphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
        graphics2D.setClip(shape2);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ImageBackground)) {
            return false;
        }
        ImageBackground imageBackground = (ImageBackground)object;
        return this.getLayout() == imageBackground.getLayout() && BaseUtils.imageEquals(this.getImage(), imageBackground.getImage()) && this.getSpecifiedImageWidth() == imageBackground.getSpecifiedImageWidth() && this.getSpecifiedImageHeight() == imageBackground.getSpecifiedImageHeight();
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("layout", this.layout);
        jSONObject.put("specifiedImageHeight", this.specifiedImageHeight);
        jSONObject.put("specifiedImageWidth", this.specifiedImageWidth);
        jSONObject.put("image", Base64.encode(this.getImage(), "png"));
        if (this.getImage() != null) {
            jSONObject.put("imgWidth", this.getImage().getWidth(null));
            jSONObject.put("imgHeight", this.getImage().getHeight(null));
        }
        return jSONObject;
    }

    public JSONObject toJSONObject(Repository repository, Dimension dimension) throws JSONException {
        JSONObject jSONObject = this.toJSONObject();
        BufferedImage bufferedImage = this.createBufferedImage(dimension.width, dimension.height);
        if (bufferedImage != null) {
            jSONObject.put("image", Base64.encode(bufferedImage, "png"));
        }
        return jSONObject;
    }

    public String getBackgroundType() {
        return "ImageBackground";
    }

    public Background readAdditionalAttr(XMLableReader xMLableReader) {
        this.setSpecifiedImageWidth(xMLableReader.getAttrAsDouble("specifiedImageWidth", -1.0));
        this.setSpecifiedImageHeight(xMLableReader.getAttrAsDouble("specifiedImageHeight", -1.0));
        this.setLayout(xMLableReader.getAttrAsInt("layout", 3));
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode()) {
                    if (xMLableReader.getTagName().equals("IM")) {
                        Image image = GeneralXMLTools.readImage(xMLableReader);
                        ImageBackground.this.setImage(image);
                        image = null;
                    } else if ("Image".equals(xMLableReader.getTagName())) {
                        Image image = GeneralXMLTools.deprecatedReadImage(xMLableReader);
                        ImageBackground.this.setImage(image);
                        image = null;
                    }
                }
            }
        });
        return this;
    }

    public void writeAdditionalAttr(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.attr("name", "ImageBackground");
        xMLPrintWriter.attr("specifiedImageWidth", this.getSpecifiedImageWidth()).attr("specifiedImageHeight", this.getSpecifiedImageHeight()).attr("layout", this.getLayout());
        if (this.getImage() != null) {
            GeneralXMLTools.writeImage(xMLPrintWriter, this.getImage());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        Object object = objectInputStream.readObject();
        if (object != null && object instanceof ImageSerializable) {
            this.image = ((ImageSerializable)object).getImage();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.image == null) {
            this.image = new BufferedImage(1, 1, 2);
        }
        ImageSerializable imageSerializable = new ImageSerializable(this.image);
        objectOutputStream.writeObject(imageSerializable);
    }
}

