/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.base.Env;
import com.fr.base.FRContext;
import com.fr.base.MapHelper;
import com.fr.file.XMLFileManager;
import com.fr.general.FRLogger;
import com.fr.general.GeneralContext;
import com.fr.general.Inter;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLTools;
import com.fr.stable.xml.XMLWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.io.IOException;
import java.io.InputStream;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class MapXMLHelper
extends XMLFileManager
implements XMLReadable,
XMLWriter,
MapHelper {
    private static MapXMLHelper mapXMLHelper = null;
    public static final String MAP_CATEGORY_WORLD = Inter.getLocText("FR-Chart-World_Map");
    public static final String MAP_CATEGORY_NATION = Inter.getLocText("FR-Chart-State_Map");
    public static final String MAP_CATEGORY_PROVINCE = Inter.getLocText("FR-Chart-Province_Map");
    public static final String MAP_CATEGORY_CUSTOMER = Inter.getLocText("FR-Chart-Custom_Map");
    private static HashMap cateMaps;
    private static HashMap mapAttrsMap;

    public static synchronized MapXMLHelper getInstance() {
        if (mapXMLHelper == null) {
            MapXMLHelper.readMapXml();
        }
        return mapXMLHelper;
    }

    public static boolean hasLoadMap() {
        return mapXMLHelper != null;
    }

    public void addCateNames(String string, Object object) {
        if (cateMaps.containsKey(string)) {
            List list = (List)cateMaps.get(string);
            if (!list.contains(object)) {
                list.add(object);
            }
        } else {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(object);
            cateMaps.put(string, arrayList);
        }
    }

    public List getNamesListWithCateName(Object object) {
        if (!cateMaps.containsKey(object)) {
            cateMaps.put(object, new ArrayList());
        }
        return (List)cateMaps.get(object);
    }

    public void clearCateNames() {
        cateMaps.clear();
    }

    public void reset() {
        cateMaps.clear();
        mapAttrsMap.clear();
    }

    public void pushMapAttr(String string, Object object) {
        mapAttrsMap.put(string, object);
    }

    public Object getMapAttr(String string) {
        if (mapAttrsMap.containsKey(string)) {
            return mapAttrsMap.get(string);
        }
        return null;
    }

    public void removeMapAttr(String string) {
        if (mapAttrsMap.containsKey(string)) {
            mapAttrsMap.remove(string);
        }
    }

    public JSONArray asJsonOfCategoriedMaps() throws JSONException {
        return new JSONArray().put(new JSONObject().put("category", MAP_CATEGORY_WORLD).put("map_names", this.getNamesListWithCateName(MAP_CATEGORY_WORLD))).put(new JSONObject().put("category", MAP_CATEGORY_NATION).put("map_names", this.getNamesListWithCateName(MAP_CATEGORY_NATION))).put(new JSONObject().put("category", MAP_CATEGORY_PROVINCE).put("map_names", this.getNamesListWithCateName(MAP_CATEGORY_PROVINCE))).put(new JSONObject().put("category", MAP_CATEGORY_CUSTOMER).put("map_names", this.getNamesListWithCateName(MAP_CATEGORY_CUSTOMER)));
    }

    public boolean containsMapName(String string) {
        return mapAttrsMap.containsKey(string);
    }

    public String[] mapAllNames() {
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object2 : mapAttrsMap.keySet()) {
            arrayList.add(object2.toString());
        }
        object2 = arrayList.toArray(new String[arrayList.size()]);
        Collator collator = Collator.getInstance(Locale.CHINA);
        Arrays.sort(object2, collator);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(Inter.getLocText("Chart-Use_None"));
        for (int i = 0; i < ((K)object2).length; ++i) {
            arrayList2.add((String)object2[i]);
        }
        return arrayList2.toArray(new String[arrayList2.size()]);
    }

    private static synchronized void envChanged() {
        mapXMLHelper = null;
    }

    private static void readMapXml() {
        if (mapXMLHelper == null) {
            mapXMLHelper = new MapXMLHelper();
        }
        mapXMLHelper.reset();
        mapXMLHelper.readXMLFile();
    }

    public String fileName() {
        return "chartmap/map.xml";
    }

    public void writerMapSourceWhenEditMap() {
        Env env = FRContext.getCurrentEnv();
        if (env == null) {
            return;
        }
        try {
            env.writeResource(mapXMLHelper);
        }
        catch (IOException iOException) {
            FRLogger.getLogger().error(Inter.getLocText(new String[]{"Chart-Map", "MConfig-SaveButton", "Failed"}));
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
    }

    public void readFromInputStream(InputStream inputStream) throws Exception {
        mapXMLHelper.reset();
        XMLTools.readInputStreamXML(mapXMLHelper, inputStream);
        GeneralContext.getEnvProvider().writeResource(mapXMLHelper);
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.getTagName().endsWith("OneMapAttr")) {
            final String string = xMLableReader.getAttrAsString("value", "");
            xMLableReader.readXMLObject(new XMLReadable(){

                public void readXML(XMLableReader xMLableReader) {
                    if (xMLableReader.getTagName().equals("One")) {
                        XMLable xMLable = GeneralXMLTools.readXMLable(xMLableReader);
                        if (StringUtils.isNotEmpty(string)) {
                            mapAttrsMap.put(string, xMLable);
                        }
                    }
                }
            });
        } else if (xMLableReader.getTagName().endsWith("CateMapNames")) {
            xMLableReader.readXMLObject(new XMLReadable(){

                public void readXML(XMLableReader xMLableReader) {
                    if (xMLableReader.getTagName().equals("OneCate")) {
                        String string = xMLableReader.getAttrAsString("cateName", "");
                        String string2 = xMLableReader.getAttrAsString("value", "");
                        MapXMLHelper.this.addCateNames(string, string2);
                    }
                }
            });
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("MapXMLHelper");
        for (Object object : mapAttrsMap.keySet()) {
            xMLPrintWriter.startTAG("OneMapAttr").attr("value", object.toString());
            GeneralXMLTools.writeXMLable(xMLPrintWriter, (XMLable)mapAttrsMap.get(object), "One");
            xMLPrintWriter.end();
        }
        xMLPrintWriter.startTAG("CateMapNames");
        for (String string : cateMaps.keySet()) {
            List list = (List)cateMaps.get(string);
            for (int i = 0; i < list.size(); ++i) {
                xMLPrintWriter.startTAG("OneCate");
                xMLPrintWriter.attr("cateName", string);
                xMLPrintWriter.attr("value", list.get(i).toString());
                xMLPrintWriter.end();
            }
        }
        xMLPrintWriter.end();
        xMLPrintWriter.end();
    }

    static {
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                MapXMLHelper.envChanged();
            }
        });
        cateMaps = new HashMap();
        mapAttrsMap = new HashMap();
    }
}

